/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.util;

import coldfusion.util.AbstractCache;
import java.util.HashMap;
import java.util.Iterator;

public abstract class GrumpyCache
extends AbstractCache {
    private long hits;
    private long misses = 1L;
    private final HashMap map;
    private int maxSize;

    public GrumpyCache() {
        this(100);
    }

    public GrumpyCache(int size) {
        this.map = new HashMap(size);
        this.maxSize = size;
    }

    @Override
    protected abstract Object fetch(Object var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(Object key) {
        Object value = null;
        GrumpyCache grumpyCache = this;
        synchronized (grumpyCache) {
            value = this.map.get(key);
            if (value != null) {
                ++this.hits;
                return value;
            }
            ++this.misses;
            this.reap();
        }
        value = this.fetch(key);
        this.put(key, value);
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Object key) {
        GrumpyCache grumpyCache = this;
        synchronized (grumpyCache) {
            this.map.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(Object key, Object value) {
        GrumpyCache grumpyCache = this;
        synchronized (grumpyCache) {
            this.map.put(key, value);
        }
    }

    @Override
    public void setSize(int size) {
        this.maxSize = size;
    }

    private void reap() {
        Object k1 = null;
        Object k2 = null;
        Object k3 = null;
        if (this.map.size() > this.maxSize) {
            int v3;
            int v2 = v3 = (int)(Math.random() * (double)this.map.size());
            int v1 = v3;
            while (v2 == v1) {
                v2 = (int)(Math.random() * (double)this.map.size());
            }
            while (v3 == v1 || v3 == v2) {
                v3 = (int)(Math.random() * (double)this.map.size());
            }
            Iterator it = this.map.keySet().iterator();
            for (int i = 0; i < this.map.size(); ++i) {
                Object nextKey = it.next();
                if (i == v1) {
                    k1 = nextKey;
                    continue;
                }
                if (i == v2) {
                    k2 = nextKey;
                    continue;
                }
                if (i != v3) continue;
                k3 = nextKey;
            }
            this.map.remove(k1);
            this.map.remove(k2);
            this.map.remove(k3);
        }
    }

    @Override
    public synchronized void clear() {
        this.hits = 0L;
        this.misses = 1L;
        this.map.clear();
    }

    static {
        System.out.println(GrumpyCache.class.toString());
        System.out.println("iteration 3");
    }
}

