/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.util;

import coldfusion.tools.IPUtils;
import coldfusion.util.CaseInsensitiveMap;
import java.lang.reflect.Method;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class IPAddressUtils {
    private static Method isLoopbackAddress_method = null;
    private static Method isReachable_method = null;
    private static final int isReachableTimeout = 5000;
    private static boolean isIPV6Available = false;
    private static Map hostMap = new CaseInsensitiveMap();

    private static boolean isIPReachable(InetAddress ip) {
        if (isReachable_method == null) {
            return false;
        }
        try {
            Boolean retObj = (Boolean)isReachable_method.invoke((Object)ip, new Integer(5000));
            return retObj;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isLocalHost(String ip) {
        Boolean isLocal = (Boolean)hostMap.get(ip);
        if (isLocal != null) {
            return isLocal;
        }
        boolean local = IPAddressUtils._isLocalHost(ip);
        hostMap.put(ip, local);
        return local;
    }

    private static boolean _isLocalHost(String ip) {
        InetAddress localHostAddress;
        if (ip == null || ip.trim().length() == 0) {
            return false;
        }
        if ("localhost".equalsIgnoreCase(ip)) {
            return true;
        }
        try {
            localHostAddress = InetAddress.getByName(ip);
        }
        catch (UnknownHostException e) {
            return false;
        }
        try {
            InetAddress[] allLocalHostAddresses;
            String hostName = InetAddress.getLocalHost().getHostName();
            for (InetAddress iAddress : allLocalHostAddresses = InetAddress.getAllByName(hostName)) {
                if (!iAddress.equals(localHostAddress)) continue;
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        if (isLoopbackAddress_method != null) {
            try {
                Object ret = isLoopbackAddress_method.invoke((Object)localHostAddress, new Object[]{null});
                if (((Boolean)ret).booleanValue()) {
                    if (isReachable_method != null) {
                        return IPAddressUtils.isIPReachable(localHostAddress);
                    }
                    return true;
                }
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        if (localHostAddress.getClass().getName().equals("java.net.Inet6Address") && (localHostAddress.getHostAddress().equals("::1") || localHostAddress.getHostAddress().equals("0:0:0:0:0:0:0:1"))) {
            return true;
        }
        if (localHostAddress.getClass().getName().equals("java.net.Inet4Address") && localHostAddress.getHostAddress().equals("127.0.0.1")) {
            return true;
        }
        return "127.0.0.1".equals(ip) || "::1".equals(ip) || "[::1]".equals(ip) || "0:0:0:0:0:0:0:1".equals(ip);
    }

    public static String getLocalHostIP() {
        try {
            InetAddress localAddress = InetAddress.getLocalHost();
            String className = localAddress.getClass().getName();
            if (className.equals("java.net.Inet6Address")) {
                return "::1";
            }
            return "127.0.0.1";
        }
        catch (UnknownHostException e) {
            return "";
        }
    }

    public static boolean isIPv6Address(InetAddress addr) {
        if (isIPV6Available) {
            return addr instanceof Inet6Address;
        }
        return false;
    }

    public static boolean isIPV6() {
        InetAddress[] inetAddress = IPUtils.getAllLocalIPs();
        for (int i = 0; i < inetAddress.length; ++i) {
            InetAddress addr = inetAddress[i];
            if (!IPAddressUtils.isIPv6Address(addr)) continue;
            return true;
        }
        return false;
    }

    public static boolean isIPV6(String hostname) {
        if (hostname.equalsIgnoreCase("localhost") || hostname.equalsIgnoreCase("127.0.0.1") || hostname.equalsIgnoreCase("[::1]") || hostname.equalsIgnoreCase("::1") || hostname.equalsIgnoreCase("0:0:0:0:0:0:0:1")) {
            return IPAddressUtils.isIPV6();
        }
        try {
            InetAddress[] inetAddresses = InetAddress.getAllByName(hostname);
            if (inetAddresses == null) {
                return false;
            }
            for (InetAddress inetAddress : inetAddresses) {
                if (!IPAddressUtils.isIPv6Address(inetAddress)) continue;
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public static String prepareLocalHostIPForPort() {
        Object localhost = IPAddressUtils.getLocalHostIP();
        if (((String)localhost).length() == 0) {
            return localhost;
        }
        if (((String)localhost).indexOf(46) < 0) {
            localhost = "[" + (String)localhost + "]";
        }
        return localhost;
    }

    public static boolean validateIPAdress(String ip) {
        if (ip.indexOf(46) > 0) {
            return IPAddressUtils.validateIPv4Address(ip);
        }
        if (ip.indexOf(58) > 0) {
            return IPAddressUtils.validateIPv6Address(ip);
        }
        return false;
    }

    public static boolean validateIPv4Address(String ip) {
        String LONGEST_IP_STRING = "255.255.255.255";
        if (ip.length() > LONGEST_IP_STRING.length()) {
            return false;
        }
        StringTokenizer tokenizer = new StringTokenizer(ip, ".");
        if (tokenizer.countTokens() != 4) {
            return false;
        }
        while (tokenizer.hasMoreTokens()) {
            int tokenValue;
            String token = tokenizer.nextToken();
            try {
                tokenValue = Integer.parseInt(token);
            }
            catch (NumberFormatException ne) {
                return false;
            }
            if (tokenValue >= 0 && tokenValue <= 255) continue;
            return false;
        }
        return true;
    }

    public static boolean validateIPv6Address(String ip) {
        String LONGEST_IP_STRING = "ffff.ffff.ffff.ffff:ffff:ffff:ffff:ffff";
        if (ip.length() > LONGEST_IP_STRING.length()) {
            return false;
        }
        if (ip.indexOf(58) == -1) {
            return false;
        }
        StringTokenizer tokenizer = new StringTokenizer(ip, ":");
        if (tokenizer.countTokens() > 8) {
            return false;
        }
        int maxValidIPNumber = 65535;
        while (tokenizer.hasMoreTokens()) {
            int tokenValue;
            String token = tokenizer.nextToken();
            if (token == null || token.length() == 0) continue;
            try {
                tokenValue = Integer.parseInt(token, 16);
            }
            catch (NumberFormatException ne) {
                return false;
            }
            if (tokenValue >= 0 && tokenValue <= maxValidIPNumber) continue;
            return false;
        }
        return true;
    }

    public static boolean matchIP(String ip, String allowedIP, boolean isIPv6) {
        boolean matched = true;
        String[] IParr = null;
        String[] allowedIParr = null;
        if (isIPv6) {
            IParr = ip.split(":");
            allowedIParr = allowedIP.split(":");
        } else {
            IParr = ip.split("\\.");
            allowedIParr = allowedIP.split("\\.");
        }
        if (IParr.length != allowedIParr.length) {
            return false;
        }
        for (int i = 0; i < IParr.length; ++i) {
            if (IParr[i].equals(allowedIParr[i]) || allowedIParr[i].equals("*")) continue;
            if (allowedIParr[i].indexOf("-") != -1) {
                int intIParr = Integer.valueOf(IParr[i]);
                String[] allowedIPPair = allowedIParr[i].split("-");
                try {
                    if (intIParr >= Integer.valueOf(allowedIPPair[0]) && intIParr <= Integer.valueOf(allowedIPPair[1])) continue;
                    matched = false;
                }
                catch (Exception ex) {
                    matched = false;
                }
                continue;
            }
            matched = false;
        }
        return matched;
    }

    public static String getExpandedIPNValidate(String ip) {
        boolean validIP = true;
        boolean isIPv6 = false;
        String[] IParr = null;
        try {
            if (ip.indexOf(42) != -1 || ip.indexOf(45) != -1) {
                if (ip.indexOf(58) != -1) {
                    isIPv6 = true;
                }
                if (isIPv6) {
                    if (!Pattern.matches("[0-9:\\-\\*]*", ip)) {
                        validIP = false;
                    } else {
                        IParr = ip.split(":");
                        if (IParr.length != 8) {
                            validIP = false;
                        }
                    }
                } else if (!Pattern.matches("[0-9\\.\\-\\*]*", ip)) {
                    validIP = false;
                } else {
                    IParr = ip.split("\\.");
                    if (IParr.length != 4) {
                        validIP = false;
                    }
                }
                if (validIP && !IPAddressUtils.scanIndividualIPTokenValidity(IParr)) {
                    validIP = false;
                }
            } else {
                InetAddress addr = InetAddress.getByName(ip);
                ip = addr.getHostAddress();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Not a valid address");
        }
        if (!validIP) {
            throw new RuntimeException("Not a valid address");
        }
        return ip;
    }

    private static boolean scanIndividualIPTokenValidity(String[] iparr) {
        for (int i = 0; i < iparr.length; ++i) {
            String token = iparr[i];
            if (Pattern.matches("[0-9\\-]*|[\\*]", token)) {
                int indexOfDash = token.indexOf(45);
                if (indexOfDash == -1 || indexOfDash != 0 && indexOfDash != token.length() - 1) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    static {
        try {
            isLoopbackAddress_method = InetAddress.class.getMethod("isLoopbackAddress", new Class[]{null});
        }
        catch (NoSuchMethodException e) {
            isLoopbackAddress_method = null;
        }
        try {
            isReachable_method = InetAddress.class.getMethod("isReachable", Integer.TYPE);
        }
        catch (NoSuchMethodException e) {
            isReachable_method = null;
        }
        try {
            Class.forName("java.net.Inet6Address");
            isIPV6Available = true;
        }
        catch (ClassNotFoundException ex) {
            isIPV6Available = false;
        }
    }
}

