/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.util;

import java.util.EmptyStackException;

public class IntStack {
    private int initialCapacity;
    private int[] stack;
    private int pos;

    public IntStack() {
        this(10);
    }

    public IntStack(int capacity) {
        if (capacity < 1) {
            throw new IllegalArgumentException("capacity < 1");
        }
        this.initialCapacity = capacity;
        this.stack = new int[this.initialCapacity];
        this.pos = -1;
    }

    public boolean empty() {
        return this.pos == -1;
    }

    public int pop() throws EmptyStackException {
        if (this.empty()) {
            throw new EmptyStackException();
        }
        int value = this.stack[this.pos--];
        if (this.empty()) {
            this.clear();
        }
        return value;
    }

    public int push(int value) {
        ++this.pos;
        if (this.pos >= this.stack.length) {
            int[] temp = new int[this.stack.length + this.initialCapacity];
            System.arraycopy(this.stack, 0, temp, 0, this.stack.length);
            this.stack = temp;
        }
        this.stack[this.pos] = value;
        return value;
    }

    public int peek() throws EmptyStackException {
        if (this.empty()) {
            throw new EmptyStackException();
        }
        return this.stack[this.pos];
    }

    public void clear() {
        this.pos = -1;
        if (this.stack.length > this.initialCapacity) {
            this.stack = new int[this.initialCapacity];
        }
    }
}

