/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class MP3File
extends File {
    public static final int MODE_STEREO = 0;
    public static final int MODE_JOINT_STEREO = 1;
    public static final int MODE_DUAL_CHANNEL = 2;
    public static final int MODE_SINGLE_CHANNEL = 3;
    public static final int MPEG_VERSION_25 = 0;
    public static final int MPEG_VERSION_2 = 2;
    public static final int MPEG_VERSION_1 = 3;
    public static final int MONO = 3;
    private static int[][] mp3bitRates = new int[][]{{0, 0, 0, 0, 0}, {32, 32, 32, 32, 8}, {64, 48, 40, 48, 16}, {96, 56, 48, 56, 24}, {128, 64, 56, 64, 32}, {160, 80, 64, 80, 40}, {192, 96, 80, 96, 48}, {224, 112, 96, 112, 56}, {256, 128, 112, 128, 64}, {288, 160, 128, 144, 80}, {320, 192, 160, 160, 96}, {352, 224, 192, 176, 112}, {384, 256, 224, 192, 128}, {416, 320, 256, 224, 144}, {448, 384, 320, 256, 160}, {-1, -1, -1, -1, -1}};
    private static int[][] versionLayerArray = new int[][]{{-1, 4, 4, 3}, {-1, -1, -1, -1}, {-1, 4, 4, 3}, {-1, 2, 1, 0}};
    private static int[][] frequencyArr = new int[][]{{11025, 12000, 8000}, {0, 0, 0}, {22050, 24000, 16000}, {44100, 48000, 32000}};
    private int bitRate;
    private int version;
    private long duration;
    private int frequency;
    private boolean copyRighted;
    private boolean original;
    private int channelMode;

    public MP3File(String path) throws IOException {
        super(path);
        this.readHeader();
    }

    public MP3File(File parent, String child) throws IOException {
        super(parent, child);
        this.readHeader();
    }

    public MP3File(String parent, String child) throws IOException {
        super(parent, child);
        this.readHeader();
    }

    private void readHeader() throws IOException {
        BufferedInputStream in = null;
        try {
            byte[] header;
            in = new BufferedInputStream(new FileInputStream(this));
            do {
                if ((header = this.getHeader(in)) != null) continue;
                throw new InvalidMP3FormatException(this.getPath());
            } while (!this.isValidHeader(header));
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private byte[] getHeader(BufferedInputStream in) throws IOException {
        int b;
        byte[] header = new byte[4];
        int state = 0;
        while ((b = in.read()) != -1) {
            if (state == 0) {
                if (b != 255) continue;
                state = 1;
                continue;
            }
            if (state == 1) {
                if ((b >> 5 & 7) == 7) {
                    header[0] = -1;
                    header[1] = (byte)b;
                    state = 2;
                    continue;
                }
                state = 0;
                continue;
            }
            header[2] = (byte)b;
            b = in.read();
            if (b != -1) {
                header[3] = (byte)b;
                break;
            }
            return null;
        }
        if (state == 2) {
            return header;
        }
        return null;
    }

    private boolean isValidHeader(byte[] header) {
        boolean isValid;
        int version = header[1] >> 3 & 3;
        int layer = header[1] >> 1 & 3;
        int bitrateBits = header[2] >> 4 & 0xF;
        int frequencyBits = header[2] >> 2 & 3;
        int channelMode = header[3] >> 6 & 3;
        int copyRight = header[3] >> 3 & 1;
        int original = header[3] >> 2 & 1;
        int emphasis = header[3] & 3;
        boolean bl = isValid = version != 1 && layer != 0 && bitrateBits != 0 && bitrateBits != 15 && frequencyBits != 3 && emphasis != 2;
        if (isValid) {
            int bitRateColumn = versionLayerArray[version][layer];
            this.bitRate = mp3bitRates[bitrateBits][bitRateColumn];
            this.version = version;
            this.duration = this.length() * 8L / (long)(this.bitRate * 1000);
            this.frequency = frequencyArr[version][frequencyBits];
            this.copyRighted = copyRight == 1;
            this.original = original == 1;
            this.channelMode = channelMode;
        }
        return isValid;
    }

    public int getBitRate() {
        return this.bitRate;
    }

    public int getVersion() {
        return this.version;
    }

    public long getDuration() {
        return this.duration;
    }

    public int getFrequency() {
        return this.frequency;
    }

    public boolean isCopyRighted() {
        return this.copyRighted;
    }

    public boolean isOriginal() {
        return this.original;
    }

    public int getChannelMode() {
        return this.channelMode;
    }

    public static class InvalidMP3FormatException
    extends RuntimeException {
        public String file;

        public InvalidMP3FormatException(String file) {
            this.file = file;
        }
    }
}

