/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.util;

import coldfusion.runtime.NeoException;
import java.util.HashMap;
import java.util.Map;

public class MemorySemaphore {
    private static Map semaphoreMap = new HashMap();
    private long maxMemAllowed = 0xC800000L;
    private long totalMemUsed;
    private int queueSize;

    private MemorySemaphore() {
    }

    public static synchronized MemorySemaphore getInstance(String key) {
        MemorySemaphore semaphore = (MemorySemaphore)semaphoreMap.get(key);
        if (semaphore == null) {
            semaphore = new MemorySemaphore();
            semaphoreMap.put(key, semaphore);
        }
        return semaphore;
    }

    public void setMaxAllowedMemory(long mem) {
        this.maxMemAllowed = mem;
    }

    public long getMaxAllowedMemory() {
        return this.maxMemAllowed;
    }

    public long getTotalMemUsed() {
        return this.totalMemUsed;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public synchronized void acquire(long memoryReqd) throws MemoryUnavailableException, InterruptedException {
        if (memoryReqd >= this.maxMemAllowed) {
            throw new MemoryUnavailableException(this.maxMemAllowed, memoryReqd);
        }
        while (this.totalMemUsed + memoryReqd >= this.maxMemAllowed) {
            try {
                ++this.queueSize;
                this.wait();
            }
            finally {
                --this.queueSize;
            }
        }
        this.totalMemUsed += memoryReqd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void acquire(long memoryReqd, long waitTime) throws MemoryUnavailableException, InterruptedException {
        if (memoryReqd >= this.maxMemAllowed) {
            throw new MemoryUnavailableException(this.maxMemAllowed, memoryReqd);
        }
        while (this.totalMemUsed + memoryReqd >= this.maxMemAllowed) {
            try {
                ++this.queueSize;
                this.wait(waitTime);
            }
            finally {
                --this.queueSize;
            }
        }
        this.totalMemUsed += memoryReqd;
    }

    public synchronized void release(long memorySize) {
        this.totalMemUsed -= memorySize;
        if (this.totalMemUsed < 0L) {
            this.totalMemUsed = 0L;
        }
        this.notifyAll();
    }

    public static class MemoryUnavailableException
    extends NeoException {
        public long max;
        public long requested;

        public MemoryUnavailableException(long max, long requested) {
            this.max = max;
            this.requested = requested;
        }
    }
}

