/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.util;

import coldfusion.util.CaseInsensitiveHashtable;
import coldfusion.util.IteratorEnumeration;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;

public class OrderedCaseInsensitiveHashtable
extends CaseInsensitiveHashtable {
    private ArrayList orderedKeys = new ArrayList();
    private ArrayList orderedElements = new ArrayList();

    public Iterator iterator() {
        return this.orderedElements.iterator();
    }

    public Object get(int index) {
        return this.orderedElements.get(index);
    }

    public Iterator getKeys() {
        return new ArrayList(this.orderedKeys).iterator();
    }

    @Override
    public synchronized Enumeration keys() {
        return new IteratorEnumeration(this.getKeys());
    }

    @Override
    public Object put(Object key, Object value) {
        Object obj = super.put(key, value);
        String lowerKey = key.toString().toLowerCase();
        if (obj != null) {
            int index = this.orderedKeys.indexOf(lowerKey);
            this.orderedKeys.remove(index);
            this.orderedElements.remove(index);
        }
        this.orderedKeys.add(lowerKey);
        this.orderedElements.add(value);
        return obj;
    }

    @Override
    public Object remove(Object key) {
        Object obj = super.remove(key);
        String lowerKey = key.toString().toLowerCase();
        int index = this.orderedKeys.indexOf(lowerKey);
        this.orderedKeys.remove(index);
        this.orderedElements.remove(index);
        return obj;
    }

    @Override
    public void clear() {
        super.clear();
        this.orderedKeys.clear();
        this.orderedElements.clear();
    }
}

