/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.util;

import coldfusion.util.RB;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class OrderedProperties
extends Properties
implements Serializable {
    private Vector keys = new Vector();
    private Hashtable comment_blocks = new Hashtable();
    private static final String whitespace = " \t\n\r\f";
    private static final String terminators = "=";
    private static final String valterminators = "\n\r\f";
    private static final String escapes = "#!=";
    private boolean handleBackslash = false;
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public OrderedProperties() {
    }

    public OrderedProperties(OrderedProperties props) {
        Enumeration k = props.keys();
        while (k.hasMoreElements()) {
            String key = (String)k.nextElement();
            this.put(key, props.getProperty(key));
        }
    }

    public void setHandleBackslash(boolean handleBackslash) {
        this.handleBackslash = handleBackslash;
    }

    @Override
    public int size() {
        return this.keys.size();
    }

    @Override
    public String getProperty(String property) {
        Object o = super.get(property);
        if (o != null && o instanceof String) {
            return (String)o;
        }
        return null;
    }

    @Override
    public String getProperty(String property, String defaultval) {
        Object o = super.get(property);
        String val = null;
        if (o != null && o instanceof String) {
            val = (String)o;
        }
        return val != null ? val : defaultval;
    }

    public void replaceProperty(String property, String value) {
        super.put(property, value);
    }

    public Object putProperty(String property, String value) {
        return this.putProperty(null, property, value);
    }

    @Override
    public Object setProperty(String property, String value) {
        return this.putProperty(null, property, value);
    }

    public Object putProperty(String comment, String property, String value) {
        Object old = super.put(property, value);
        if (comment != null) {
            this.comment_blocks.put(property, comment);
        }
        if (old == null) {
            this.keys.addElement(property);
        }
        return old;
    }

    @Override
    public Object get(Object property) {
        return super.get(property);
    }

    @Override
    public Object put(Object key, Object value) {
        Object old = super.put(key, value);
        if (old == null) {
            this.keys.addElement(key);
        }
        return old;
    }

    @Override
    public Object remove(Object key) {
        Object old = super.remove(key);
        this.comment_blocks.remove(key);
        if (old != null) {
            this.keys.removeElement(key);
        }
        return old;
    }

    @Override
    public Enumeration keys() {
        return this.keys.elements();
    }

    public Enumeration propertyNames() {
        return this.keys.elements();
    }

    @Override
    public void clear() {
        if (super.size() > 0) {
            super.clear();
        }
        if (this.comment_blocks.size() > 0) {
            this.comment_blocks.clear();
        }
        this.keys.setSize(0);
    }

    @Override
    public boolean contains(Object value) {
        return super.contains(value);
    }

    public boolean containsKey(String key) {
        return super.containsKey(key);
    }

    public Properties getProperties(String propPattern) {
        Properties props = new Properties();
        int index = propPattern.indexOf("*");
        if (index == -1) {
            String value = this.getProperty(propPattern);
            if (value != null) {
                props.put(propPattern, value);
            }
        } else {
            String startsWith = propPattern.substring(0, index);
            String endsWith = index == propPattern.length() - 1 ? null : propPattern.substring(index + 1);
            Enumeration names = this.propertyNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                if (!name.startsWith(startsWith)) continue;
                if (endsWith == null) {
                    props.put(name, this.getProperty(name));
                    continue;
                }
                if (!name.endsWith(endsWith)) continue;
                props.put(name, this.getProperty(name));
            }
        }
        return props;
    }

    public void removeProperties(String propPattern) {
        int index = propPattern.indexOf("*");
        if (index == -1) {
            String value = this.getProperty(propPattern);
            if (value != null) {
                this.remove(propPattern);
            }
        } else {
            String startsWith = propPattern.substring(0, index);
            String endsWith = index == propPattern.length() - 1 ? null : propPattern.substring(index + 1);
            Vector cle = (Vector)this.keys.clone();
            int size = cle.size();
            for (int i = 0; i < size; ++i) {
                String name = (String)cle.elementAt(i);
                if (!name.startsWith(startsWith)) continue;
                if (endsWith == null) {
                    this.remove(name);
                    continue;
                }
                if (!name.endsWith(endsWith)) continue;
                this.remove(name);
            }
        }
    }

    public void setProperties(Properties props) {
        Enumeration<?> names = props.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            this.setProperty(name, props.getProperty(name));
        }
    }

    @Override
    public void load(InputStream is) throws IOException {
        this.load2(new BufferedReader(new InputStreamReader(is)));
    }

    @Override
    public void load(Reader reader) throws IOException {
        this.load2(new BufferedReader(reader));
    }

    public void load2(BufferedReader br) throws IOException {
        String line;
        StringBuffer buffer = new StringBuffer(100);
        int comment_length = 0;
        String sep = System.getProperty("line.separator");
        int sep_len = sep.length();
        while ((line = br.readLine()) != null) {
            int start;
            String comment = null;
            int len = line.length();
            for (start = 0; start < len && whitespace.indexOf(line.charAt(start)) != -1; ++start) {
            }
            if (line.trim().length() == 0) {
                buffer.append(sep);
                comment_length += sep_len;
                continue;
            }
            if (len == 0 || line.charAt(start) == '!' || line.charAt(start) == '#' || whitespace.indexOf(line.charAt(start)) != -1) {
                buffer.append(line + sep);
                comment_length += len + sep_len;
                continue;
            }
            if (comment_length != 0) {
                buffer.setLength(comment_length);
                comment = buffer.toString();
            }
            buffer.setLength(0);
            buffer.append(line.substring(start));
            int total_length = len;
            while (line.charAt(line.length() - 1) == '\\') {
                int new_start;
                buffer.setLength(line.length() - 1);
                line = br.readLine();
                if (line == null) continue;
                len = line.length();
                for (new_start = 0; new_start < len && whitespace.indexOf(line.charAt(new_start)) != -1; ++new_start) {
                }
                buffer.append(line.substring(new_start));
                total_length += line.length() - new_start;
            }
            String com_key = this.loadProperty(buffer.toString(), total_length);
            if (comment_length != 0 && com_key != null) {
                this.comment_blocks.put(com_key, comment);
                comment = null;
                comment_length = 0;
            }
            buffer.setLength(0);
        }
    }

    public void store(PrintWriter writer) {
        this.store2(writer, null);
    }

    public void store(OutputStream os) {
        this.store2(new PrintWriter(os), null);
    }

    @Override
    public void store(OutputStream os, String header) {
        this.store2(new PrintWriter(os), header);
    }

    private void store2(PrintWriter out, String header) {
        if (header != null) {
            out.println("#" + header);
            out.println("#" + new Date().toString());
        }
        Enumeration ke = this.keys.elements();
        while (ke.hasMoreElements()) {
            String key = (String)ke.nextElement();
            String value = (String)super.get(key);
            String comment = (String)this.comment_blocks.get(key);
            if (comment != null) {
                out.print(comment);
            }
            out.print(this.escape(key));
            out.print('=');
            out.println(this.escape(value));
        }
        out.flush();
    }

    private String loadProperty(String prop, int length) {
        int prop_index;
        String key = null;
        String value = null;
        int prop_len = prop.length();
        for (prop_index = 0; prop_index < prop_len; ++prop_index) {
            char current = prop.charAt(prop_index);
            if (current == '\\') {
                ++prop_index;
                continue;
            }
            if (terminators.indexOf(current) != -1) break;
        }
        key = this.unescape(prop.substring(0, prop_index));
        while (prop_index < prop.length() && whitespace.indexOf(prop.charAt(prop_index)) != -1) {
            ++prop_index;
        }
        try {
            if (prop.charAt(prop_index) == ':' || prop.charAt(prop_index) == '=') {
                ++prop_index;
                while (prop_index < prop.length() && whitespace.indexOf(prop.charAt(prop_index)) != -1) {
                    ++prop_index;
                }
            }
        }
        catch (StringIndexOutOfBoundsException ex) {
            return null;
        }
        int value_start = prop_index;
        while (prop_index < prop.length()) {
            char current = prop.charAt(prop_index);
            if (current == '\\') {
                ++prop_index;
            } else if (valterminators.indexOf(current) != -1) break;
            ++prop_index;
        }
        value = this.unescape(prop.substring(value_start, prop_index));
        if (!super.containsKey(key)) {
            this.keys.addElement(key);
        }
        super.put(key, value);
        return key;
    }

    private String escape(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer(string.length() + 10);
        block6: for (int i = 0; i < string.length(); ++i) {
            char current = string.charAt(i);
            switch (current) {
                case '\\': {
                    buffer.append('\\');
                    buffer.append('\\');
                    continue block6;
                }
                case '\t': {
                    buffer.append('\\');
                    buffer.append('t');
                    continue block6;
                }
                case '\n': {
                    buffer.append('\\');
                    buffer.append('n');
                    continue block6;
                }
                case '\r': {
                    buffer.append('\\');
                    buffer.append('r');
                    continue block6;
                }
                default: {
                    if (current < '\u0014' || current > '\u007f') {
                        buffer.append('\\');
                        buffer.append('u');
                        buffer.append(OrderedProperties.toHex(current >> 12 & 0xF));
                        buffer.append(OrderedProperties.toHex(current >> 8 & 0xF));
                        buffer.append(OrderedProperties.toHex(current >> 4 & 0xF));
                        buffer.append(OrderedProperties.toHex(current >> 0 & 0xF));
                        continue block6;
                    }
                    buffer.append(current);
                }
            }
        }
        return buffer.toString();
    }

    private String unescape(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer(string.length());
        int string_index = 0;
        while (string_index < string.length()) {
            char add;
            if ((add = string.charAt(string_index++)) == '\\') {
                if ((add = string.charAt(string_index++)) == 'u') {
                    int unicode = 0;
                    block12: for (int i = 0; i < 4; ++i) {
                        add = string.charAt(string_index++);
                        switch (add) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                unicode = (unicode << 4) + add - 48;
                                continue block12;
                            }
                            case 'a': 
                            case 'b': 
                            case 'c': 
                            case 'd': 
                            case 'e': 
                            case 'f': {
                                unicode = (unicode << 4) + 10 + add - 97;
                                continue block12;
                            }
                            case 'A': 
                            case 'B': 
                            case 'C': 
                            case 'D': 
                            case 'E': 
                            case 'F': {
                                unicode = (unicode << 4) + 10 + add - 65;
                                continue block12;
                            }
                            default: {
                                throw new IllegalArgumentException(RB.getString(this, "OrderedProperties.MalformedEncoding"));
                            }
                        }
                    }
                    add = (char)unicode;
                } else {
                    switch (add) {
                        case 't': {
                            add = '\t';
                            break;
                        }
                        case 'n': {
                            add = '\n';
                            break;
                        }
                        case 'r': {
                            add = '\r';
                            break;
                        }
                        case 'f': {
                            add = '\f';
                            break;
                        }
                        default: {
                            if (!this.handleBackslash || add == 92) break;
                            buffer.append('/');
                        }
                    }
                }
                buffer.append(add);
                continue;
            }
            buffer.append(add);
        }
        return buffer.toString();
    }

    private static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }

    @Override
    public void save(OutputStream os, String header) {
        this.store(os);
    }

    public static void main(String[] args) {
        try {
            FileInputStream fis = new FileInputStream(args[0]);
            OrderedProperties p = new OrderedProperties();
            Properties props = new Properties();
            p.load(fis);
            fis.close();
            fis = new FileInputStream(args[0]);
            props.load(fis);
            p.store(System.out);
            System.out.println("-------");
            props.save(System.out, null);
        }
        catch (IOException e) {
            System.out.println(e);
        }
    }
}

