/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.util;

import coldfusion.log.CFLogs;
import coldfusion.server.CFService;
import coldfusion.server.RuntimeService;
import coldfusion.server.ServiceFactory;
import java.io.File;

public class ReportDecoder {
    public static native byte[] getReport(byte[] var0);

    static {
        block24: {
            String suffix = null;
            String fileExtension = ".so";
            String x = System.getProperty("os.name");
            String libPath = CFService.getLibPath();
            if (libPath == null) {
                try {
                    RuntimeService service = ServiceFactory.getRuntimeService();
                    libPath = service.getLibDir();
                }
                catch (ServiceFactory.ServiceNotAvailableException service) {
                    // empty catch block
                }
            }
            if (x != null) {
                if ((x = x.toUpperCase()).startsWith("WINDOWS")) {
                    suffix = "win";
                    fileExtension = ".dll";
                } else if (x.startsWith("LINUX")) {
                    suffix = "linux";
                } else if (x.startsWith("SUNOS") || x.startsWith("SOLARIS")) {
                    suffix = "solaris";
                } else if (x.startsWith("MAC")) {
                    suffix = "osx";
                    fileExtension = ".jnilib";
                } else if (x.startsWith("AIX")) {
                    suffix = "aix";
                } else if (x.startsWith("HP")) {
                    suffix = "hpux";
                }
                if (suffix != null) {
                    try {
                        String arch = System.getProperty("os.arch");
                        if (arch.indexOf("ppc") != -1 && suffix.equals("linux")) {
                            System.load(libPath + File.separator + "libnvr_powerlinux" + fileExtension);
                            break block24;
                        }
                        if (arch.indexOf("64") != -1 && (suffix.equals("linux") || suffix.equals("win"))) {
                            System.load(libPath + File.separator + (suffix.equals("linux") ? "libnvr_" : "nvr_") + suffix + "64" + fileExtension);
                            break block24;
                        }
                        System.load(libPath + File.separator + (suffix.equals("win") ? "nvr_" : "libnvr_") + suffix + fileExtension);
                    }
                    catch (Throwable e) {
                        String suffix32 = suffix + "32";
                        try {
                            System.load(libPath + File.separator + (suffix.equals("win") ? "nvr_" : "libnvr_") + suffix32 + fileExtension);
                        }
                        catch (Throwable e2) {
                            CFLogs.SERVER_LOG.warn("Unable to load library: nvr_" + suffix + ": " + e.toString(), e);
                        }
                    }
                } else {
                    CFLogs.SERVER_LOG.warn("Unable to load reporting library: Unrecognized OS: " + x);
                }
            } else {
                CFLogs.SERVER_LOG.warn("Unable to load reporting library: os.name System property not set");
            }
        }
    }
}

