/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.util;

public class SHA1 {
    private static final boolean hexcase = true;
    private static final String b64pad = "=";
    private static final int chrsz = 8;

    public static String b64_hmac_sha1(String key, String data) {
        return SHA1.binb2b64(SHA1.core_hmac_sha1(key, data));
    }

    public static String b64_sha1(String s) {
        s = s == null ? "" : s;
        return SHA1.binb2b64(SHA1.core_sha1(SHA1.str2binb(s), s.length() * 8));
    }

    private static String binb2b64(int[] binarray) {
        String tab = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
        Object str = "";
        binarray = SHA1.strechBinArray(binarray, binarray.length * 4);
        for (int i = 0; i < binarray.length * 4; i += 3) {
            int triplet = (binarray[i >> 2] >> 8 * (3 - i % 4) & 0xFF) << 16 | (binarray[i + 1 >> 2] >> 8 * (3 - (i + 1) % 4) & 0xFF) << 8 | binarray[i + 2 >> 2] >> 8 * (3 - (i + 2) % 4) & 0xFF;
            for (int j = 0; j < 4; ++j) {
                str = i * 8 + j * 6 > binarray.length * 32 ? (String)str + b64pad : (String)str + tab.charAt(triplet >> 6 * (3 - j) & 0x3F);
            }
        }
        return SHA1.cleanB64Str((String)str);
    }

    private static String binb2hex(int[] binarray) {
        String hex_tab = "0123456789ABCDEF";
        Object str = "";
        for (int i = 0; i < binarray.length * 4; ++i) {
            char a = hex_tab.charAt(binarray[i >> 2] >> (3 - i % 4) * 8 + 4 & 0xF);
            char b = hex_tab.charAt(binarray[i >> 2] >> (3 - i % 4) * 8 & 0xF);
            str = (String)str + new Character(a).toString() + new Character(b).toString();
        }
        return str;
    }

    private static String binb2str(int[] bin) {
        Object str = "";
        int mask = 255;
        for (int i = 0; i < bin.length * 32; i += 8) {
            str = (String)str + (char)(bin[i >> 5] >>> 24 - i % 32 & mask);
        }
        return str;
    }

    private static String cleanB64Str(String str) {
        int len = (str = str == null ? "" : str).length();
        if (len <= 1) {
            return str;
        }
        char trailChar = str.charAt(len - 1);
        Object trailStr = "";
        for (int i = len - 1; i >= 0 && str.charAt(i) == trailChar; --i) {
            trailStr = (String)trailStr + str.charAt(i);
        }
        return str.substring(0, str.indexOf((String)trailStr));
    }

    private static int[] complete216(int[] oldbin) {
        if (oldbin.length >= 16) {
            return oldbin;
        }
        int[] newbin = new int[16 - oldbin.length];
        for (int i = 0; i < newbin.length; ++i) {
            newbin[i] = 0;
        }
        return SHA1.concat(oldbin, newbin);
    }

    private static int[] concat(int[] oldbin, int[] newbin) {
        int[] retval = new int[oldbin.length + newbin.length];
        for (int i = 0; i < oldbin.length + newbin.length; ++i) {
            retval[i] = i < oldbin.length ? oldbin[i] : newbin[i - oldbin.length];
        }
        return retval;
    }

    private static int[] core_hmac_sha1(String key, String data) {
        int i;
        key = key == null ? "" : key;
        data = data == null ? "" : data;
        int[] bkey = SHA1.complete216(SHA1.str2binb(key));
        if (bkey.length > 16) {
            bkey = SHA1.core_sha1(bkey, key.length() * 8);
        }
        int[] ipad = new int[16];
        int[] opad = new int[16];
        for (i = 0; i < 16; ++i) {
            ipad[i] = 0;
            opad[i] = 0;
        }
        for (i = 0; i < 16; ++i) {
            ipad[i] = bkey[i] ^ 0x36363636;
            opad[i] = bkey[i] ^ 0x5C5C5C5C;
        }
        int[] hash = SHA1.core_sha1(SHA1.concat(ipad, SHA1.str2binb(data)), 512 + data.length() * 8);
        return SHA1.core_sha1(SHA1.concat(opad, hash), 672);
    }

    private static int[] core_sha1(int[] x, int len) {
        int size = len >> 5;
        x = SHA1.strechBinArray(x, size);
        int n = len >> 5;
        x[n] = x[n] | 128 << 24 - len % 32;
        size = (len + 64 >> 9 << 4) + 15;
        x = SHA1.strechBinArray(x, size);
        x[(len + 64 >> 9 << 4) + 15] = len;
        int[] w = new int[80];
        int a = 1732584193;
        int b = -271733879;
        int c = -1732584194;
        int d = 271733878;
        int e = -1009589776;
        for (int i = 0; i < x.length; i += 16) {
            int olda = a;
            int oldb = b;
            int oldc = c;
            int oldd = d;
            int olde = e;
            for (int j = 0; j < 80; ++j) {
                w[j] = j < 16 ? x[i + j] : SHA1.rol(w[j - 3] ^ w[j - 8] ^ w[j - 14] ^ w[j - 16], 1);
                int t = SHA1.safe_add(SHA1.safe_add(SHA1.rol(a, 5), SHA1.sha1_ft(j, b, c, d)), SHA1.safe_add(SHA1.safe_add(e, w[j]), SHA1.sha1_kt(j)));
                e = d;
                d = c;
                c = SHA1.rol(b, 30);
                b = a;
                a = t;
            }
            a = SHA1.safe_add(a, olda);
            b = SHA1.safe_add(b, oldb);
            c = SHA1.safe_add(c, oldc);
            d = SHA1.safe_add(d, oldd);
            e = SHA1.safe_add(e, olde);
        }
        int[] retval = new int[]{a, b, c, d, e};
        return retval;
    }

    public static String hex_hmac_sha1(String key, String data) {
        return SHA1.binb2hex(SHA1.core_hmac_sha1(key, data));
    }

    public static String hex_sha1(String s) {
        s = s == null ? "" : s;
        return SHA1.binb2hex(SHA1.core_sha1(SHA1.str2binb(s), s.length() * 8));
    }

    private static int rol(int num, int cnt) {
        return num << cnt | num >>> 32 - cnt;
    }

    private static int safe_add(int x, int y) {
        int lsw = (x & 0xFFFF) + (y & 0xFFFF);
        int msw = (x >> 16) + (y >> 16) + (lsw >> 16);
        return msw << 16 | lsw & 0xFFFF;
    }

    private static int sha1_ft(int t, int b, int c, int d) {
        if (t < 20) {
            return b & c | ~b & d;
        }
        if (t < 40) {
            return b ^ c ^ d;
        }
        if (t < 60) {
            return b & c | b & d | c & d;
        }
        return b ^ c ^ d;
    }

    private static int sha1_kt(int t) {
        return t < 20 ? 1518500249 : (t < 40 ? 1859775393 : (t < 60 ? -1894007588 : -899497514));
    }

    public static String str_hmac_sha1(String key, String data) {
        return SHA1.binb2str(SHA1.core_hmac_sha1(key, data));
    }

    public static String str_sha1(String s) {
        s = s == null ? "" : s;
        return SHA1.binb2str(SHA1.core_sha1(SHA1.str2binb(s), s.length() * 8));
    }

    private static int[] str2binb(String str) {
        str = str == null ? "" : str;
        int[] tmp = new int[str.length() * 8];
        int mask = 255;
        for (int i = 0; i < str.length() * 8; i += 8) {
            int n = i >> 5;
            tmp[n] = tmp[n] | (str.charAt(i / 8) & mask) << 24 - i % 32;
        }
        int len = 0;
        int i = 0;
        while (i < tmp.length && tmp[i] != 0) {
            ++i;
            ++len;
        }
        int[] bin = new int[len];
        for (int i2 = 0; i2 < len; ++i2) {
            bin[i2] = tmp[i2];
        }
        return bin;
    }

    private static int[] strechBinArray(int[] oldbin, int size) {
        int i;
        int currlen = oldbin.length;
        if (currlen >= size + 1) {
            return oldbin;
        }
        int[] newbin = new int[size + 1];
        for (i = 0; i < size; ++i) {
            newbin[i] = 0;
        }
        for (i = 0; i < currlen; ++i) {
            newbin[i] = oldbin[i];
        }
        return newbin;
    }
}

