/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.util;

public class Semaphore {
    private int count;
    private int maxCount;
    private Thread owner;

    public Semaphore(int n) {
        this.count = n;
        this.maxCount = n;
    }

    public synchronized void acquire() {
        while (this.count == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.owner = Thread.currentThread();
        --this.count;
    }

    public synchronized void acquire(long timeout) throws InterruptedException {
        while (this.count == 0) {
            this.wait(timeout);
        }
        this.owner = Thread.currentThread();
        --this.count;
    }

    public synchronized void release() {
        ++this.count;
        this.owner = null;
        this.notify();
    }

    public int getCount() {
        return this.count;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public String toString() {
        return "State: " + this.count + " Owner: " + this.owner == null ? "null" : this.owner.toString();
    }
}

