/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.util;

import coldfusion.util.Utils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.security.auth.x500.X500Principal;

public class SignedJarVerifier {
    private static boolean verifiedSelfIntegrity = false;

    public static final X509Certificate[] getTrustedCA(String certPath, long checksum) {
        X509Certificate[] certs = null;
        try {
            File certfile = new File(certPath);
            if (Utils.getFileCheckSum(certfile) != checksum) {
                return null;
            }
            FileInputStream is = new FileInputStream(certfile);
            ByteArrayOutputStream out = new ByteArrayOutputStream(8192);
            byte[] buffer = new byte[8192];
            byte[] certBytes = null;
            int n = -1;
            while ((n = is.read(buffer, 0, buffer.length)) != -1) {
                out.write(buffer, 0, n);
            }
            certBytes = out.toByteArray();
            is.close();
            out.close();
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream in = new ByteArrayInputStream(certBytes);
            X509Certificate cert = (X509Certificate)factory.generateCertificate(in);
            if (cert != null) {
                certs = new X509Certificate[]{cert};
            }
        }
        catch (Exception e) {
            return null;
        }
        return certs;
    }

    public static final synchronized boolean selfIntegrityChecking(Class clazz, X509Certificate[] trustedCaCerts, String trustedSubject) {
        JarFile jf;
        if (verifiedSelfIntegrity) {
            return true;
        }
        URL providerURL = SignedJarVerifier.getProviderURL(clazz);
        if (providerURL == null) {
            return false;
        }
        try {
            URL url = providerURL;
            jf = new JarFile(new File(url.getPath()));
        }
        catch (IOException ioe) {
            return false;
        }
        try {
            SignedJarVerifier.verifySingleJarFile(jf, trustedCaCerts, trustedSubject);
        }
        catch (Exception e) {
            return false;
        }
        verifiedSelfIntegrity = true;
        return true;
    }

    private static final URL getProviderURL(Class c) {
        final Class cc = c;
        return (URL)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                CodeSource s1 = cc.getProtectionDomain().getCodeSource();
                return s1.getLocation();
            }
        });
    }

    private static final void verifySingleJarFile(JarFile jf, X509Certificate[] trustedCaCerts, String trustedSubject) throws IOException {
        Vector<JarEntry> entriesVec = new Vector<JarEntry>();
        Manifest man = jf.getManifest();
        if (man == null) {
            throw new SecurityException("unsigned jar file");
        }
        byte[] buffer = new byte[8192];
        Enumeration<JarEntry> entries = jf.entries();
        while (entries.hasMoreElements()) {
            JarEntry je = entries.nextElement();
            entriesVec.addElement(je);
            InputStream is = jf.getInputStream(je);
            while (is.read(buffer, 0, buffer.length) != -1) {
            }
            is.close();
        }
        jf.close();
        Enumeration e = entriesVec.elements();
        while (e.hasMoreElements()) {
            JarEntry je = (JarEntry)e.nextElement();
            if (je.isDirectory()) continue;
            Certificate[] certs = je.getCertificates();
            if (certs == null || certs.length == 0) {
                if (je.getName().startsWith("META-INF")) continue;
                throw new SecurityException("unsigned class files.");
            }
            String subjectDN = ((X509Certificate)certs[0]).getSubjectDN().toString();
            if (subjectDN.indexOf(trustedSubject) < 0) {
                throw new SecurityException("untrusted class files.");
            }
            Certificate[] chainRoots = SignedJarVerifier.getChainRoots(certs);
            boolean signedAsExpected = false;
            for (int i = 0; i < chainRoots.length; ++i) {
                if (!SignedJarVerifier.isTrusted((X509Certificate)chainRoots[i], trustedCaCerts)) continue;
                signedAsExpected = true;
                break;
            }
            if (signedAsExpected) continue;
            throw new SecurityException("jar file is not signed by a trusted signer");
        }
    }

    private static final boolean isTrusted(X509Certificate cert, X509Certificate[] trustedCaCerts) {
        Principal trustedSubjectDN;
        int i;
        if (cert == null || trustedCaCerts == null) {
            return false;
        }
        for (i = 0; i < trustedCaCerts.length; ++i) {
            X500Principal certSubjectDN = cert.getSubjectX500Principal();
            if (!certSubjectDN.equals(trustedSubjectDN = trustedCaCerts[i].getSubjectDN()) || !cert.equals(trustedCaCerts[i])) continue;
            return true;
        }
        for (i = 0; i < trustedCaCerts.length; ++i) {
            X500Principal certIssuerDN = cert.getIssuerX500Principal();
            if (!certIssuerDN.equals(trustedSubjectDN = trustedCaCerts[i].getSubjectDN())) continue;
            try {
                cert.verify(trustedCaCerts[i].getPublicKey());
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private static final Certificate[] getChainRoots(Certificate[] certs) {
        Vector<Certificate> result = new Vector<Certificate>(3);
        for (int i = 0; i < certs.length - 1; ++i) {
            if (((X509Certificate)certs[i + 1]).getSubjectDN().equals(((X509Certificate)certs[i]).getIssuerDN())) continue;
            result.addElement(certs[i]);
        }
        result.addElement(certs[certs.length - 1]);
        Object[] ret = new Certificate[result.size()];
        result.copyInto(ret);
        return ret;
    }
}

