/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.util;

import coldfusion.util.AbstractCache;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.ConcurrentHashMap;

public abstract class SoftCache
extends AbstractCache {
    private final ConcurrentHashMap<Object, ValueRef> map;
    private final ReferenceQueue refq = new ReferenceQueue();
    private static boolean statsEnabled = false;
    private Stats stats;
    public static final String cacheEval = AccessController.doPrivileged(new PrivilegedAction<String>(){

        @Override
        public String run() {
            return System.getProperty("cacheEval");
        }
    });

    public SoftCache() {
        this(100, Stats.FALSE);
    }

    public SoftCache(Stats stats) {
        this(100, stats);
    }

    public SoftCache(int size) {
        this(size, Stats.FALSE);
    }

    public SoftCache(int size, Stats stats) {
        this.map = new ConcurrentHashMap(size);
        this.stats = stats;
    }

    public static void setStatsEnabled(boolean enable) {
        statsEnabled = enable;
    }

    @Override
    public Object get(Object key) {
        if (this.stats == Stats.FALSE || this.stats == Stats.RUNTIME && !statsEnabled) {
            return this.get_statsOff(key);
        }
        return this.get_statsOn(key);
    }

    public Object getNoFetch(Object key) {
        Object value;
        ValueRef ref = this.map.get(key);
        if (ref != null && (value = ref.get()) != null) {
            return value instanceof Null ? null : value;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object get_statsOn(Object key) {
        Object value;
        SoftCache softCache = this;
        synchronized (softCache) {
            ValueRef ref = this.map.get(key);
            if (ref != null && (value = ref.get()) != null) {
                ++this.hits;
                ++ref.hits;
                return value instanceof Null ? null : value;
            }
            ++this.misses;
            this.reap();
        }
        long before = System.currentTimeMillis();
        value = this.fetch(key);
        int penalty = (int)(System.currentTimeMillis() - before);
        this.missPenalty += (long)penalty;
        SoftCache softCache2 = this;
        synchronized (softCache2) {
            ValueRef ref = this.map.put(key, new ValueRef(key, value == null ? new Null() : value, this.refq, penalty));
            this.rmStats(ref);
        }
        return value;
    }

    private Object get_statsOff(Object key) {
        Object value;
        ValueRef ref = this.map.get(key);
        if (ref != null && (value = ref.get()) != null) {
            return value instanceof Null ? null : value;
        }
        this.reap();
        value = this.fetch(key);
        if (cacheEval != null && cacheEval.equalsIgnoreCase("true")) {
            if (value == null || !value.toString().startsWith("Statement")) {
                this.map.put(key, new ValueRef(key, value == null ? new Null() : value, this.refq, 0));
            }
        } else {
            this.map.put(key, new ValueRef(key, value == null ? new Null() : value, this.refq, 0));
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Object key) {
        ValueRef ref = this.map.remove(key);
        if (this.stats == Stats.TRUE || this.stats == Stats.RUNTIME && statsEnabled) {
            SoftCache softCache = this;
            synchronized (softCache) {
                this.rmStats(ref);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void put(Object key, Object value) {
        ValueRef ref = this.map.put(key, new ValueRef(key, value == null ? new Null() : value, this.refq, -1));
        if (this.stats == Stats.TRUE || this.stats == Stats.RUNTIME && statsEnabled) {
            SoftCache softCache = this;
            synchronized (softCache) {
                this.rmStats(ref);
            }
        }
    }

    @Override
    public void setSize(int size) {
    }

    private void reap() {
        ValueRef ref = (ValueRef)this.refq.poll();
        if (ref != null) {
            this.report();
            do {
                ref = this.map.remove(ref.key);
                this.rmStats(ref);
            } while ((ref = (ValueRef)this.refq.poll()) != null);
        }
    }

    private void rmStats(ValueRef ref) {
        if (ref != null) {
            this.hits -= (long)ref.hits;
            --this.misses;
            if (ref.penalty != -1) {
                this.missPenalty -= (long)ref.penalty;
            }
        }
    }

    @Override
    public synchronized void clear() {
        this.map.clear();
        while (this.refq.poll() != null) {
        }
    }

    public static enum Stats {
        FALSE,
        RUNTIME,
        TRUE;

    }

    private static final class ValueRef
    extends SoftReference {
        final Object key;
        int hits;
        final int penalty;

        ValueRef(Object key, Object value, ReferenceQueue refq, int penalty) {
            super(value, refq);
            this.key = key;
            this.penalty = penalty;
        }
    }

    private static final class Null {
        private Null() {
        }
    }
}

