/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.util;

import coldfusion.util.TreeHashMultiMap;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SortedStructMap<K, V>
implements Map<K, V>,
Serializable {
    private static final long serialVersionUID = -1940067294255043944L;
    private Map<K, V> hashBasedMap = new HashMap();
    private Map<Entry<K, V>, V> comparatorBasedMap;
    private final transient Comparator<? super Entry<K, V>> comparator;
    transient int modCount;
    private volatile transient Set<K> keySet;
    private volatile transient Collection<V> values;
    private volatile transient Set<Map.Entry<K, V>> entrySet;

    public SortedStructMap() {
        this.comparator = null;
        this.comparatorBasedMap = new TreeHashMultiMap<Entry<K, V>, V>();
    }

    public SortedStructMap(Comparator<? super Entry<K, V>> comparator) {
        this.comparator = comparator;
        this.comparatorBasedMap = new TreeHashMultiMap<Entry<Entry<K, V>, V>, V>(comparator);
    }

    @Override
    public int size() {
        return this.hashBasedMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.hashBasedMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.hashBasedMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.hashBasedMap.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.hashBasedMap.get(key);
    }

    @Override
    public V put(K key, V value) {
        boolean firstRemove = false;
        if (this.hashBasedMap.containsKey(key)) {
            firstRemove = true;
        } else {
            ++this.modCount;
        }
        V oldValue = this.hashBasedMap.put(key, value);
        Entry<K, V> entryKey = new Entry<K, V>(key, value);
        if (firstRemove) {
            this.comparatorBasedMap.remove(new Entry<K, V>(key, oldValue));
        }
        this.comparatorBasedMap.put(entryKey, value);
        return oldValue;
    }

    @Override
    public V remove(Object key) {
        if (this.hashBasedMap.containsKey(key)) {
            ++this.modCount;
        }
        V hValue = this.hashBasedMap.remove(key);
        try {
            this.comparatorBasedMap.remove(new Entry<Object, V>(key, hValue));
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return hValue;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.hashBasedMap.clear();
        this.comparatorBasedMap.clear();
        ++this.modCount;
    }

    @Override
    public Set<K> keySet() {
        KeySet ks = this.keySet;
        return ks == null ? (this.keySet = new KeySet()) : ks;
    }

    @Override
    public Collection<V> values() {
        Values vs = this.values;
        return vs == null ? (this.values = new Values()) : vs;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet es = this.entrySet;
        return es == null ? (this.entrySet = new EntrySet()) : es;
    }

    private final boolean valEquals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    private MapEntry<K, V> newMapEntry(Entry<K, V> entry) {
        return new MapEntry<K, V>(entry);
    }

    public Comparator<? super Entry<K, V>> getComparator() {
        return this.comparator;
    }

    public final class Entry<Key, Value>
    implements Comparable<Entry<Key, Value>> {
        private Key key;
        private Value value;

        public Entry(Key key, Value value) {
            this.key = key;
            this.value = value;
        }

        public int hashCode() {
            int keyHash = this.getKey() == null ? 0 : this.getKey().hashCode();
            return keyHash;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Entry)) {
                return false;
            }
            Entry e = (Entry)obj;
            return this.valEquals(this.getKey(), e.getKey());
        }

        public boolean valueEquals(Object obj) {
            if (!(obj instanceof Entry)) {
                return false;
            }
            Entry e = (Entry)obj;
            return this.valEquals(this.getValue(), e.getValue());
        }

        final boolean valEquals(Object o1, Object o2) {
            return o1 == null ? o2 == null : o1.equals(o2);
        }

        public Key getKey() {
            return this.key;
        }

        public Value getValue() {
            return this.value;
        }

        private Value setValue(Value value) {
            Value oldValue = this.getValue();
            this.value = value;
            return oldValue;
        }

        @Override
        public int compareTo(Entry<Key, Value> o) {
            if (o.getKey() instanceof Comparable && this.getKey() instanceof Comparable) {
                return ((Comparable)this.getKey()).compareTo(o);
            }
            return 0;
        }
    }

    private class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return SortedStructMap.this.comparatorBasedMap.size();
        }
    }

    private class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return SortedStructMap.this.comparatorBasedMap.size();
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public int size() {
            return SortedStructMap.this.comparatorBasedMap.size();
        }
    }

    private class MapEntry<Key, Value>
    implements Map.Entry<Key, Value> {
        Entry<Key, Value> entry;

        public MapEntry(Entry<Key, Value> entry) {
            this.entry = entry;
        }

        @Override
        public Key getKey() {
            return this.entry.getKey();
        }

        @Override
        public Value getValue() {
            return this.entry.getValue();
        }

        @Override
        public Value setValue(Value value) {
            SortedStructMap.this.hashBasedMap.put(this.getKey(), value);
            return this.entry.setValue(value);
        }

        @Override
        public int hashCode() {
            return (this.entry.getKey() == null ? 0 : this.entry.getKey().hashCode()) ^ (this.entry.getValue() == null ? 0 : this.entry.getValue().hashCode());
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof MapEntry) {
                MapEntry meo = (MapEntry)o;
                return (this.entry.getKey() == null ? meo.getKey() == null : this.entry.getKey().equals(meo.getKey())) && (this.entry.getValue() == null ? meo.getValue() == null : this.entry.getValue().equals(meo.getValue()));
            }
            return false;
        }
    }

    private abstract class SortedStructMapEntryIterator<E>
    implements Iterator<E> {
        Entry<K, V> current;
        Iterator<Entry<K, V>> entriesIterator;
        protected int expectedModCount;

        SortedStructMapEntryIterator() {
            this.entriesIterator = SortedStructMap.this.comparatorBasedMap.keySet().iterator();
            this.expectedModCount = SortedStructMap.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.entriesIterator.hasNext();
        }

        @Override
        public void remove() {
            if (this.expectedModCount != SortedStructMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.current != null) {
                SortedStructMap.this.hashBasedMap.remove(this.current.getKey());
            }
            this.entriesIterator.remove();
            this.expectedModCount = SortedStructMap.this.modCount;
        }

        Entry<K, V> nextEntry() {
            this.current = this.entriesIterator.next();
            return this.current;
        }
    }

    private class ValueIterator
    extends SortedStructMapEntryIterator<V> {
        private ValueIterator() {
        }

        @Override
        public V next() {
            if (this.expectedModCount != SortedStructMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
            return this.nextEntry().getValue();
        }
    }

    private class KeyIterator
    extends SortedStructMapEntryIterator<K> {
        private KeyIterator() {
        }

        @Override
        public K next() {
            if (this.expectedModCount != SortedStructMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
            return this.nextEntry().getKey();
        }
    }

    private class EntryIterator
    extends SortedStructMapEntryIterator<Map.Entry<K, V>> {
        private EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            if (this.expectedModCount != SortedStructMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
            return SortedStructMap.this.newMapEntry(this.nextEntry());
        }
    }
}

