/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.util;

import coldfusion.log.CFLogs;
import coldfusion.util.KeytoolUtils;
import coldfusion.util.RB;
import com.adobe.coldfusion.entman.ProcessServer;
import com.adobe.coldfusion.launcher.ServerConfigParser;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.jasper.JasperException;

public class SslUtils {
    private static final String SERVER_XML = "server.xml";
    private static final String RSA = "RSA";
    private static final String XML_COMMENT_OPEN = "<!--";
    private static final String XML_COMMENT_CLOSE = "-->";
    private ServerConfigParser serverConfigParser;

    public SslUtils() {
        this.parseServerXml();
    }

    public boolean generateKeyAndCertificate(String dname, String keystoreFileName, String password, boolean setInServerXml) {
        KeytoolUtils keytoolUtils = new KeytoolUtils();
        boolean retVal = keytoolUtils.generateKeyAndCertificate(dname, keystoreFileName, password);
        if (setInServerXml) {
            String selfSignedCertPath = this.getConfigAbsolutePath() + keystoreFileName;
            this.updateServerXml(selfSignedCertPath, password, RSA, setInServerXml, true);
        }
        return retVal;
    }

    public void updateServerXml(String certificatePath, String certificatePassword, String certificateAlgorithm, boolean enableHttps, boolean enableHttp) {
        String serverXmlPath = this.getConfigAbsolutePath() + SERVER_XML;
        try {
            this.updateFile(serverXmlPath, certificatePath, certificatePassword, certificateAlgorithm, enableHttps, enableHttp);
        }
        catch (IOException e) {
            CFLogs.SERVER_LOG.error(e.getMessage(), e);
        }
    }

    private String getConfigAbsolutePath() {
        return System.getProperty("coldfusion.home") + "/runtime/conf/";
    }

    private void updateFile(String fileName, String certificatePath, String certificatePassword, String certificateAlgorithm, boolean enableHttps, boolean enableHttp) throws IOException {
        ArrayList<Object> newLines = new ArrayList<Object>();
        Pattern httpsPattern = Pattern.compile("Connector.*protocol.*Http11NioProtocol");
        Pattern httpPattern = Pattern.compile("Connector.*protocol=\"HTTP/1.1");
        Pattern certificatePattern = Pattern.compile("Certificate.*certificateKeystoreFile");
        for (String line : Files.readAllLines(Paths.get(fileName, new String[0]), StandardCharsets.UTF_8)) {
            if (httpsPattern.matcher(line).find()) {
                if (enableHttps && line.contains(XML_COMMENT_OPEN)) {
                    line = line.replace(XML_COMMENT_OPEN, "");
                    int httpsPort = 8443;
                    while (!ProcessServer.isPortAvailable((int)httpsPort)) {
                        ++httpsPort;
                    }
                    line = line.replaceAll("port=\"\\d+\"", "port=\"" + httpsPort + "\"");
                } else if (!enableHttps && !line.contains(XML_COMMENT_OPEN)) {
                    line = line.replace("<Connector", "<!--<Connector");
                }
                newLines.add(line);
                continue;
            }
            if (certificatePattern.matcher(line).find()) {
                newLines.add("<Certificate certificateKeystoreFile=\"" + certificatePath + "\" certificateKeystorePassword=\"" + certificatePassword + "\" type=\"" + certificateAlgorithm + "\" />");
                continue;
            }
            if (line.contains("</Connector>")) {
                if (enableHttps && line.contains(XML_COMMENT_CLOSE)) {
                    line = line.replace(XML_COMMENT_CLOSE, "");
                } else if (!enableHttps && !line.contains(XML_COMMENT_CLOSE)) {
                    line = line.replace("</Connector>", "</Connector>-->");
                }
                newLines.add(line);
                continue;
            }
            if (httpPattern.matcher(line).find()) {
                if (enableHttp && line.contains(XML_COMMENT_OPEN)) {
                    line = line.replace(XML_COMMENT_OPEN, "");
                    line = line.replace(XML_COMMENT_CLOSE, "");
                } else if (!enableHttp && !line.contains(XML_COMMENT_OPEN)) {
                    line = line.replace("<Connector", "<!--<Connector");
                    line = line.replace("/>", "/>-->");
                }
                newLines.add(line);
                continue;
            }
            newLines.add(line);
        }
        int backupIndex = this.getBackupFileIndex(fileName);
        Files.copy(Paths.get(fileName, new String[0]), Paths.get(fileName + "." + backupIndex, new String[0]), new CopyOption[0]);
        Files.write(Paths.get(fileName, new String[0]), newLines, StandardCharsets.UTF_8, new OpenOption[0]);
    }

    private int getBackupFileIndex(String fileName) {
        int index = 1;
        while (new File(fileName + "." + index).exists()) {
            ++index;
        }
        return index;
    }

    public Map<String, String> getSslHostConfig() {
        HashMap<String, String> hostConfigData = null;
        hostConfigData = this.serverConfigParser.sslHostConfig();
        if (hostConfigData == null) {
            hostConfigData = new HashMap<String, String>();
            hostConfigData.put("https", Boolean.toString(false));
        } else {
            hostConfigData.put("https", Boolean.toString(true));
        }
        hostConfigData.put("http", Boolean.toString(this.serverConfigParser.hasConnectorDefined(true)));
        return hostConfigData;
    }

    public int getSslPort() {
        String sslPort = this.serverConfigParser.getSslPort();
        if (sslPort != null) {
            return Integer.parseInt(sslPort);
        }
        return -1;
    }

    private void parseServerXml() {
        String serverXmlPath = this.getConfigAbsolutePath() + SERVER_XML;
        this.serverConfigParser = new ServerConfigParser(serverXmlPath);
        try {
            this.serverConfigParser.parse();
        }
        catch (JasperException e) {
            CFLogs.SERVER_LOG.error(RB.getString(SslUtils.class, "ServerXmlParseError"), e);
        }
    }
}

