/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.util;

import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.runtime.Array;
import coldfusion.runtime.Struct;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;

public class StackTraceUtils {
    private static Logger logger = CFLogs.SERVER_LOG;
    public static final String PAGE = "runPage";
    public static final String FUNC = "$func";
    public static final String RUNFUNCTION = "runFunction";
    public static final String FACTOR = "_factor";
    public static final String COLON = ":";

    public static List java2cfStack(StackTraceElement[] jstack) {
        Array list = new Array();
        StackTraceElement jstackframe = null;
        String funcName = "";
        try {
            for (int i = 0; i < jstack.length; ++i) {
                Struct node;
                jstackframe = jstack[i];
                int fdx = 0;
                String funcString = "";
                String lineNo = "";
                int idx = jstackframe.getClassName().indexOf(FUNC);
                if (idx != -1) {
                    fdx = jstackframe.getMethodName().indexOf(RUNFUNCTION);
                    if (fdx == -1) continue;
                    funcName = jstackframe.getClassName().substring(idx + FUNC.length());
                    funcString = jstackframe.getFileName();
                    lineNo = String.valueOf(jstackframe.getLineNumber());
                    node = new Struct();
                    node.put("Function", (Object)funcName);
                    node.put("Template", (Object)funcString);
                    node.put("LineNumber", (Object)lineNo);
                    list.add(node);
                    continue;
                }
                idx = jstackframe.getMethodName().indexOf(PAGE);
                if (idx == -1) continue;
                jstackframe = jstack[i - 1];
                if (jstackframe.getMethodName().indexOf(FACTOR) != -1) {
                    int j = i - 1;
                    while (jstackframe.getMethodName().indexOf(FACTOR) != -1) {
                        jstackframe = jstack[--j];
                    }
                    jstackframe = jstack[j + 1];
                    funcString = jstackframe.getFileName();
                    lineNo = String.valueOf(jstackframe.getLineNumber());
                    Struct node2 = new Struct();
                    node2.put("Function", (Object)"");
                    node2.put("Template", (Object)funcString);
                    node2.put("LineNumber", (Object)lineNo);
                    list.add(node2);
                }
                jstackframe = jstack[i];
                funcString = jstackframe.getFileName();
                lineNo = String.valueOf(jstackframe.getLineNumber());
                node = new Struct();
                node.put("Function", (Object)"");
                node.put("Template", (Object)funcString);
                node.put("LineNumber", (Object)lineNo);
                list.add(node);
            }
        }
        catch (Exception e) {
            logger.error("cfstack trace create error ", e);
        }
        return list;
    }

    public static List java2cfStringStack(StackTraceElement[] jstack) {
        ArrayList<CallSite> list = new ArrayList<CallSite>();
        StackTraceElement jstackframe = null;
        String funcName = "";
        try {
            for (int i = 0; i < jstack.length; ++i) {
                jstackframe = jstack[i];
                int fdx = 0;
                String funcString = "";
                String lineNo = "";
                int idx = jstackframe.getClassName().indexOf(FUNC);
                if (idx != -1) {
                    fdx = jstackframe.getMethodName().indexOf(RUNFUNCTION);
                    if (fdx == -1) continue;
                    funcName = jstackframe.getClassName().substring(idx + FUNC.length());
                    funcString = jstackframe.getFileName();
                    lineNo = String.valueOf(jstackframe.getLineNumber());
                    list.add((CallSite)((Object)(funcString + COLON + funcName + COLON + lineNo)));
                    continue;
                }
                idx = jstackframe.getMethodName().indexOf(PAGE);
                if (idx == -1) continue;
                jstackframe = jstack[i - 1];
                if (jstackframe.getMethodName().indexOf(FACTOR) != -1) {
                    int j = i - 1;
                    while (jstackframe.getMethodName().indexOf(FACTOR) != -1) {
                        jstackframe = jstack[--j];
                    }
                    jstackframe = jstack[j + 1];
                    funcString = jstackframe.getFileName();
                    lineNo = String.valueOf(jstackframe.getLineNumber());
                    list.add((CallSite)((Object)(funcString + COLON + funcName + COLON + lineNo)));
                }
                jstackframe = jstack[i];
                funcString = jstackframe.getFileName();
                lineNo = String.valueOf(jstackframe.getLineNumber());
                list.add((CallSite)((Object)(funcString + COLON + lineNo)));
            }
        }
        catch (Exception e) {
            logger.error("cfstack trace create error ", e);
        }
        return list;
    }
}

