/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.util;

import java.io.ByteArrayOutputStream;
import java.util.BitSet;

public class StringEncoder {
    private static final StringEncoder _instance = new StringEncoder();
    private final Encoder _encoder = new Encoder('_');
    private final Decoder _decoder = new Decoder('_');

    private StringEncoder() {
    }

    private String encodeVar(String s) {
        return this._encoder.encode(s);
    }

    public static String encode(String s) {
        return _instance.encodeVar(s);
    }

    public static String decode(String s) {
        return _instance.decodeVar(s);
    }

    private String decodeVar(String s) {
        try {
            return this._decoder.decode(s);
        }
        catch (Exception e) {
            e.printStackTrace();
            return s;
        }
    }

    static class Encoder {
        char _escapeChar;
        BitSet dontNeedEncoding;
        static final int caseDiff = 32;

        Encoder(char escapeChar) {
            int i;
            this._escapeChar = escapeChar;
            this.dontNeedEncoding = new BitSet(256);
            for (i = 97; i <= 122; ++i) {
                this.dontNeedEncoding.set(i);
            }
            for (i = 65; i <= 90; ++i) {
                this.dontNeedEncoding.set(i);
            }
            for (i = 48; i <= 57; ++i) {
                this.dontNeedEncoding.set(i);
            }
        }

        public String encode(String s) {
            int maxBytesPerChar = 10;
            StringBuffer out = new StringBuffer(s.length());
            ByteArrayOutputStream buf = new ByteArrayOutputStream(maxBytesPerChar);
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (this.dontNeedEncoding.get(c)) {
                    out.append(c);
                    continue;
                }
                byte[] ba = new byte[]{(byte)(c >>> 8 & 0xFF), (byte)c};
                out.append(this._escapeChar);
                for (int j = 0; j < ba.length; ++j) {
                    char ch = Character.forDigit(ba[j] >> 4 & 0xF, 16);
                    if (Character.isLetter(ch)) {
                        ch = (char)(ch - 32);
                    }
                    out.append(ch);
                    ch = Character.forDigit(ba[j] & 0xF, 16);
                    if (Character.isLetter(ch)) {
                        ch = (char)(ch - 32);
                    }
                    out.append(ch);
                }
                buf.reset();
            }
            return out.toString();
        }
    }

    static class Decoder {
        char _escapeChar;

        Decoder(char escapeChar) {
            this._escapeChar = escapeChar;
        }

        public String decode(String s) throws Exception {
            int startIndex;
            StringBuffer sb = new StringBuffer();
            for (int i = startIndex = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (c == this._escapeChar) {
                    try {
                        sb.append((char)Integer.parseInt(s.substring(i + 1, i + 5), 16));
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException();
                    }
                    i += 4;
                    continue;
                }
                sb.append(c);
            }
            String result = sb.toString();
            return result;
        }
    }
}

