/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.util;

import coldfusion.runtime.RuntimeServiceImpl;
import java.io.UnsupportedEncodingException;

public final class URLDecoder {
    public static final String decode(String s) {
        try {
            return URLDecoder.decode(s, RuntimeServiceImpl.getDefaultCharset());
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalArgumentException(RuntimeServiceImpl.getDefaultCharset());
        }
    }

    public static final String decode(String s, String enc) throws UnsupportedEncodingException {
        if (!URLDecoder.needsDecoding(s)) {
            return s;
        }
        int length = s.length();
        byte[] bytes = new byte[length];
        s.getBytes(0, length, bytes, 0);
        int k = 0;
        length = bytes.length;
        for (int i = 0; i < length; ++i) {
            if (bytes[i] == 37) {
                int b2;
                int b1;
                if (i < length - 2 && (b1 = URLDecoder.byteToInt(bytes[i + 1])) != -1 && (b2 = URLDecoder.byteToInt(bytes[i + 2])) != -1) {
                    bytes[k++] = (byte)((b1 << 4) + b2);
                    i += 2;
                    continue;
                }
                bytes[k++] = bytes[i++];
                for (int j = 0; j < 2 && i < length; ++j) {
                    bytes[k++] = bytes[i++];
                }
                if (i >= length) continue;
                --i;
                continue;
            }
            bytes[k++] = bytes[i] == 43 ? 32 : bytes[i];
        }
        return new String(bytes, 0, k, enc);
    }

    private static final boolean needsDecoding(String s) {
        if (s == null) {
            return false;
        }
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (c != '+' && c != '%') continue;
            return true;
        }
        return false;
    }

    private static final int byteToInt(byte b) {
        switch (b) {
            case 48: {
                return 0;
            }
            case 49: {
                return 1;
            }
            case 50: {
                return 2;
            }
            case 51: {
                return 3;
            }
            case 52: {
                return 4;
            }
            case 53: {
                return 5;
            }
            case 54: {
                return 6;
            }
            case 55: {
                return 7;
            }
            case 56: {
                return 8;
            }
            case 57: {
                return 9;
            }
            case 65: 
            case 97: {
                return 10;
            }
            case 66: 
            case 98: {
                return 11;
            }
            case 67: 
            case 99: {
                return 12;
            }
            case 68: 
            case 100: {
                return 13;
            }
            case 69: 
            case 101: {
                return 14;
            }
            case 70: 
            case 102: {
                return 15;
            }
        }
        return -1;
    }
}

