/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.util;

import coldfusion.runtime.RuntimeServiceImpl;
import coldfusion.util.Hex;
import java.io.CharArrayWriter;
import java.io.UnsupportedEncodingException;
import java.util.BitSet;

public final class URLEncoder {
    private static BitSet dontNeedEncoding;
    private static BitSet dontNeedEncoding_mark;
    static final boolean ESCAPE_PLUS;

    private static boolean isPercentNeedsEncoding(char c, String str, int index) {
        if (index + 2 < str.length()) {
            char c1 = str.charAt(index + 1);
            char c2 = str.charAt(index + 2);
            return !Hex.isHexDigit(c1) || !Hex.isHexDigit(c2);
        }
        return true;
    }

    private URLEncoder() {
    }

    public static final String encode(String s) {
        return URLEncoder.encode(s, false);
    }

    public static final String encode(String s, boolean encodeMarkCharacters) {
        String charset = RuntimeServiceImpl.getDefaultCharset();
        try {
            return URLEncoder.encode(s, charset, encodeMarkCharacters);
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalArgumentException(charset);
        }
    }

    public static final String encode(String s, String enc) throws UnsupportedEncodingException {
        return URLEncoder.encode(s, enc, false);
    }

    public static final String encode(String s, String enc, boolean encodeMarkCharacters) throws UnsupportedEncodingException {
        boolean needToChange = false;
        StringBuilder out = new StringBuilder(s.length());
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        BitSet encodingFree = encodeMarkCharacters ? dontNeedEncoding_mark : dontNeedEncoding;
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (encodingFree.get(c)) {
                out.append(c);
                ++i;
                continue;
            }
            do {
                char d;
                charArrayWriter.write(c);
                if (c < '\ud800' || c > '\udbff' || i + 1 >= s.length() || (d = s.charAt(i + 1)) < '\udc00' || d > '\udfff') continue;
                charArrayWriter.write(d);
                ++i;
            } while (++i < s.length() && !encodingFree.get(c = s.charAt(i)));
            charArrayWriter.flush();
            String str = new String(charArrayWriter.toCharArray());
            byte[] ba = str.getBytes(enc);
            for (int j = 0; j < ba.length; ++j) {
                out.append('%');
                char ch = Character.forDigit(ba[j] >> 4 & 0xF, 16);
                if (Character.isLetter(ch)) {
                    ch = (char)(ch - 32);
                }
                out.append(ch);
                ch = Character.forDigit(ba[j] & 0xF, 16);
                if (Character.isLetter(ch)) {
                    ch = (char)(ch - 32);
                }
                out.append(ch);
            }
            charArrayWriter.reset();
            needToChange = true;
        }
        return needToChange ? out.toString() : s;
    }

    public static final String encodeUrlQuery(String s, String enc, boolean encodeMarkCharacters) throws UnsupportedEncodingException {
        boolean needToChange = false;
        StringBuilder out = new StringBuilder(s.length());
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        BitSet encodingFree = encodeMarkCharacters ? dontNeedEncoding_mark : dontNeedEncoding;
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (encodingFree.get(c) || c == '%' && !URLEncoder.isPercentNeedsEncoding(c, s, i)) {
                out.append(c);
                ++i;
                continue;
            }
            do {
                char d;
                charArrayWriter.write(c);
                if (c < '\ud800' || c > '\udbff' || i + 1 >= s.length() || (d = s.charAt(i + 1)) < '\udc00' || d > '\udfff') continue;
                charArrayWriter.write(d);
                ++i;
            } while (++i < s.length() && !encodingFree.get(c = s.charAt(i)));
            charArrayWriter.flush();
            String str = new String(charArrayWriter.toCharArray());
            byte[] ba = str.getBytes(enc);
            for (int j = 0; j < ba.length; ++j) {
                out.append('%');
                char ch = Character.forDigit(ba[j] >> 4 & 0xF, 16);
                if (Character.isLetter(ch)) {
                    ch = (char)(ch - 32);
                }
                out.append(ch);
                ch = Character.forDigit(ba[j] & 0xF, 16);
                if (Character.isLetter(ch)) {
                    ch = (char)(ch - 32);
                }
                out.append(ch);
            }
            charArrayWriter.reset();
            needToChange = true;
        }
        return needToChange ? out.toString() : s;
    }

    public static final String encodeURLQueryString(String url, String charset) throws UnsupportedEncodingException {
        int queryIndex;
        if (charset == null) {
            charset = RuntimeServiceImpl.getDefaultCharset();
        }
        if ((queryIndex = url.indexOf("?")) != -1 && queryIndex < url.length() - 1) {
            String queryString = url.substring(queryIndex + 1);
            String[] queryParams = queryString.split("&");
            StringBuilder urlBuilder = new StringBuilder();
            urlBuilder.append(url.substring(0, queryIndex + 1));
            if (queryParams != null && queryParams.length > 0) {
                for (int i = 0; i < queryParams.length; ++i) {
                    if (i > 0) {
                        urlBuilder.append("&");
                    }
                    String paramName = queryParams[i];
                    String paramValue = null;
                    int paramValueIndex = queryParams[i].indexOf("=");
                    boolean isEqualsPresent = false;
                    if (paramValueIndex != -1 && paramValueIndex > 0) {
                        isEqualsPresent = true;
                        paramName = queryParams[i].substring(0, paramValueIndex);
                        if (paramValueIndex != queryParams[i].length() - 1) {
                            paramValue = URLEncoder.safeEncode(queryParams[i].substring(paramValueIndex + 1), charset, true);
                        }
                    }
                    urlBuilder.append(URLEncoder.safeEncode(paramName, charset, true));
                    if (!isEqualsPresent) continue;
                    urlBuilder.append("=");
                    if (paramValue == null) continue;
                    urlBuilder.append(paramValue);
                }
            }
            url = urlBuilder.toString();
        }
        return url;
    }

    private static String safeEncode(String input, String charset, boolean encodeMarkCharacters) throws UnsupportedEncodingException {
        if (!ESCAPE_PLUS) {
            input = input.replace('+', ' ');
        }
        return URLEncoder.encodeUrlQuery(input, charset, encodeMarkCharacters);
    }

    static {
        int i;
        ESCAPE_PLUS = Boolean.getBoolean("coldfusion.escape_plus_in_querystring");
        dontNeedEncoding = new BitSet(256);
        dontNeedEncoding_mark = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            dontNeedEncoding.set(i);
            dontNeedEncoding_mark.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            dontNeedEncoding.set(i);
            dontNeedEncoding_mark.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            dontNeedEncoding.set(i);
            dontNeedEncoding_mark.set(i);
        }
        dontNeedEncoding_mark.set(45);
        dontNeedEncoding_mark.set(95);
        dontNeedEncoding_mark.set(46);
        dontNeedEncoding_mark.set(33);
        dontNeedEncoding_mark.set(126);
        dontNeedEncoding_mark.set(42);
        dontNeedEncoding_mark.set(39);
        dontNeedEncoding_mark.set(40);
        dontNeedEncoding_mark.set(41);
        if (ESCAPE_PLUS) {
            dontNeedEncoding.set(43);
            dontNeedEncoding_mark.set(43);
        }
    }
}

