/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.util;

import java.io.IOException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;

public class URLTester {
    public static int MAXTIMEOUT = 60000;
    public static int RETRIES = 25;
    int _maxTimeout = MAXTIMEOUT;
    int _retries = RETRIES;
    String _url = null;

    public URLTester(int maxTimeout, int retries, String url) {
        this._maxTimeout = maxTimeout;
        this._retries = retries;
        this._url = url;
    }

    public URLTester(String url) {
        this._url = url;
    }

    public int getMaxTimeout() {
        return this._maxTimeout;
    }

    public void setMaxTimeout(int _maxTimeout) {
        this._maxTimeout = _maxTimeout;
    }

    public int getRetries() {
        return this._retries;
    }

    public void setRetries(int _retries) {
        this._retries = _retries;
    }

    public String getUrl() {
        return this._url;
    }

    public void setUrl(String _url) {
        this._url = _url;
    }

    public boolean test() throws MalformedURLException {
        URL url = new URL(this.getUrl());
        long start = System.currentTimeMillis();
        for (int i = 0; i < this.getRetries(); ++i) {
            try {
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                int rc = conn.getResponseCode();
                if (rc == 200 || rc == 404) {
                    return true;
                }
                Thread.sleep(2000L);
                long end = System.currentTimeMillis();
                if (end - start <= (long)this.getMaxTimeout()) continue;
                return false;
            }
            catch (ConnectException connectException) {
                continue;
            }
            catch (IOException iOException) {
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }
}

