/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.util;

import coldfusion.server.CFService;
import coldfusion.server.SystemInfo;
import java.io.File;
import java.security.SecureRandom;

public class UUIDUtils {
    private static SecureRandom _rand = new SecureRandom();
    private static long lastUsedTOD = 0L;
    private static long startNanoTime = System.nanoTime();
    private static long startMilliSecondTime = System.currentTimeMillis();
    private static final String alphaNum = "1234567890ABCDEF";
    private static String hostid = null;

    private static native long getHostID();

    private UUIDUtils() {
    }

    public static String createUUID(boolean useBackwardCompatibleFormat) {
        StringBuffer s = new StringBuffer();
        String strTOD = Long.toHexString(UUIDUtils.uniqueTOD()).toUpperCase();
        if (strTOD.length() > 8) {
            s.append(strTOD.substring(strTOD.length() - 8));
        } else {
            s.append(strTOD);
        }
        if (hostid != null) {
            s.append(hostid);
        } else {
            s.append(alphaNum.charAt(_rand.nextInt(16) | 8));
        }
        while (s.length() < 32) {
            s.append(alphaNum.charAt(_rand.nextInt(16)));
        }
        s.insert(8, "-");
        s.insert(13, "-");
        s.insert(18, "-");
        if (!useBackwardCompatibleFormat) {
            s.insert(23, "-");
        }
        return s.toString();
    }

    private static synchronized long uniqueTOD() {
        long tempNanoTime = System.nanoTime();
        long tempTime = (tempNanoTime - startNanoTime) / 100000L;
        long currentTOD = startMilliSecondTime * 10L + tempTime;
        while (currentTOD <= lastUsedTOD) {
            tempNanoTime = System.nanoTime();
            tempTime = (tempNanoTime - startNanoTime) / 100000L;
            currentTOD = startMilliSecondTime * 10L + tempTime;
        }
        lastUsedTOD = currentTOD;
        return lastUsedTOD;
    }

    static {
        try {
            long lHostid;
            if (SystemInfo.isWindows()) {
                System.load(CFService.getLibPath() + File.separator + "NeoUUID.dll");
            }
            if ((lHostid = UUIDUtils.getHostID()) > 0L) {
                String rawHostid = Long.toHexString(lHostid).toUpperCase();
                hostid = rawHostid.length() > 12 ? rawHostid.substring(rawHostid.length() - 12) : rawHostid;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

