/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.util;

import coldfusion.bootstrap.AppServerUtils;
import coldfusion.cfc.DummyHttpServletRequest;
import coldfusion.filter.FusionContext;
import coldfusion.log.CFLogs;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.CFBoolean;
import coldfusion.runtime.CLIRequest;
import coldfusion.runtime.Cast;
import coldfusion.runtime.ExpressionException;
import coldfusion.runtime.NeoPageContext;
import coldfusion.runtime.StringFunc;
import coldfusion.server.ServiceFactory;
import coldfusion.serverless.ServerlessUtil;
import coldfusion.util.CaseInsensitiveMap;
import coldfusion.util.RuntimeWrapper;
import coldfusion.util.SoftCache;
import coldfusion.util.WebEntityResolver;
import coldfusion.vfs.VFSFileFactory;
import com.google.common.primitives.Ints;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.jsp.PageContext;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.TreeSet;
import java.util.zip.Adler32;
import java.util.zip.CheckedInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;

public final class Utils {
    private static int maxMemorySize = 0;
    private static final boolean lastDecimalCheck = Boolean.valueOf(System.getProperty("coldfusion.number.allowdotsuffix", "false"));
    public static final String SERVLET_PATH = "jakarta.servlet.include.servlet_path";
    public static final String QUERY_STRING = "jakarta.servlet.include.query_string";
    public static final String CONTEXT_PATH = "jakarta.servlet.include.context_path";
    public static final String PATH_INFO = "jakarta.servlet.include.path_info";
    public static final String REQUEST_URI = "jakarta.servlet.include.request_uri";
    private static final String LINEFEED = "\n";
    private static final String LINEFEEDURLENC = "%0A";
    private static final String CARRIAGE_RETURN = "\r";
    private static final String CARRIAGE_RETURNURLENC = "%0D";
    private static String tempDir;
    private static Random rand;
    private static final char UNIX_SEPARATOR = '/';
    private static final char WINDOWS_SEPARATOR = '\\';
    private static final char SYSTEM_SEPARATOR;
    public static final String SCRIPT_NONCE = " nonce=";
    private static final char OTHER_SEPARATOR;
    private static final SoftCache canonicalCache;

    private Utils() {
    }

    public static String getServletPath(ServletRequest request) {
        return Utils.getServletPath((HttpServletRequest)request);
    }

    public static String getServletPath(HttpServletRequest request) {
        String sp = (String)request.getAttribute(SERVLET_PATH);
        if (sp == null) {
            sp = request.getServletPath();
        }
        if (sp == null || sp.length() == 0) {
            sp = (String)request.getAttribute("lambda.jakarta.servlet.include.servlet_path");
        }
        return sp;
    }

    public static String getQueryString(HttpServletRequest request) {
        String sp = (String)request.getAttribute(QUERY_STRING);
        if (sp == null) {
            sp = request.getQueryString();
        }
        return sp;
    }

    public static String getContextPath(HttpServletRequest request) {
        String sp = (String)request.getAttribute(CONTEXT_PATH);
        if (sp == null) {
            sp = request.getContextPath();
        }
        return sp;
    }

    public static String getPathInfo(HttpServletRequest request) {
        String sp = (String)request.getAttribute(PATH_INFO);
        if (sp == null) {
            sp = request.getPathInfo();
        }
        return sp;
    }

    public static String getRequestURI(HttpServletRequest request) {
        String sp = (String)request.getAttribute(REQUEST_URI);
        if (sp == null) {
            sp = request.getRequestURI();
        }
        return sp;
    }

    public static String getCanonicalPath(File f) {
        return Utils.getCanonicalFile(f).getPath();
    }

    public static String getCanonicalPath(String path) {
        if (path == null) {
            return null;
        }
        return Utils.getCanonicalFile(path).getPath();
    }

    public static String _getCanonicalPath(final String path) {
        SecurityManager manager = System.getSecurityManager();
        if (manager == null) {
            return Utils.getCanonicalPath(path);
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return Utils.getCanonicalPath(path);
            }
        });
    }

    public static String getTemplatePathBaseDir() {
        Object baseDir = null;
        String pagePath = FusionContext.getCurrent().getPagePath();
        if (null == pagePath) {
            return null;
        }
        int lastslash = pagePath.lastIndexOf(File.separator);
        if (lastslash > 0) {
            baseDir = pagePath.substring(0, lastslash);
            baseDir = (String)baseDir + File.separator;
        }
        return baseDir;
    }

    public static String getFileFullPath(String path, PageContext pageContext) {
        return Utils.getFileFullPath(path, pageContext, false);
    }

    public static String getFileFullPath(String path, PageContext pageContext, boolean useTemplateBasePath) {
        String templatePathDir;
        Object filepath = path.length() > 1 && (path.charAt(0) == '/' || path.charAt(1) == ':' || path.startsWith("\\") || VFSFileFactory.checkIfVFile(path)) ? path : (useTemplateBasePath ? (null != (templatePathDir = Utils.getTemplatePathBaseDir()) ? Utils.getTemplatePathBaseDir() + path : Utils.getTempDir(pageContext) + path) : Utils.getTempDir(pageContext) + path);
        return filepath;
    }

    public static String getTempDir(PageContext pageContext) {
        return Utils.getTempDir(pageContext == null ? (ServletContext)null : pageContext.getServletContext());
    }

    public static String getTempDir(ServletContext servletContext) {
        ServiceFactory.getSecurityService().checkPermission(coldfusion.security.SecurityManager.TEMP_DIR);
        if (tempDir == null) {
            Object stringTempDir;
            File myTempDir = null;
            if (servletContext != null) {
                myTempDir = (File)servletContext.getAttribute("jakarta.servlet.context.tempdir");
            }
            Object object = stringTempDir = myTempDir != null ? myTempDir.getAbsolutePath() : System.getProperty("java.io.tmpdir");
            if (!((String)stringTempDir).endsWith("\\") && !((String)stringTempDir).endsWith("/")) {
                stringTempDir = (String)stringTempDir + File.separator;
            }
            if (myTempDir != null) {
                tempDir = stringTempDir;
            }
        }
        return tempDir;
    }

    public static String getTempFile(PageContext pageContext, String prefix) {
        int i;
        File tempFile;
        if (pageContext != null) {
            return Utils.getTempFile(pageContext, Utils.getTempDir(pageContext), prefix);
        }
        while ((tempFile = new File(tempDir, prefix + Integer.toHexString(i = rand.nextInt()).toUpperCase() + ".tmp")).exists()) {
        }
        return tempFile.getAbsolutePath();
    }

    public static String getTempFile(PageContext pageContext, String dir, String prefix) {
        ServiceFactory.getSecurityService().checkPermission(coldfusion.security.SecurityManager.TEMP_FILE);
        File tmpDir = new File(dir);
        if (!tmpDir.exists()) {
            throw new InvalidTempDirectoryException(dir, (String)prefix);
        }
        try {
            if (prefix == null) {
                prefix = "cftmp";
            } else if (((String)prefix).length() < 3) {
                prefix = (String)prefix + "tmp";
            }
            return File.createTempFile((String)prefix, null, tmpDir).getCanonicalPath();
        }
        catch (IOException ex) {
            throw new RuntimeWrapper(ex);
        }
    }

    private static Random getRandGen(PageContext pageContext) {
        if (pageContext instanceof NeoPageContext) {
            return ((NeoPageContext)pageContext).getRandomNumberGenerator();
        }
        return rand;
    }

    public static File getCanonicalFile(File f) {
        return (File)canonicalCache.get(f);
    }

    public static File getCanonicalFile(String p) {
        return (File)canonicalCache.get(p);
    }

    public static String getDirectoryFromPath(String path) {
        int separatorPos = path.lastIndexOf("/");
        int indexOfBackSlash = path.lastIndexOf("\\");
        if (indexOfBackSlash > separatorPos) {
            separatorPos = indexOfBackSlash;
        }
        return separatorPos != -1 ? path.substring(0, separatorPos + 1) : File.separator;
    }

    public static String getFileFromPath(String path) {
        path = path.replace('\\', '/');
        if ((path = path.replace('/', File.separatorChar)).endsWith("..")) {
            return ".";
        }
        if (path.endsWith(".") || path.endsWith("/") || path.endsWith("\\")) {
            return "";
        }
        return new File(path).getName();
    }

    public static String getExtension(String fileName) throws IllegalArgumentException {
        if (fileName == null) {
            return null;
        }
        int index = Utils.indexOfExtension(fileName);
        if (index == -1) {
            return "";
        }
        return fileName.substring(index + 1);
    }

    public static int indexOfExtension(String fileName) throws IllegalArgumentException {
        int offset;
        if (fileName == null) {
            return -1;
        }
        if (File.separatorChar == '\\' && (offset = fileName.indexOf(58, Utils.getAdsCriticalOffset(fileName))) != -1) {
            throw new IllegalArgumentException("NTFS ADS separator (':') in file name is forbidden.");
        }
        int extensionPos = fileName.lastIndexOf(46);
        int lastSeparator = Utils.indexOfLastSeparator(fileName);
        return lastSeparator > extensionPos ? -1 : extensionPos;
    }

    private static int getAdsCriticalOffset(String fileName) {
        int offset1 = fileName.lastIndexOf(SYSTEM_SEPARATOR);
        int offset2 = fileName.lastIndexOf(OTHER_SEPARATOR);
        if (offset1 == -1) {
            if (offset2 == -1) {
                return 0;
            }
            return offset2 + 1;
        }
        if (offset2 == -1) {
            return offset1 + 1;
        }
        return Math.max(offset1, offset2) + 1;
    }

    public static int indexOfLastSeparator(String fileName) {
        if (fileName == null) {
            return -1;
        }
        int lastUnixPos = fileName.lastIndexOf(47);
        int lastWindowsPos = fileName.lastIndexOf(92);
        return Math.max(lastUnixPos, lastWindowsPos);
    }

    public static String getResolvedPath(String path, String rootDir) {
        if (path != null) {
            path = path.replace("#server.coldfusion.rootDir#", rootDir);
            try {
                path = new File(path).getCanonicalPath();
            }
            catch (IOException e) {
                CFLogs.SERVER_LOG.error("Unable to resolve path", e);
            }
        }
        return path;
    }

    public static File getFullName(String path, String filename, boolean unique) {
        if (unique) {
            File fullname;
            String extension;
            String name;
            int idx = filename.indexOf(".");
            if (idx == -1) {
                name = filename;
                extension = "";
            } else {
                name = filename.substring(0, idx);
                extension = filename.substring(idx);
            }
            int num = 1;
            Object newname = filename;
            while ((fullname = VFSFileFactory.getFileObject(path, (String)newname)).exists()) {
                newname = name + num + extension;
                ++num;
            }
            return fullname;
        }
        return VFSFileFactory.getFileObject(path, filename);
    }

    public static String getBaseTemplatePath(PageContext pageContext) {
        String servletPath;
        String cfcPath;
        ServiceFactory.getSecurityService().checkPermission(coldfusion.security.SecurityManager.BASE_TEMPLATE_PATH);
        ServletRequest request = pageContext.getRequest();
        if (pageContext.getServletConfig() != null && pageContext.getServletConfig().getServletName().equalsIgnoreCase("CFCServlet") && (cfcPath = ((NeoPageContext)pageContext).getFusionContext().getCfcPath()) != null) {
            return cfcPath;
        }
        if (request instanceof DummyHttpServletRequest || request instanceof CLIRequest) {
            return Utils.getServletPath((HttpServletRequest)request);
        }
        ServletContext application = pageContext.getServletContext();
        Object realPath = application.getRealPath(servletPath = Utils.getServletPath(request));
        if (null == realPath && AppServerUtils.getAppServerType() == 10) {
            if (File.separatorChar == '\\') {
                servletPath = servletPath.replace('/', '\\');
            }
            realPath = application.getRealPath("/") + servletPath;
        }
        if (((NeoPageContext)pageContext).getFusionContext().isRestServiceCall()) {
            realPath = ((NeoPageContext)pageContext).getFusionContext().getPagePath();
        }
        return realPath;
    }

    public static String expandPath(String path, PageContext pageContext) {
        Object expPath;
        ServiceFactory.getSecurityService().checkPermission(coldfusion.security.SecurityManager.EXP_PATH);
        path = Utils.fixSeparatorChars(path);
        if (path.length() > 0 && path.charAt(0) != File.separatorChar) {
            String basePath = Utils.getBaseTemplatePath(pageContext);
            if (!basePath.endsWith(File.separator)) {
                basePath = basePath.substring(0, basePath.lastIndexOf(File.separatorChar));
            }
            expPath = Utils.getCanonicalPath(basePath + File.separatorChar + path);
        } else {
            expPath = FusionContext.getCurrent().getRealPath(path.replace('\\', '/'), true);
        }
        if (path.endsWith(File.separator)) {
            if (!((String)expPath).endsWith(File.separator)) {
                expPath = (String)expPath + File.separator;
            }
        } else if (((String)expPath).endsWith(File.separator)) {
            expPath = ((String)expPath).substring(0, ((String)expPath).length() - 1);
        }
        return expPath;
    }

    public static String fixSeparatorChars(String path) {
        path = File.separatorChar == '/' ? path.replace('\\', '/') : path.replace('/', '\\');
        return path;
    }

    public static String normalizeSeparator(String path) {
        int index;
        path = ((String)path).replace('\\', '/');
        while ((index = ((String)path).indexOf("//")) >= 0) {
            path = ((String)path).substring(0, index) + ((String)path).substring(index + 1);
        }
        return path;
    }

    public static String getContextRootRealPath(PageContext pageContext) {
        return Utils.expandPath("/", pageContext);
    }

    public static void setupCompiler(ServletContext application) {
        if (application.getAttribute("coldfusion.compiler.outputDir") == null) {
            File tempdir;
            File f = tempdir = (File)application.getAttribute("jakarta.servlet.context.tempdir");
            String outputDir = application.getInitParameter("coldfusion.compiler.outputDir");
            if (outputDir != null) {
                String rp = application.getRealPath(outputDir);
                if (ServerlessUtil.isLambdaEnv()) {
                    rp = outputDir;
                }
                if (!(rp == null || (f = new File(rp)).exists() || f.mkdirs() || tempdir == null || ServerlessUtil.isLambdaEnv())) {
                    f = tempdir;
                }
            }
            application.setAttribute("coldfusion.compiler.outputDir", (Object)f.getAbsolutePath());
        }
    }

    public static synchronized void parseWebXml(ServletContext application) {
        if (ServerlessUtil.isLambdaEnv()) {
            return;
        }
        if (application.getAttribute("coldfusion.dtdmappings") == null) {
            Properties p = new Properties();
            p.setProperty("-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN", application.getRealPath("/WEB-INF/web-app_2_2.dtd"));
            p.setProperty("web-app_2_2.dtd", application.getRealPath("/WEB-INF/web-app_2_2.dtd"));
            p.setProperty("-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN", application.getRealPath("/WEB-INF/web-app_2_3.dtd"));
            p.setProperty("web-app_2_3.dtd", application.getRealPath("/WEB-INF/web-app_2_3.dtd"));
            p.setProperty("-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.1//EN", application.getRealPath("/WEB-INF/web-jsptaglibrary_1_1.dtd"));
            p.setProperty("web-jsptaglibrary_1_1.dtd", application.getRealPath("/WEB-INF/web-jsptaglibrary_1_1.dtd"));
            p.setProperty("-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.2//EN", application.getRealPath("/WEB-INF/web-jsptaglibrary_1_2.dtd"));
            p.setProperty("web-jsptaglibrary_1_2.dtd", application.getRealPath("/WEB-INF/web-jsptaglibrary_1_2.dtd"));
            application.setAttribute("coldfusion.dtdmappings", (Object)p);
        }
        if (application.getAttribute("coldfusion.web.xml") == null) {
            try {
                DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Properties p = (Properties)application.getAttribute("coldfusion.dtdmappings");
                docBuilder.setEntityResolver(new WebEntityResolver(p));
                Document webxml = docBuilder.parse(application.getResourceAsStream(Utils.getWebXmlPath(application)));
                application.setAttribute("coldfusion.web.xml", (Object)webxml);
            }
            catch (Throwable e) {
                CFLogs.SERVER_LOG.error("Unable to read web.xml", e);
            }
        }
    }

    private static String getWebXmlPath(ServletContext context) {
        Object webXmlLoc = "/WEB-INF/web.xml";
        if (ServerlessUtil.isLambdaEnv()) {
            webXmlLoc = "/cfusion/wwwroot" + (String)webXmlLoc;
        }
        return webXmlLoc;
    }

    public static String substitute(String str, String from, String to) {
        if (from == null || from.length() == 0 || to == null) {
            return str;
        }
        int index = str.indexOf(from);
        if (index == -1) {
            return str;
        }
        StringBuffer buf = new StringBuffer(str.length());
        int lastIndex = 0;
        while (index != -1) {
            buf.append(str.substring(lastIndex, index));
            buf.append(to);
            lastIndex = index + from.length();
            index = str.indexOf(from, lastIndex);
        }
        buf.append(str.substring(lastIndex));
        return buf.toString();
    }

    public static String stripCRLF(String input) {
        String returnStr = input;
        if (returnStr != null && returnStr.length() > 0) {
            returnStr = returnStr.replace(LINEFEED, "");
            returnStr = StringFunc.ReplaceNoCase(returnStr, LINEFEEDURLENC, "", "ALL");
            returnStr = returnStr.replace(CARRIAGE_RETURN, "");
            returnStr = StringFunc.ReplaceNoCase(returnStr, CARRIAGE_RETURNURLENC, "", "ALL");
        }
        return returnStr;
    }

    public static String canonicalizeURI(String uri) {
        if (uri == null || uri.length() == 0) {
            return uri;
        }
        uri = uri.replace('\\', '/');
        uri = Utils.trimDuplicateSlashes(uri);
        uri = Utils.collapseDotDots(uri);
        if ((uri = Utils.trimTrailingDotsSpacesNull(uri)).charAt(0) == '.') {
            uri = uri.substring(1);
        }
        if ((uri = Utils.substitute(uri, "/./", "/")).endsWith("/.")) {
            uri = uri.substring(0, uri.length() - 2);
        }
        if (uri.length() == 0) {
            uri = "/";
        }
        return uri;
    }

    public static String trimTrailingDotsSpacesNull(String uri) {
        int checkNull = uri.indexOf("\u0000");
        if (checkNull != -1 && checkNull < uri.length()) {
            uri = uri.substring(0, checkNull);
        }
        if (File.separatorChar == '\\') {
            while (uri.endsWith(" ") || uri.endsWith(".")) {
                uri = uri.substring(0, uri.length() - 1);
            }
        }
        return uri;
    }

    public static String collapseDotDots(String str) {
        int i;
        if (str.indexOf("/../") == -1) {
            return str;
        }
        StringBuffer sb = new StringBuffer(str);
        while ((i = str.indexOf("/..")) != -1) {
            int segmentStart = str.lastIndexOf(47, i - 1);
            sb.delete(segmentStart, i + 3);
            str = sb.toString();
        }
        if (str.length() == 0) {
            str = "/";
        }
        return str;
    }

    public static String trimDuplicateSlashes(String path) {
        int index;
        if (path == null) {
            return null;
        }
        while ((index = ((String)path).indexOf("//")) >= 0) {
            path = ((String)path).substring(0, index) + ((String)path).substring(index + 1);
        }
        while ((index = ((String)path).indexOf("...")) >= 0) {
            path = ((String)path).substring(0, index) + ((String)path).substring(index + 1);
        }
        return path;
    }

    public static List castToList(Object lst) {
        return (List)lst;
    }

    public static long getFileCheckSum(File file) {
        long checksum = 0L;
        try {
            CheckedInputStream cis = new CheckedInputStream(VFSFileFactory.getInputStream(file), new Adler32());
            byte[] tempBuf = new byte[128];
            while (cis.read(tempBuf) >= 0) {
            }
            checksum = cis.getChecksum().getValue();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return checksum;
    }

    public static long getByteArrayCheckSum(byte[] bytes) {
        Adler32 checksumEngine = new Adler32();
        checksumEngine.update(bytes, 0, bytes.length);
        long checksum = checksumEngine.getValue();
        checksumEngine.reset();
        return checksum;
    }

    public static String arrayToString(Object[] objs, String delimiter, boolean sort, boolean toUpperCase) {
        int i;
        if (objs == null) {
            return "";
        }
        delimiter = delimiter == null ? "," : delimiter;
        Object[] strArray = null;
        StringBuffer b = new StringBuffer();
        if (sort) {
            strArray = new String[objs.length];
        }
        for (i = 0; i < objs.length; ++i) {
            String tmpStr = objs[i] == null ? "" : (toUpperCase ? objs[i].toString().toUpperCase() : objs[i].toString());
            if (sort) {
                strArray[i] = tmpStr;
                continue;
            }
            if (i != 0) {
                b.append(delimiter);
            }
            b.append(tmpStr);
        }
        if (!sort) {
            return b.toString();
        }
        Arrays.sort(strArray);
        for (i = 0; i < strArray.length; ++i) {
            if (i != 0) {
                b.append(delimiter);
            }
            b.append((String)strArray[i]);
        }
        return b.toString();
    }

    public static String getMessage(Throwable throwable) {
        return Utils.getMessage(throwable, false);
    }

    public static String getMessage(Throwable throwable, boolean recurse) {
        String prefix;
        String string = prefix = recurse ? "" : "ROOT CAUSE: \n";
        if (throwable == null) {
            throwable = new Throwable("NULL exception");
        }
        String message = throwable.getMessage();
        if (!recurse && message != null && throwable.getMessage().startsWith(prefix)) {
            return message;
        }
        if (throwable instanceof SQLException) {
            return prefix + Utils.nextSqlExceptionToString((SQLException)throwable);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        throwable.printStackTrace(new PrintStream(bos));
        return prefix + bos.toString();
    }

    public static boolean cfobjectEquals(Object obj1, Object obj2) {
        return Utils.cfobjectEquals(obj1, obj2, false);
    }

    public static boolean cfobjectEquals(Object obj1, Object obj2, boolean ignorecase) {
        if (obj1 instanceof String) {
            return Utils.cfobjectEquals((String)obj1, obj2, ignorecase);
        }
        if (obj2 instanceof String) {
            return Utils.cfobjectEquals((String)obj2, obj1, ignorecase);
        }
        boolean equal = obj1.equals(obj2);
        if (!equal) {
            if (obj1 instanceof Number) {
                return Utils.cfobjectEquals((Number)obj1, obj2, ignorecase);
            }
            if (obj2 instanceof Number) {
                return Utils.cfobjectEquals((Number)obj2, obj1, ignorecase);
            }
        }
        return equal;
    }

    private static boolean cfobjectEquals(Number num, Object obj, boolean ignorecase) {
        Double d1;
        if (obj instanceof Number) {
            return num.doubleValue() == ((Number)obj).doubleValue();
        }
        if (obj instanceof CFBoolean) {
            return obj.equals(Cast._boolean(num));
        }
        if (obj instanceof String && Utils.isBooleanOrNumericOrDateCandidate((String)obj) && (d1 = Cast._double((String)obj, true, true, false)) != null) {
            return d1.equals(num.doubleValue());
        }
        if (obj instanceof String || obj instanceof Boolean || obj instanceof Date) {
            String str = String.valueOf(num);
            if (ignorecase) {
                return str.equalsIgnoreCase(obj.toString());
            }
            return str.equals(obj.toString());
        }
        return false;
    }

    private static boolean cfobjectEquals(String str, Object obj, boolean ignorecase) {
        Double d2;
        Double d1;
        boolean castToDouble = true;
        if (obj instanceof String) {
            boolean bl = castToDouble = Utils.isBooleanOrNumericOrDateCandidate(str) && Utils.isBooleanOrNumericOrDateCandidate((String)obj);
        }
        if (castToDouble && (d1 = Cast._double(obj, true, false)) != null && (d2 = Cast._double(str, true, true, false)) != null) {
            return d1.equals(d2);
        }
        if (obj instanceof String || obj instanceof Number || obj instanceof Boolean || obj instanceof Date) {
            if (ignorecase) {
                return str.equalsIgnoreCase(obj.toString());
            }
            return str.equals(obj.toString());
        }
        return false;
    }

    public static boolean isBooleanOrNumericOrDateCandidate(String str) {
        if ((str = str.trim()).length() == 0) {
            return false;
        }
        if (!lastDecimalCheck && str.charAt(str.length() - 1) == '.') {
            return false;
        }
        switch (str.charAt(0)) {
            case '+': 
            case '-': 
            case '.': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': 
            case 'A': 
            case 'D': 
            case 'F': 
            case 'J': 
            case 'M': 
            case 'N': 
            case 'O': 
            case 'S': 
            case 'T': 
            case 'Y': 
            case 'a': 
            case 'd': 
            case 'f': 
            case 'j': 
            case 'm': 
            case 'n': 
            case 'o': 
            case 's': 
            case 't': 
            case 'y': 
            case '{': {
                return true;
            }
        }
        return false;
    }

    private static String nextSqlExceptionToString(SQLException sqlEx) {
        if (sqlEx == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        sqlEx.printStackTrace(new PrintStream(bos));
        buf.append(bos.toString());
        buf.append(Utils.nextSqlExceptionToString(sqlEx.getNextException()));
        return buf.toString();
    }

    public static Map<String, String> parseStructString(String paramsStr) {
        if ((paramsStr = paramsStr.trim()).length() == 0 || paramsStr.charAt(0) != '{' || paramsStr.charAt(paramsStr.length() - 1) != '}') {
            throw new StructParseException();
        }
        paramsStr = paramsStr.substring(1, paramsStr.length() - 1);
        String[] pairs = paramsStr.split(",(?=([^\"']*[\"'][^\"']*[\"'])*[^\"']*$)");
        CaseInsensitiveMap params = new CaseInsensitiveMap();
        for (String pair : pairs) {
            int index = (pair = pair.trim()).indexOf(61);
            if (index == -1) {
                throw new StructParseException();
            }
            String key = pair.substring(0, index).trim();
            key = Utils.removeQuotes(key);
            String val = pair.substring(index + 1).trim();
            val = Utils.removeQuotes(val);
            params.put(key, val);
        }
        return params;
    }

    private static String removeQuotes(String key) {
        if (key.length() == 0) {
            return key;
        }
        if (key.charAt(0) == '\'' && key.charAt(key.length() - 1) == '\'' || key.charAt(0) == '\"' && key.charAt(key.length() - 1) == '\"') {
            key = key.substring(1, key.length() - 1);
        }
        return key;
    }

    public static String toUpperCase(String str) {
        return Utils.toUpperCase(str, false);
    }

    public static String toUpperCase(String str, boolean ascii) {
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') continue;
            return ascii ? Utils._toupperCase(str) : Utils.getUcaseString(str);
        }
        return str;
    }

    private static String getUcaseString(String s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            sb.append(Character.toUpperCase(s.charAt(i)));
        }
        return sb.toString();
    }

    private static String _toupperCase(String str) {
        char[] result = new char[str.length()];
        for (int i = 0; i < result.length; ++i) {
            char c = str.charAt(i);
            result[i] = c >= 'a' && c <= 'z' ? (char)(c - 97 + 65) : c;
        }
        return new String(result);
    }

    public static void checkEncoding(String encoding) {
        try {
            boolean result = Charset.isSupported(encoding);
            if (!result) {
                throw new UnSupportedCharEncodingException(encoding);
            }
        }
        catch (Exception e) {
            throw new UnSupportedCharEncodingException(encoding);
        }
    }

    public static long getMaxHeapSize() {
        if (maxMemorySize == 0) {
            try {
                AccessController.doPrivileged(new PrivilegedAction<Integer>(){

                    @Override
                    public Integer run() {
                        RuntimeMXBean runtimemxBean = ManagementFactory.getRuntimeMXBean();
                        List<String> aList = runtimemxBean.getInputArguments();
                        String val = null;
                        for (int i = 0; i < aList.size(); ++i) {
                            val = aList.get(i).trim();
                            if (!val.startsWith("-Xmx")) continue;
                            maxMemorySize = Utils.getMemoryInMB(val);
                            return maxMemorySize;
                        }
                        return null;
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (maxMemorySize == 0) {
                maxMemorySize = (int)Runtime.getRuntime().maxMemory() / 0x100000;
            }
        }
        return maxMemorySize;
    }

    public static int getMemoryInMB(String jvmFlagValue) {
        String val = jvmFlagValue.substring(4, jvmFlagValue.length() - 1);
        char memoryUnit = Character.toUpperCase(jvmFlagValue.charAt(jvmFlagValue.length() - 1));
        switch (memoryUnit) {
            case 'M': {
                return Integer.parseInt(val);
            }
            case 'G': {
                return Integer.parseInt(val) * 1024;
            }
            case 'K': {
                return Integer.parseInt(val) / 1024;
            }
        }
        jvmFlagValue = jvmFlagValue.substring(4);
        return (int)(Long.parseLong(jvmFlagValue) / 0x100000L);
    }

    public static String joinStrings(String delimiter, String ... inputs) {
        if (inputs == null || inputs.length == 0) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < inputs.length; ++i) {
            if (i > 0) {
                builder.append(delimiter);
            }
            if (inputs[i] == null) continue;
            builder.append(inputs[i]);
        }
        return builder.toString();
    }

    public static String join(String delimiter, Iterable<String> elements) {
        if (delimiter == null || elements == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        Iterator<String> iterator = elements.iterator();
        if (iterator.hasNext()) {
            result.append(iterator.next());
        }
        while (iterator.hasNext()) {
            result.append(delimiter);
            result.append(iterator.next());
        }
        return result.toString();
    }

    public static boolean checkSystemHTTPProxyIsSet() {
        String proxyHost = System.getProperty("http.proxyHost");
        String proxyPort = System.getProperty("http.proxyPort");
        if (StringUtils.isNotBlank((CharSequence)proxyHost)) {
            try {
                Integer.parseInt(proxyPort);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    public static String toBase36(String hexString) {
        BigInteger value = new BigInteger(hexString, 16);
        return value.toString(36);
    }

    public static String removeDuplicates(String input, String delimiter) {
        if (input == null || delimiter == null) {
            return null;
        }
        input = input.trim();
        TreeSet<String> values = new TreeSet<String>();
        String[] valuesArray = input.split(delimiter);
        if (valuesArray != null) {
            for (String value : valuesArray) {
                if ((value = value.trim()).length() <= 0) continue;
                values.add(value);
            }
        }
        StringBuilder result = new StringBuilder();
        int counter = 0;
        for (String value : values) {
            if (counter > 0) {
                result.append(delimiter);
            }
            result.append(value);
            ++counter;
        }
        return result.toString();
    }

    public static boolean hasSurrogateCharacters(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c < '\ud800' || c > '\udfff') continue;
            return true;
        }
        return false;
    }

    public static int contains(String source, String str, int fromIdx, int toIdx) {
        int max;
        int sLength = source.length();
        int vLength = str.length();
        int n = max = toIdx > sLength - 1 ? sLength - 1 : toIdx;
        if (max - fromIdx + 1 < vLength) {
            return -1;
        }
        char first = str.charAt(0);
        for (int i = fromIdx; i <= max; ++i) {
            if (source.charAt(i) != first) {
                while (++i <= max && source.charAt(i) != first) {
                }
            }
            if (i > max || toIdx - i + 1 < vLength) {
                return -1;
            }
            int toReturn = i;
            int j = i + 1;
            int k = 1;
            while (k < vLength && source.charAt(j) == str.charAt(k)) {
                ++k;
                ++j;
            }
            if (k != vLength) continue;
            return toReturn;
        }
        return -1;
    }

    public static String[] upperLowerCaseCombinations(String word) {
        word = word.toLowerCase();
        int combinations = 1 << word.length();
        String[] res = new String[combinations];
        int k = 0;
        for (int i = 0; i < combinations; ++i) {
            char[] result = word.toCharArray();
            for (int j = 0; j < word.length(); ++j) {
                if ((i >> j & 1) != 1) continue;
                result[j] = Character.toUpperCase(word.charAt(j));
            }
            res[k++] = new String(result);
        }
        return res;
    }

    public static Integer parseInteger(Object val) {
        return Ints.tryParse((String)val.toString());
    }

    public static String generateCspNonce() {
        String SALTCHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890";
        char[] salt = new char[10];
        Random rnd = new Random();
        for (int index = 0; index < 10; ++index) {
            int val = (int)(rnd.nextFloat() * (float)SALTCHARS.length());
            salt[index] = SALTCHARS.charAt(val);
        }
        return new String(salt);
    }

    public static String getCSPNonceString() {
        String nonce = FusionContext.getCurrent().getCSPNonce();
        return nonce != null && nonce.trim().length() > 0 ? " nonce=\"" + nonce + "\"" : "";
    }

    public static boolean isNullOrEmptyString(String string) {
        return string == null || string.length() == 0;
    }

    static {
        rand = new Random(System.currentTimeMillis());
        SYSTEM_SEPARATOR = File.separatorChar;
        OTHER_SEPARATOR = File.separatorChar == '\\' ? (char)47 : (char)92;
        canonicalCache = new SoftCache(SoftCache.Stats.FALSE){

            @Override
            protected Object fetch(Object file) {
                if (file instanceof String) {
                    file = VFSFileFactory.getFileObject((String)file);
                }
                try {
                    return ((File)file).getCanonicalFile();
                }
                catch (IOException ex) {
                    return ((File)file).getAbsoluteFile();
                }
            }

            public String toString() {
                return "Canonical cache";
            }
        };
    }

    public static class InvalidTempDirectoryException
    extends ExpressionException {
        public String prefix;
        public String tempDir;

        InvalidTempDirectoryException(String tempDir, String prefix) {
            this.tempDir = tempDir;
            this.prefix = prefix;
        }
    }

    public static class StructParseException
    extends RuntimeException {
    }

    public static class UnSupportedCharEncodingException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        String encoding;

        public UnSupportedCharEncodingException(Throwable ex, String encoding) {
            super(ex);
            this.encoding = encoding;
        }

        public UnSupportedCharEncodingException(String encoding) {
            this.encoding = encoding;
        }

        public String getEncoding() {
            return this.encoding;
        }
    }
}

