/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.util;

import coldfusion.log.CFLogs;
import coldfusion.log.Logger;
import coldfusion.vfs.VFSFileFactory;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipUtils {
    static final int BUFFER = 2048;
    private static final String LOG_PRIORITY = "Information";
    private static final String LOG_APPNAME = "CFZip";
    private static final String separator = System.getProperty("file.separator");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(String filename, String outputdir) throws IOException {
        outputdir = (String)outputdir + separator;
        Logger log = CFLogs.SERVER_LOG;
        BufferedOutputStream dest = null;
        BufferedInputStream is = null;
        try (ZipFile zipfile = null;){
            File newfile;
            String path;
            ZipEntry entry;
            zipfile = new ZipFile(filename);
            Enumeration<? extends ZipEntry> e = zipfile.entries();
            while (e.hasMoreElements()) {
                entry = e.nextElement();
                path = (String)outputdir + entry;
                newfile = VFSFileFactory.getFileObject(path);
                if (!entry.isDirectory() || newfile.exists()) continue;
                newfile.mkdir();
            }
            e = zipfile.entries();
            while (e.hasMoreElements()) {
                entry = e.nextElement();
                path = (String)outputdir + entry;
                newfile = VFSFileFactory.getFileObject(path);
                if (entry.isDirectory()) continue;
                ZipUtils.createDirs(newfile);
                if (newfile.exists()) {
                    newfile.delete();
                }
                is = new BufferedInputStream(zipfile.getInputStream(entry));
                byte[] data = new byte[2048];
                try {
                    int count;
                    dest = new BufferedOutputStream(VFSFileFactory.getOutputStream(newfile), 2048);
                    while ((count = is.read(data, 0, 2048)) != -1) {
                        dest.write(data, 0, count);
                    }
                    dest.flush();
                    dest.close();
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static void createDirs(File f) {
        File pf = f.getParentFile();
        if (pf != null && !pf.exists()) {
            Vector<File> parents = new Vector<File>();
            while (pf != null && !pf.exists()) {
                parents.insertElementAt(pf, 0);
                pf = pf.getParentFile();
            }
            Enumeration e = parents.elements();
            while (e.hasMoreElements()) {
                pf = (File)e.nextElement();
                pf.mkdir();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set getEntryNameList(File zip) throws IOException {
        HashSet<String> set = new HashSet<String>();
        try (ZipFile zipFile = null;){
            zipFile = new ZipFile(zip);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry entry = enumeration.nextElement();
                set.add(entry.getName());
            }
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set getClassNamesFromZip(File zip) throws IOException {
        HashSet<String> set = new HashSet<String>();
        try (ZipFile zipFile = null;){
            zipFile = new ZipFile(zip);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry entry = enumeration.nextElement();
                String className = ZipUtils.getClassName(entry.getName());
                if (className == null) continue;
                set.add(className);
            }
        }
        return set;
    }

    private static String getClassName(String pathName) {
        int index = pathName.lastIndexOf(".class");
        if (index == -1) {
            return null;
        }
        return pathName.substring(0, index).replace('/', '.');
    }
}

