/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.vfs;

import org.apache.commons.vfs2.FileSystemConfigBuilder;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.ram.RamFileSystem;

public class ApplicationRamFileSystemConfigBuilder
extends FileSystemConfigBuilder {
    private static final String MAX_SIZE_KEY = "maxsize";
    private static final String APPLICATION_KEY = "application";
    private static ApplicationRamFileSystemConfigBuilder singleton = new ApplicationRamFileSystemConfigBuilder();

    private ApplicationRamFileSystemConfigBuilder() {
    }

    public static ApplicationRamFileSystemConfigBuilder getInstance() {
        return singleton;
    }

    protected Class getConfigClass() {
        return RamFileSystem.class;
    }

    public int getMaxSize(FileSystemOptions opts) {
        Long size = (Long)this.getParam(opts, MAX_SIZE_KEY);
        if (size != null) {
            return size.intValue();
        }
        return Integer.MAX_VALUE;
    }

    public void setMaxSize(FileSystemOptions opts, int sizeInBytes) {
        this.setParam(opts, MAX_SIZE_KEY, sizeInBytes);
    }

    public void setApplication(FileSystemOptions opts, String appName) {
        this.setParam(opts, APPLICATION_KEY, appName);
    }

    public String getApplication(FileSystemOptions opts) {
        return (String)this.getParam(opts, APPLICATION_KEY);
    }
}

