/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.vfs;

import coldfusion.filter.FusionContext;
import coldfusion.runtime.AppHelper;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.ApplicationScope;
import coldfusion.runtime.ApplicationScopeTracker;
import coldfusion.runtime.ApplicationSettings;
import coldfusion.runtime.CFBoolean;
import coldfusion.server.RuntimeService;
import coldfusion.server.ServiceFactory;
import coldfusion.server.StoreService;
import coldfusion.vfs.ApplicationRamFileSystemConfigBuilder;
import coldfusion.vfs.VFile;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.UriParser;

public class VFSFileSystemOptionFactory {
    private static FileSystemOptions defaultFSO = new FileSystemOptions();
    private static Map ramFileSystemOptions = new HashMap();
    private static Map s3FileSystemOptions = new HashMap();
    public static final int INMEMORYFILESYSTEMLIMIT_DEFAULT = 100;
    public static final int INMEMORYFILESYSTEMAPPLIMIT_DEFAULT = 20;
    public static Integer totalAppRamSize = 0;
    public static FileSystemOptions fs = new FileSystemOptions();

    public static FileSystemOptions getFileSystemOptions(String uri) {
        String scheme = UriParser.extractScheme((String)uri);
        return VFSFileSystemOptionFactory.getFileSystemOptions(scheme, uri);
    }

    public static FileSystemOptions getFileSystemOptions(String scheme, String uri) {
        if (scheme.equalsIgnoreCase("ram")) {
            return VFSFileSystemOptionFactory.getRAMFileSystemOptions();
        }
        if (scheme.equalsIgnoreCase("s3")) {
            return VFSFileSystemOptionFactory.getS3FileSystemOptions(uri);
        }
        return defaultFSO;
    }

    private static synchronized FileSystemOptions getS3FileSystemOptions(String uri) {
        String appName = FusionContext.getCurrent().getApplicationName();
        FileSystemOptions fso = (FileSystemOptions)s3FileSystemOptions.get(appName);
        if (fso == null) {
            Map s3Settings;
            fso = new FileSystemOptions();
            Map appSettings = (Map)AppHelper.getApplicationSetting();
            if (appSettings != null && (s3Settings = (Map)appSettings.get("s3")) != null) {
                StoreService storeService;
                String accessKeyId = (String)s3Settings.get("accessKeyId");
                String secretAccessKey = (String)s3Settings.get("awsSecretKey");
                String defaultLocation = (String)s3Settings.get("defaultlocation");
                Object multipartFileSize = s3Settings.get("minsizeformultipart");
                CFBoolean enableDefaultCredentialProviderChain = (CFBoolean)s3Settings.get("enableCredentialProvider");
                if (enableDefaultCredentialProviderChain == null) {
                    enableDefaultCredentialProviderChain = CFBoolean.f_false;
                }
                if (multipartFileSize != null) {
                    try {
                        storeService = ServiceFactory.getStoreService(false);
                        if (storeService != null) {
                            storeService.setUploaderMaxSize(multipartFileSize);
                        }
                    }
                    catch (NumberFormatException storeService2) {
                        // empty catch block
                    }
                }
                if ((storeService = ServiceFactory.getStoreService(false)) != null) {
                    storeService.setFileSystemOptions(fso, accessKeyId, secretAccessKey, defaultLocation, enableDefaultCredentialProviderChain.value);
                }
            }
            s3FileSystemOptions.put(appName, fso);
        }
        return fso;
    }

    public static synchronized FileSystemOptions getRAMFileSystemOptions() {
        FusionContext fc = FusionContext.getCurrent();
        if (fc == null) {
            return fs;
        }
        String appName = fc.getApplicationName();
        FileSystemOptions fso = (FileSystemOptions)ramFileSystemOptions.get(appName);
        if (fso == null) {
            fso = new FileSystemOptions();
            RuntimeService runtime = null;
            try {
                runtime = ServiceFactory.getRuntimeService();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (runtime != null && runtime.isInMemoryFileSystemEnabled()) {
                int maxSize = runtime.getInMemoryFileSystemAppLimit();
                int globalLimit = runtime.getInMemoryFileSystemLimit();
                boolean appEnabled = true;
                ApplicationScope appScope = ApplicationScopeTracker.getApplicationScope(appName);
                if (appScope != null) {
                    ApplicationSettings appSettings = appScope.getApplicationSettings();
                    maxSize = appSettings.getInMemorySize();
                    appEnabled = appSettings.isInMemoryEnabled();
                }
                if (appEnabled) {
                    ApplicationRamFileSystemConfigBuilder.getInstance().setMaxSize(fso, maxSize * 1024 * 1024);
                    ApplicationRamFileSystemConfigBuilder.getInstance().setApplication(fso, appName);
                }
                if (totalAppRamSize + maxSize > globalLimit) {
                    throw new InMemoryLimitExceededException(globalLimit);
                }
                totalAppRamSize = totalAppRamSize + maxSize;
            }
            ramFileSystemOptions.put(appName, fso);
        }
        return fso;
    }

    public static void updatAppspecificMemory() {
        RuntimeService runtime = null;
        try {
            runtime = ServiceFactory.getRuntimeService();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Set keySet = ramFileSystemOptions.keySet();
        for (Object appName : keySet) {
            ApplicationSettings appSettings;
            if (runtime == null || !runtime.isInMemoryFileSystemEnabled()) continue;
            int maxSize = runtime.getInMemoryFileSystemAppLimit();
            ApplicationScope appScope = ApplicationScopeTracker.getApplicationScope(appName.toString());
            FileSystemOptions fso = (FileSystemOptions)ramFileSystemOptions.get(appName);
            if (appScope != null && (appSettings = appScope.getApplicationSettings()).isInMemoryFileSystemEnabled()) {
                maxSize = appSettings.getInMemorySize();
            }
            ApplicationRamFileSystemConfigBuilder.getInstance().setMaxSize(fso, maxSize * 1024 * 1024);
            ApplicationRamFileSystemConfigBuilder.getInstance().setApplication(fso, appName.toString());
        }
    }

    public static synchronized boolean fileSystemExists(String appName) {
        boolean exists = false;
        FileSystemOptions fso = (FileSystemOptions)ramFileSystemOptions.get(appName);
        if (fso != null) {
            exists = true;
        }
        return exists;
    }

    public static synchronized int getTotalAppRamSize() {
        return totalAppRamSize;
    }

    public static synchronized void cleanRAMFileSystem(String appName, boolean keepIFExplicit) {
        FileSystemOptions fso = (FileSystemOptions)ramFileSystemOptions.get(appName);
        if (fso != null) {
            ApplicationScope appScope = ApplicationScopeTracker.getApplicationScope(appName);
            boolean appEnabled = ServiceFactory.getRuntimeService().isInMemoryFileSystemEnabled();
            int maxSize = ServiceFactory.getRuntimeService().getInMemoryFileSystemLimit();
            boolean explicit = false;
            if (appScope != null) {
                ApplicationSettings appSettings = appScope.getApplicationSettings();
                maxSize = appSettings.getInMemorySize();
                appEnabled = appSettings.isInMemoryEnabled();
                explicit = appSettings.isExplicitInMemoryFileSystem();
            }
            if (keepIFExplicit && !explicit) {
                VFSFileSystemOptionFactory.clearRam(appName, fso, maxSize, true);
            } else if (!keepIFExplicit) {
                VFSFileSystemOptionFactory.clearRam(appName, fso, maxSize, appEnabled);
            }
        }
    }

    public static void clearRam(String appName, FileSystemOptions fso, int maxSize, boolean appEnabled) {
        if (appEnabled) {
            totalAppRamSize = totalAppRamSize - maxSize;
        }
        ramFileSystemOptions.remove(appName);
        try {
            FileObject fo = VFile.fsManager.resolveFile("ram://", fso);
            VFile.fsManager.closeFileSystem(fo.getFileSystem());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        ApplicationRamFileSystemConfigBuilder.getInstance().setMaxSize(fs, 1);
    }

    public static class InMemoryLimitExceededException
    extends ApplicationException {
        private int globalLimit;

        public InMemoryLimitExceededException(int globalLimit) {
            this.globalLimit = globalLimit;
        }

        public int getglobalLimit() {
            return this.globalLimit;
        }
    }

    public static class ApplicationInMemoryLimitException
    extends ApplicationException {
        private int appLimit;

        public ApplicationInMemoryLimitException(int appLimit) {
            this.appLimit = appLimit;
        }

        public int getAppLimit() {
            return this.appLimit;
        }
    }
}

