/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.vfs;

import coldfusion.server.CFService;
import coldfusion.server.ServiceFactory;
import coldfusion.server.StoreService;
import coldfusion.tagext.io.FileTag;
import coldfusion.util.URLEncoder;
import coldfusion.vfs.VFSFileFactory;
import coldfusion.vfs.VFSFileSystemOptionFactory;
import coldfusion.vfs.VFileOutputStream;
import coldfusion.vfs.VFilePermission;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.util.ArrayList;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.FilesCache;
import org.apache.commons.vfs2.cache.DefaultFilesCache;
import org.apache.commons.vfs2.impl.StandardFileSystemManager;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.provider.ram.RamFileSystem;

public class VFile
extends File
implements Serializable,
Comparable<File> {
    protected static StandardFileSystemManager fsManager = new StandardFileSystemManager();
    private FileObject fo;
    private String completePath;

    public static boolean isSchemeSupported(String scheme) {
        if (scheme.equalsIgnoreCase("s3")) {
            StoreService storeService = ServiceFactory.getStoreService(true);
            return storeService.isSchemeSupported(scheme);
        }
        return VFile.getFileSystemManager(scheme).hasProvider(scheme);
    }

    public VFile(String pathname) throws FileSystemException {
        super(".");
        if (pathname == null) {
            throw new NullPointerException();
        }
        String scheme = UriParser.extractScheme((String)pathname);
        FileSystemOptions fso = VFSFileSystemOptionFactory.getFileSystemOptions(scheme, (String)pathname);
        if (((String)pathname).indexOf("%") != -1 && ((String)pathname).indexOf("%25") == -1) {
            String[] split = ((String)pathname).split("%");
            pathname = split[0];
            for (int i = 1; i < split.length; ++i) {
                pathname = (String)pathname + URLEncoder.encode("%" + split[i]);
            }
        }
        this.fo = VFile.getFileSystemManager(scheme).resolveFile((String)pathname, fso);
        this.updateCompletePath();
    }

    private VFile(FileObject fileObject) {
        super(".");
        if (fileObject == null) {
            throw new NullPointerException();
        }
        this.fo = fileObject;
        this.updateCompletePath();
    }

    private static StandardFileSystemManager getFileSystemManager(String scheme) {
        if (scheme.equalsIgnoreCase("s3")) {
            StoreService storeService = ServiceFactory.getStoreService(true);
            return storeService.getFileSystemManager(scheme);
        }
        return fsManager;
    }

    private static String stripSlashAtTheEndForS3(String scheme, String path) {
        if (scheme.equalsIgnoreCase("s3") && path.charAt(path.length() - 1) == '/') {
            return path.substring(0, path.length() - 1);
        }
        return path;
    }

    @Override
    public boolean canRead() {
        VFile.checkFilePermission("read", this.completePath, this.fo.getFileSystem());
        try {
            return this.fo.isReadable();
        }
        catch (FileSystemException e) {
            throw new FileTag.SingleFileOperationException("read", e, this.fo.getName().getPath());
        }
    }

    @Override
    public boolean canWrite() {
        VFile.checkFilePermission("write", this.completePath, this.fo.getFileSystem());
        try {
            return this.fo.isWriteable();
        }
        catch (FileSystemException e) {
            throw new FileTag.SingleFileOperationException("write", e, this.fo.getName().getPath());
        }
    }

    @Override
    public int compareTo(File pathname) {
        if (pathname == null) {
            throw new NullPointerException();
        }
        return this.getPath().compareTo(pathname.getPath());
    }

    @Override
    public boolean createNewFile() throws IOException {
        VFile.checkFilePermission("write", this.completePath, this.fo.getFileSystem());
        if (!this.exists()) {
            this.fo.createFile();
            return true;
        }
        return false;
    }

    @Override
    public boolean delete() {
        VFile.checkFilePermission("delete", this.completePath, this.fo.getFileSystem());
        try {
            if (this.fo.getContent().isOpen()) {
                this.fo.getContent().close();
            }
            this.fo.delete();
            return true;
        }
        catch (FileSystemException e) {
            return false;
        }
    }

    @Override
    public void deleteOnExit() {
        VFile.checkFilePermission("delete", this.completePath, this.fo.getFileSystem());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null && obj instanceof VFile) {
            return this.compareTo((VFile)obj) == 0;
        }
        return false;
    }

    @Override
    public boolean exists() {
        VFile.checkFilePermission("read", this.completePath, this.fo.getFileSystem());
        try {
            return this.fo.exists();
        }
        catch (FileSystemException e) {
            throw new FileTag.SingleFileOperationException("exists", e, this.fo.getName().getPath());
        }
    }

    @Override
    public File getAbsoluteFile() {
        return this;
    }

    @Override
    public String getAbsolutePath() {
        return this.getCompletePath();
    }

    @Override
    public File getCanonicalFile() throws IOException {
        return this.getAbsoluteFile();
    }

    @Override
    public String getCanonicalPath() throws IOException {
        return this.getCompletePath();
    }

    @Override
    public String getName() {
        return this.fo.getName().getBaseName();
    }

    public String getFriendlyName() {
        return this.fo.getName().getFriendlyURI();
    }

    @Override
    public String getParent() {
        FileObject pfob;
        try {
            pfob = this.fo.getParent();
        }
        catch (FileSystemException e) {
            throw new FileTag.SingleFileOperationException("getparent", e, this.fo.getName().getPath());
        }
        if (pfob == null) {
            return null;
        }
        return new VFile(pfob).getCompletePath();
    }

    @Override
    public File getParentFile() {
        FileObject pfob;
        try {
            pfob = this.fo.getParent();
        }
        catch (FileSystemException e) {
            throw new FileTag.SingleFileOperationException("getparent", e, this.fo.getName().getPath());
        }
        if (pfob == null) {
            return null;
        }
        return new VFile(pfob);
    }

    @Override
    public String getPath() {
        return this.getCompletePath();
    }

    @Override
    public int hashCode() {
        String path = this.fo.getName().getPath().toLowerCase();
        return path.hashCode() ^ 0x12D591;
    }

    @Override
    public boolean isAbsolute() {
        return true;
    }

    @Override
    public boolean isDirectory() {
        VFile.checkFilePermission("read", this.completePath, this.fo.getFileSystem());
        try {
            if (!this.exists()) {
                return false;
            }
            return this.fo.getType().equals((Object)FileType.FOLDER);
        }
        catch (FileSystemException e) {
            throw new FileTag.SingleFileOperationException("isDirectory", e, this.fo.getName().getPath());
        }
    }

    @Override
    public boolean isFile() {
        VFile.checkFilePermission("read", this.completePath, this.fo.getFileSystem());
        try {
            if (!this.exists()) {
                return false;
            }
            return this.fo.getType().equals((Object)FileType.FILE);
        }
        catch (FileSystemException e) {
            throw new FileTag.SingleFileOperationException("isFile", e, this.fo.getName().getPath());
        }
    }

    @Override
    public boolean isHidden() {
        VFile.checkFilePermission("read", this.completePath, this.fo.getFileSystem());
        try {
            return this.fo.isHidden();
        }
        catch (FileSystemException e) {
            throw new FileTag.SingleFileOperationException("isHidden", e, this.fo.getName().getPath());
        }
    }

    @Override
    public long lastModified() {
        VFile.checkFilePermission("read", this.completePath, this.fo.getFileSystem());
        try {
            return this.fo.getContent().getLastModifiedTime();
        }
        catch (FileSystemException e) {
            throw new FileTag.SingleFileOperationException("lastModified", e, this.fo.getName().getPath());
        }
    }

    @Override
    public long length() {
        VFile.checkFilePermission("read", this.completePath, this.fo.getFileSystem());
        try {
            if (this.isFile()) {
                return this.fo.getContent().getSize();
            }
            return 0L;
        }
        catch (FileSystemException e) {
            throw new FileTag.SingleFileOperationException("length", e, this.fo.getName().getPath());
        }
    }

    @Override
    public String[] list() {
        FileObject[] foChildren;
        VFile.checkFilePermission("read", this.completePath, this.fo.getFileSystem());
        StoreService storeService = ServiceFactory.getStoreService(false);
        if (storeService != null && storeService.isInstanceOfS3FileObject(this.fo)) {
            try {
                return storeService.doListChildren(this.fo);
            }
            catch (Exception e) {
                throw new FileTag.SingleFileOperationException("list", e, this.fo.getName().getPath());
            }
        }
        if (this.isFile()) {
            return null;
        }
        try {
            foChildren = this.fo.getChildren();
        }
        catch (FileSystemException e) {
            throw new FileTag.SingleFileOperationException("list", e, this.fo.getName().getPath());
        }
        if (foChildren == null) {
            return null;
        }
        String[] strChildren = new String[foChildren.length];
        for (int i = 0; i < foChildren.length; ++i) {
            strChildren[i] = foChildren[i].getName().getBaseName();
        }
        return strChildren;
    }

    @Override
    public String[] list(FilenameFilter filter) {
        FileObject[] fobs;
        VFile.checkFilePermission("read", this.completePath, this.fo.getFileSystem());
        FileSelector selector = this.getSelector(filter);
        try {
            fobs = this.fo.findFiles(selector);
        }
        catch (FileSystemException e) {
            throw new FileTag.SingleFileOperationException("list", e, this.fo.getName().getPath());
        }
        ArrayList<String> filesList = new ArrayList<String>();
        for (int i = 0; i < fobs.length; ++i) {
            VFile vFile = new VFile(fobs[i]);
            if (this.compareTo(vFile) == 0) continue;
            filesList.add(fobs[i].getName().getBaseName());
        }
        return filesList.toArray(new String[0]);
    }

    @Override
    public File[] listFiles() {
        FileObject[] foChildren;
        VFile.checkFilePermission("read", this.completePath, this.fo.getFileSystem());
        StoreService storeService = ServiceFactory.getStoreService(false);
        if ((storeService == null || !storeService.isInstanceOfS3FileObject(this.fo)) && this.isFile()) {
            return null;
        }
        try {
            foChildren = this.fo.getChildren();
        }
        catch (FileSystemException e) {
            throw new FileTag.SingleFileOperationException("listFiles", e, this.fo.getName().getPath());
        }
        if (foChildren == null) {
            return null;
        }
        File[] fileChildren = new File[foChildren.length];
        for (int i = 0; i < foChildren.length; ++i) {
            fileChildren[i] = new VFile(foChildren[i]);
        }
        return fileChildren;
    }

    @Override
    public File[] listFiles(final FileFilter filter) {
        FileObject[] fobs;
        VFile.checkFilePermission("read", this.completePath, this.fo.getFileSystem());
        FileSelector selector = new FileSelector(){

            public boolean includeFile(FileSelectInfo fileselectinfo) throws Exception {
                return filter.accept(new VFile(fileselectinfo.getFile()));
            }

            public boolean traverseDescendents(FileSelectInfo fileselectinfo) throws Exception {
                return fileselectinfo.getFile().equals(VFile.this.fo);
            }
        };
        try {
            fobs = this.fo.findFiles(selector);
        }
        catch (FileSystemException e) {
            throw new FileTag.SingleFileOperationException("listFiles", e, this.fo.getName().getPath());
        }
        ArrayList<VFile> filesList = new ArrayList<VFile>();
        for (int i = 0; i < fobs.length; ++i) {
            VFile file = new VFile(fobs[i]);
            if (file.compareTo(this) == 0) continue;
            filesList.add(file);
        }
        return filesList.toArray(new File[0]);
    }

    @Override
    public File[] listFiles(FilenameFilter filter) {
        FileObject[] fobs;
        VFile.checkFilePermission("read", this.completePath, this.fo.getFileSystem());
        FileSelector selector = this.getSelector(filter);
        try {
            fobs = this.fo.findFiles(selector);
        }
        catch (FileSystemException e) {
            throw new FileTag.SingleFileOperationException("listFiles", e, this.fo.getName().getPath());
        }
        ArrayList<VFile> filesList = new ArrayList<VFile>();
        for (int i = 0; i < fobs.length; ++i) {
            VFile file = new VFile(fobs[i]);
            if (file.compareTo(this) == 0) continue;
            filesList.add(file);
        }
        return filesList.toArray(new File[0]);
    }

    @Override
    public boolean mkdir() {
        VFile.checkFilePermission("write", this.completePath, this.fo.getFileSystem());
        try {
            this.fo.createFolder();
            return true;
        }
        catch (FileSystemException e) {
            return false;
        }
    }

    @Override
    public boolean mkdirs() {
        return this.mkdir();
    }

    @Override
    public boolean renameTo(File dest) {
        block12: {
            if (dest == null) {
                throw new NullPointerException();
            }
            VFile.checkFilePermission("write", this.completePath, this.fo.getFileSystem());
            VFile.checkFilePermission("write", dest.getAbsolutePath(), this.fo.getFileSystem());
            try {
                if (dest instanceof VFile) {
                    String absolutePath = dest.getAbsolutePath();
                    String scheme = UriParser.extractScheme((String)absolutePath);
                    FileSystemOptions fso = VFSFileSystemOptionFactory.getFileSystemOptions(scheme, absolutePath);
                    FileObject destfo = VFile.getFileSystemManager(scheme).resolveFile(absolutePath, fso);
                    if (!this.fo.canRenameTo(destfo)) {
                        return false;
                    }
                    if (this.isFile()) {
                        if (destfo.exists() && dest.isFile()) {
                            destfo.delete();
                        }
                        if (destfo.getParent() != null && !destfo.getParent().exists()) {
                            destfo.getParent().createFolder();
                        }
                        this.fo.moveTo(destfo);
                    } else {
                        File[] listoffiles = this.listFiles();
                        if (!dest.exists()) {
                            dest.mkdir();
                        }
                        if (listoffiles != null) {
                            for (int i = 0; i < listoffiles.length; ++i) {
                                File tmpfile = listoffiles[i];
                                tmpfile.renameTo(VFSFileFactory.getFileObject(dest, tmpfile.getName()));
                            }
                        }
                        this.delete();
                    }
                    break block12;
                }
                return false;
            }
            catch (FileSystemException e) {
                return false;
            }
        }
        this.updateCompletePath();
        return true;
    }

    @Override
    public boolean setLastModified(long time) {
        VFile.checkFilePermission("write", this.completePath, this.fo.getFileSystem());
        try {
            this.fo.getContent().setLastModifiedTime(time);
        }
        catch (FileSystemException e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean setReadOnly() {
        VFile.checkFilePermission("write", this.completePath, this.fo.getFileSystem());
        return true;
    }

    @Override
    public String toString() {
        return this.getPath();
    }

    @Override
    public URI toURI() {
        try {
            return new URI(this.fo.getName().getURI());
        }
        catch (URISyntaxException e) {
            throw new FileTag.SingleFileOperationException("toURI", e, this.fo.getName().getPath());
        }
    }

    @Override
    public URL toURL() throws MalformedURLException {
        try {
            return this.fo.getURL();
        }
        catch (FileSystemException e) {
            throw new FileTag.SingleFileOperationException("toURL", e, this.fo.getName().getPath());
        }
    }

    public InputStream getInputStream() throws FileSystemException {
        VFile.checkFilePermission("read", this.completePath, this.fo.getFileSystem());
        return this.fo.getContent().getInputStream();
    }

    public OutputStream getOutputStream() throws FileSystemException {
        VFile.checkFilePermission("write", this.completePath, this.fo.getFileSystem());
        return new VFileOutputStream(this.fo.getContent().getOutputStream());
    }

    public OutputStream getOutputStream(boolean append) throws FileSystemException {
        VFile.checkFilePermission("write", this.completePath, this.fo.getFileSystem());
        return new VFileOutputStream(this.fo.getContent().getOutputStream(append));
    }

    public FileObject getFileObject() {
        return this.fo;
    }

    private FileSelector getSelector(final FilenameFilter filter) {
        return new FileSelector(){

            public boolean includeFile(FileSelectInfo fileselectinfo) throws Exception {
                return filter.accept(new VFile(fileselectinfo.getFile().getParent()), fileselectinfo.getFile().getName().getBaseName());
            }

            public boolean traverseDescendents(FileSelectInfo fileselectinfo) throws Exception {
                return fileselectinfo.getFile().equals(VFile.this.fo);
            }
        };
    }

    private String getCompletePath() {
        return this.completePath;
    }

    private void updateCompletePath() {
        this.completePath = this.fo.getName().getRootURI().concat(this.fo.getName().getPath().substring(1));
    }

    private static void checkFilePermission(String actions, String file, FileSystem fs) {
        if (file != null && ServiceFactory.getSecurityService().isSandboxSecurityEnabled() && ServiceFactory.getSecurityService().isJvmSecurityEnabled() && VFile.needsPermissionCheck(fs)) {
            AccessController.checkPermission(new VFilePermission(file, actions));
        }
    }

    private static boolean needsPermissionCheck(FileSystem fs) {
        return fs instanceof RamFileSystem;
    }

    static {
        try {
            File providersFile = CFService.getFile("vfs-providers.xml");
            if (providersFile.exists()) {
                fsManager.setConfiguration(providersFile.toURI().toString());
            }
            fsManager.setFilesCache((FilesCache)new DefaultFilesCache());
            fsManager.init();
        }
        catch (FileSystemException e) {
            throw new FileTag.SingleFileOperationException("create", e, "");
        }
    }
}

