/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.vfs;

import coldfusion.vfs.VFile;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;

public class VFilePermission
extends Permission
implements Serializable {
    private static final int EXECUTE = 1;
    private static final int WRITE = 2;
    private static final int READ = 4;
    private static final int DELETE = 8;
    private static final int ALL = 15;
    private static final int NONE = 0;
    private transient int mask;
    private transient boolean directory;
    private transient boolean recursive;
    private String actions;
    private transient String cpath;
    private static final char RECURSIVE_CHAR = '-';
    private static final char WILD_CHAR = '*';

    private void init(int mask) {
        int last;
        if ((mask & 0xF) != mask) {
            throw new IllegalArgumentException("invalid actions mask");
        }
        if (mask == 0) {
            throw new IllegalArgumentException("invalid actions mask");
        }
        this.cpath = this.getName();
        if (this.cpath == null) {
            throw new NullPointerException("name can't be null");
        }
        this.cpath = this.cpath.replace('\\', '/');
        this.cpath = this.cpath.trim();
        this.mask = mask;
        if (this.cpath.equals("<<ALL FILES>>")) {
            this.directory = true;
            this.recursive = true;
            this.cpath = "";
            return;
        }
        int len = this.cpath.length();
        int n = last = len > 0 ? (int)this.cpath.charAt(len - 1) : 0;
        if (last == 45 && (len == 1 || this.cpath.charAt(len - 2) == "/".charAt(0))) {
            this.directory = true;
            this.recursive = true;
            this.cpath = this.cpath.substring(0, --len);
        } else if (last == 42 && (len == 1 || this.cpath.charAt(len - 2) == "/".charAt(0))) {
            this.directory = true;
            this.cpath = this.cpath.substring(0, --len);
        }
        this.cpath = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    int ln;
                    VFile file = new VFile(VFilePermission.this.cpath);
                    String canonical_path = ((File)file).getCanonicalPath();
                    if (VFilePermission.this.directory && ((ln = canonical_path.length()) == 0 || canonical_path.charAt(ln - 1) != "/".charAt(0))) {
                        return canonical_path + "/";
                    }
                    return canonical_path;
                }
                catch (IOException iOException) {
                    return VFilePermission.this.cpath;
                }
            }
        });
    }

    public VFilePermission(String path, String actions) {
        super(path);
        this.init(VFilePermission.getMask(actions));
    }

    @Override
    public boolean implies(Permission p) {
        if (!(p instanceof VFilePermission)) {
            return false;
        }
        VFilePermission that = (VFilePermission)p;
        return (this.mask & that.mask) == that.mask && this.impliesIgnoreMask(that);
    }

    boolean impliesIgnoreMask(VFilePermission that) {
        if (this.directory) {
            if (this.recursive) {
                if (that.directory) {
                    return that.cpath.length() >= this.cpath.length() && that.cpath.startsWith(this.cpath);
                }
                return that.cpath.length() > this.cpath.length() && that.cpath.startsWith(this.cpath);
            }
            if (that.directory) {
                if (that.recursive) {
                    return false;
                }
                return this.cpath.equals(that.cpath);
            }
            int last = that.cpath.lastIndexOf("/");
            return this.cpath.length() == last + 1 && this.cpath.regionMatches(0, that.cpath, 0, last + 1);
        }
        return this.cpath.equals(that.cpath);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof VFilePermission)) {
            return false;
        }
        VFilePermission that = (VFilePermission)obj;
        return this.mask == that.mask && this.cpath.equals(that.cpath) && this.directory == that.directory && this.recursive == that.recursive;
    }

    @Override
    public int hashCode() {
        return this.cpath.hashCode();
    }

    private static int getMask(String actions) {
        int mask = 0;
        if (actions == null) {
            return mask;
        }
        if (actions == "read") {
            return 4;
        }
        if (actions == "write") {
            return 2;
        }
        if (actions == "execute") {
            return 1;
        }
        if (actions == "delete") {
            return 8;
        }
        String[] tokens = actions.split(",");
        if (tokens != null) {
            int len = tokens.length;
            for (int i = 0; i < len; ++i) {
                if (tokens[i].trim().equalsIgnoreCase("read")) {
                    mask |= 4;
                    continue;
                }
                if (tokens[i].trim().equalsIgnoreCase("write")) {
                    mask |= 2;
                    continue;
                }
                if (tokens[i].trim().equalsIgnoreCase("execute")) {
                    mask |= 1;
                    continue;
                }
                if (tokens[i].trim().equalsIgnoreCase("delete")) {
                    mask |= 8;
                    continue;
                }
                throw new IllegalArgumentException("invalid permission: " + actions);
            }
        }
        return mask;
    }

    private static String getActions(int mask) {
        StringBuilder sb = new StringBuilder();
        boolean comma = false;
        if ((mask & 4) == 4) {
            comma = true;
            sb.append("read");
        }
        if ((mask & 2) == 2) {
            if (comma) {
                sb.append(',');
            } else {
                comma = true;
            }
            sb.append("write");
        }
        if ((mask & 1) == 1) {
            if (comma) {
                sb.append(',');
            } else {
                comma = true;
            }
            sb.append("execute");
        }
        if ((mask & 8) == 8) {
            if (comma) {
                sb.append(',');
            } else {
                comma = true;
            }
            sb.append("delete");
        }
        return sb.toString();
    }

    @Override
    public String getActions() {
        if (this.actions == null) {
            this.actions = VFilePermission.getActions(this.mask);
        }
        return this.actions;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        if (this.actions == null) {
            this.getActions();
        }
        s.defaultWriteObject();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.init(VFilePermission.getMask(this.actions));
    }
}

