/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.watch;

import coldfusion.log.CFLogs;
import coldfusion.server.ConfigMap;
import coldfusion.server.LicenseService;
import coldfusion.server.LoggingService;
import coldfusion.server.SecurityService;
import coldfusion.server.ServiceBase;
import coldfusion.server.ServiceException;
import coldfusion.server.ServiceFactory;
import coldfusion.server.WatchService;
import coldfusion.watch.Watcher;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class WatchServiceImpl
extends ServiceBase
implements WatchService,
Watcher.Listener {
    private Watcher watcher = null;
    private String configDir = "";
    private File configFile = null;
    private ConfigMap settings;
    private long interval = 120L;
    private boolean watchEnabled = false;
    private String watchExtensions = null;
    private List listeners;

    public WatchServiceImpl(File wconfig, String directory) {
        this.configDir = directory;
        this.configFile = wconfig;
        this.listeners = new ArrayList();
    }

    @Override
    public void start() throws ServiceException {
        super.start();
        this.settings.setConfigMapListener(this);
        if (this.isWatchEnabled()) {
            this.startWatcher();
        }
    }

    @Override
    public void stop() throws ServiceException {
        super.stop();
        if (this.watcher != null) {
            this.watcher.stop();
        }
    }

    @Override
    public void load() throws ServiceException {
        try {
            this.settings = (ConfigMap)this.deserialize(this.configFile);
            if (this.watcher != null) {
                this.watcher.setInterval(this.getInterval());
                this.watcher.setExtensions(this.getWatchExtensions());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ServiceException(ex);
        }
    }

    @Override
    public void store() throws ServiceException {
        this.serialize(this.settings, this.configFile);
    }

    @Override
    public void store(Object key, Object value, Object oldValue, boolean broadCast) throws ServiceException {
        this.serialize(this.settings, this.configFile, broadCast, key, value, oldValue);
    }

    @Override
    public void addListener(Watcher.Listener listener) {
        if (this.watcher != null) {
            this.watcher.addListener(listener);
        } else {
            this.listeners.add(listener);
        }
    }

    @Override
    public void removeListener(Watcher.Listener listener) {
        if (this.watcher != null) {
            this.watcher.removeListener(listener);
        } else {
            this.listeners.remove(listener);
        }
    }

    public void addWatchedDirectory(String watchedDirectory) {
        if (this.watcher != null) {
            this.watcher.addWatchedDirectory(watchedDirectory);
        }
    }

    @Override
    public void setSettings(Map settings) throws ServiceException {
        this.serialize(settings, this.configFile);
        this.load();
    }

    @Override
    public Map getSettings() {
        return this.settings;
    }

    public long getInterval() {
        Object interval = this.settings.get("watch.interval");
        if (interval != null && interval instanceof Number) {
            this.interval = ((Number)interval).longValue();
        }
        return this.interval;
    }

    public void setInterval(long pollInterval) {
        this.interval = pollInterval;
        this.settings.put("watch.interval", (Object)new Long(pollInterval));
        if (this.watcher != null) {
            this.watcher.setInterval(this.interval);
        }
    }

    public String getWatchExtensions() {
        if (this.settings.get("watch.extensions") != null) {
            this.watchExtensions = this.settings.get("watch.extensions").toString();
        }
        return this.watchExtensions;
    }

    public void setWatchExtensions(String watchExtensions) {
        this.watchExtensions = watchExtensions;
        this.settings.put("watch.watchExtensions", (Object)watchExtensions);
        if (this.watcher != null) {
            this.watcher.setExtensions(this.watchExtensions);
        }
    }

    @Override
    public boolean isWatchEnabled() {
        Object enabled = this.settings.get("watch.watchEnabled");
        if (enabled != null) {
            this.watchEnabled = Boolean.valueOf(enabled.toString());
        }
        return this.watchEnabled;
    }

    @Override
    public void setWatchEnable(boolean watchEnabled) {
        this.watchEnabled = watchEnabled;
        this.settings.put("watch.watchEnabled", (Object)watchEnabled);
        if (watchEnabled) {
            try {
                this.startWatcher();
            }
            catch (ServiceException e) {
                CFLogs.SERVER_LOG.error(e);
            }
        } else if (this.watcher != null) {
            try {
                this.watcher.stop();
            }
            catch (ServiceException e) {
                CFLogs.SERVER_LOG.error(e);
            }
        }
    }

    private void startWatcher() throws ServiceException {
        if (this.watcher == null) {
            this.watcher = new Watcher(this.configDir, this.getInterval(), this, this.getWatchExtensions());
            if (this.listeners.size() > 0) {
                for (int i = 0; i < this.listeners.size(); ++i) {
                    Watcher.Listener listener = (Watcher.Listener)this.listeners.get(i);
                    this.watcher.addListener(listener);
                }
                this.listeners.clear();
            }
        }
        this.watcher.start();
    }

    @Override
    public boolean isInterested(File modifiedFile) {
        return modifiedFile.getName().equalsIgnoreCase(this.configFile.getName());
    }

    @Override
    public void registerServices() {
        LoggingService loggingService = ServiceFactory.getLoggingService();
        loggingService.setEnableWatch(true);
        loggingService.registerWithWatchService();
        SecurityService securityService = ServiceFactory.getSecurityService();
        securityService.setEnableWatch(true);
        securityService.registerWithWatchService();
        LicenseService licenseService = ServiceFactory.getLicenseService();
        licenseService.setEnableWatch(true);
        licenseService.registerWithWatchService();
    }
}

