/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.wddx;

import coldfusion.runtime.Struct;
import coldfusion.runtime.StructOrdered;
import coldfusion.runtime.StructSorted;
import coldfusion.wddx.WddxObjectSerializer;
import coldfusion.wddx.WddxOutputStream;
import java.io.IOException;
import java.util.Map;

class MapSerializer
implements WddxObjectSerializer {
    MapSerializer() {
    }

    @Override
    public void writeObject(WddxOutputStream out, Object obj) throws IOException {
        if (obj != null) {
            Map m = (Map)obj;
            String type = null;
            String sortType = null;
            String sortOrder = null;
            Boolean localeSensitive = false;
            try {
                type = (String)m.get("_wddx_structAttributes_type");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (type == null) {
                type = m.getClass().getName();
            }
            if (m instanceof Struct) {
                if (m instanceof StructOrdered) {
                    if (m instanceof StructSorted) {
                        StructSorted s = (StructSorted)m;
                        if (s.getSortType() == null) {
                            type = "ordered";
                        } else {
                            type = "ordered";
                            sortType = s.getSortType();
                            sortOrder = s.getSortOrder();
                            localeSensitive = s.getLocaleSensitive();
                        }
                    } else {
                        type = "ordered";
                    }
                } else {
                    type = "unordered";
                }
            }
            if (type == null || type.equals("unordered")) {
                out.writeStructBegin();
            } else if (type.equalsIgnoreCase("ordered") && sortType != null) {
                out.writeStructBegin(type, sortType, sortOrder, localeSensitive);
            } else {
                out.writeStructBegin(type);
            }
            for (Object key : m.keySet()) {
                Object value = m.get(key);
                if (value == type) continue;
                out.writeVarBegin(key.toString());
                out.writeObject(value);
                out.writeVarEnd();
            }
            out.writeStructEnd();
        } else {
            out.writeNull();
        }
    }
}

