/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.wddx;

import coldfusion.wddx.WddxObjectSerializer;
import coldfusion.wddx.WddxOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

class ObjectSerializer
implements WddxObjectSerializer {
    ObjectSerializer() {
    }

    @Override
    public void writeObject(WddxOutputStream out, Object o) throws IOException {
        if (o instanceof Externalizable) {
            Externalizable ext = (Externalizable)o;
            ext.writeExternal(out);
            return;
        }
        out.writeStructBegin(ObjectSerializer.getTypeSignature(o.getClass()));
        Class<?> cls = o.getClass();
        Field[] fields = cls.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field f = fields[i];
            if (Modifier.isTransient(f.getModifiers())) continue;
            try {
                f.setAccessible(true);
            }
            catch (Error error) {
                // empty catch block
            }
            Class<?> fcls = f.getType();
            try {
                out.writeVarBegin(f.getName());
                if (fcls.isPrimitive()) {
                    if (fcls == Integer.TYPE) {
                        out.writeInt(f.getInt(o));
                    } else if (fcls == Byte.TYPE) {
                        out.writeByte(f.getByte(o));
                    } else if (fcls == Long.TYPE) {
                        out.writeLong(f.getLong(o));
                    } else if (fcls == Float.TYPE) {
                        out.writeFloat(f.getFloat(o));
                    } else if (fcls == Double.TYPE) {
                        out.writeDouble(f.getDouble(o));
                    } else if (fcls == Short.TYPE) {
                        out.writeShort(f.getShort(o));
                    } else if (fcls == Character.TYPE) {
                        out.writeChar(f.getChar(o));
                    } else if (fcls == Boolean.TYPE) {
                        out.writeBoolean(f.getBoolean(o));
                    }
                } else {
                    out.writeObject(f.get(o));
                }
                out.writeVarEnd();
                continue;
            }
            catch (IllegalAccessException e) {
                throw new IOException(e.getMessage());
            }
        }
        out.writeStructEnd();
    }

    static String getTypeSignature(Class cls) {
        StringBuffer sig = new StringBuffer();
        if (cls.isArray()) {
            return cls.getName();
        }
        if (cls.isPrimitive()) {
            if (cls == Integer.TYPE) {
                sig.append('I');
            } else if (cls == Byte.TYPE) {
                sig.append('B');
            } else if (cls == Long.TYPE) {
                sig.append('J');
            } else if (cls == Float.TYPE) {
                sig.append('F');
            } else if (cls == Double.TYPE) {
                sig.append('D');
            } else if (cls == Short.TYPE) {
                sig.append('S');
            } else if (cls == Character.TYPE) {
                sig.append('C');
            } else if (cls == Boolean.TYPE) {
                sig.append('Z');
            }
        } else {
            sig.append('L');
            sig.append(cls.getName());
            sig.append(';');
        }
        return sig.toString();
    }
}

