/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.wddx;

import coldfusion.wddx.WddxDeserializationException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

class WddxDefaults {
    private static Properties m_properties;

    private WddxDefaults() {
    }

    public static Properties getProperties() {
        return m_properties;
    }

    public static String getProperty(String name) {
        return m_properties.getProperty(name);
    }

    static {
        int minorVersion;
        int majorVersion;
        m_properties = new Properties();
        try {
            String version = System.getProperty("java.version");
            int index = version.indexOf(46);
            majorVersion = new Integer(version.substring(0, index));
            int index2 = version.indexOf(46, index + 1);
            if (index2 == -1) {
                index2 = version.length();
            }
            minorVersion = new Integer(version.substring(index + 1, index2));
        }
        catch (Exception e) {
            majorVersion = 1;
            minorVersion = 2;
        }
        String propsLoc = "/coldfusion/wddx/wddx_java" + majorVersion + "_" + minorVersion + ".properties";
        try {
            InputStream in = WddxDefaults.class.getResourceAsStream(propsLoc);
            while (in == null && majorVersion >= 1) {
                if (minorVersion == 0) {
                    --majorVersion;
                    minorVersion = 9;
                }
                propsLoc = "/coldfusion/wddx/wddx_java" + majorVersion + "_" + --minorVersion + ".properties";
                in = WddxDefaults.class.getResourceAsStream(propsLoc);
            }
            if (in == null) {
                throw new MissingDefaultPropertyException();
            }
            m_properties.load(in);
        }
        catch (IOException e) {
            throw new DefaultPropertyInitException(propsLoc);
        }
    }

    public static class MissingDefaultPropertyException
    extends WddxDeserializationException {
    }

    public static class DefaultPropertyInitException
    extends WddxDeserializationException {
        public String propLoc;

        public DefaultPropertyInitException(String propLoc) {
            this.propLoc = propLoc;
        }
    }
}

