/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.wddx;

import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.java.JavaProxy;
import coldfusion.wddx.Base64Encoder;
import coldfusion.wddx.ISO8601;
import coldfusion.wddx.RecordSet;
import coldfusion.wddx.RecordSetException;
import coldfusion.wddx.SpecialCharInfo;
import coldfusion.wddx.UTF8Converter;
import coldfusion.wddx.WddxObjectSerializer;
import coldfusion.wddx.WddxSerializer;
import coldfusion.xml.XmlNodeList;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;

public class WddxOutputStream
extends OutputStream
implements ObjectOutput {
    protected WddxSerializer m_serializer;
    protected PrintWriter m_out;
    protected SpecialCharInfo[] m_UTF8CharTable;
    protected SpecialCharInfo[] m_UTF8AttrCharTable;
    private boolean usingTimezone = true;

    WddxOutputStream(WddxSerializer serializer, PrintWriter out) {
        this.m_serializer = serializer;
        this.m_out = out;
        this.init();
    }

    protected void init() {
        this.m_UTF8CharTable = UTF8Converter.getCharInfo();
        this.m_UTF8AttrCharTable = UTF8Converter.getAttrCharInfo();
    }

    @Override
    public void flush() {
        this.m_out.flush();
    }

    @Override
    public void close() {
        this.m_out.close();
    }

    void writeUnformattedChars(String s) throws IOException {
        this.m_out.write(s);
    }

    void writeStructBegin() throws IOException {
        this.writeUnformattedChars("<struct>");
    }

    void writeStructBegin(String type) throws IOException {
        this.writeUnformattedChars("<struct type='");
        this.writeUnformattedChars(type);
        this.writeUnformattedChars("'>");
    }

    void writeStructEnd() throws IOException {
        this.writeUnformattedChars("</struct>");
    }

    void writeVarBegin(String name) throws IOException {
        this.writeUnformattedChars("<var name='");
        this.writeAttribChars(name.toCharArray());
        this.writeUnformattedChars("'>");
    }

    void writeVarEnd() throws IOException {
        this.writeUnformattedChars("</var>");
    }

    void writeArrayBegin(int length) throws IOException {
        this.writeUnformattedChars("<array length='");
        this.writeUnformattedChars(String.valueOf(length));
        this.writeUnformattedChars("'>");
    }

    void writeArrayEnd() throws IOException {
        this.writeUnformattedChars("</array>");
    }

    void writeRecordSetBegin(int rowCount, String[] fields, String type) throws IOException {
        this.writeUnformattedChars("<recordset rowCount='");
        this.writeUnformattedChars(String.valueOf(rowCount));
        this.writeUnformattedChars("' fieldNames='");
        for (int i = 0; i < fields.length; ++i) {
            if (i > 0) {
                this.writeUnformattedChars(",");
            }
            this.writeUnformattedChars(fields[i]);
        }
        this.writeUnformattedChars("' type='" + type);
        this.writeUnformattedChars("'>");
    }

    void writeRecordSetEnd() throws IOException {
        this.writeUnformattedChars("</recordset>");
    }

    void writeFieldBegin(String name) throws IOException {
        this.writeUnformattedChars("<field name='");
        this.writeAttribChars(name.toCharArray());
        this.writeUnformattedChars("'>");
    }

    void writeFieldEnd() throws IOException {
        this.writeUnformattedChars("</field>");
    }

    @Override
    public void writeUTF(String str) throws IOException {
        throw new IOException("writeUTF() cannot be called");
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.writeLong(v);
    }

    @Override
    public void writeObject(Object obj) throws IOException {
        if (obj != null) {
            if (obj instanceof JavaProxy) {
                obj = ((JavaProxy)obj).getObject();
            }
            if (obj instanceof XmlNodeList) {
                throw new ObjectNotSupportedException(XmlNodeList.class.getName());
            }
            WddxObjectSerializer os = this.m_serializer.getSerializerFactory().getSerializer(obj);
            if (os == null) {
                throw new IOException("cannot serialize object type " + obj.toString());
            }
            os.writeObject(this, obj);
        } else {
            this.writeNull();
        }
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.writeUnformattedChars("<number>");
        this.writeUnformattedChars(String.valueOf(v));
        this.writeUnformattedChars("</number>");
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.writeLong(v);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.writeDouble(v);
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.writeUnformattedChars("<number>");
        this.writeUnformattedChars(String.valueOf(v));
        this.writeUnformattedChars("</number>");
    }

    public void writeCharArray(char[] s) throws IOException {
        if (s != null) {
            this.writeUnformattedChars("<string>");
            this.writeChars(s);
            this.writeUnformattedChars("</string>");
        } else {
            this.writeNull();
        }
    }

    @Override
    public void writeChars(String s) throws IOException {
        if (s != null) {
            this.writeUnformattedChars("<string>");
            char[] data = s.toCharArray();
            this.writeChars(data);
            this.writeUnformattedChars("</string>");
        } else {
            this.writeNull();
        }
    }

    public void writeByteArray(byte[] b) throws IOException {
        this.writeUnformattedChars("<binary length='" + b.length + "'>");
        this.writeUnformattedChars(Base64Encoder.encode(b));
        this.writeUnformattedChars("</binary>");
    }

    @Override
    public void writeChar(int v) throws IOException {
        throw new IOException("writeChar() cannot be called");
    }

    @Override
    public void writeBytes(String s) throws IOException {
        throw new IOException("writeBytes() cannot be called");
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.writeLong(v);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        if (v) {
            this.writeUnformattedChars("<boolean value='true'/>");
        } else {
            this.writeUnformattedChars("<boolean value='false'/>");
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        throw new IOException("write(byte b[], int off, int len) cannot be called");
    }

    @Override
    public void write(byte[] b) throws IOException {
        throw new IOException("write(byte b[]) cannot be called");
    }

    @Override
    public void write(int b) throws IOException {
        throw new IOException("write(int b) cannot be called");
    }

    public void writeDictionary(Dictionary d) throws IOException {
        if (d != null) {
            String type = null;
            try {
                type = (String)d.get("_wddx_structAttributes_type");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (type == null) {
                type = d.getClass().getName();
            }
            this.writeStructBegin(type);
            Enumeration keys = d.keys();
            Enumeration values = d.elements();
            while (keys.hasMoreElements() && values.hasMoreElements()) {
                try {
                    Object value = values.nextElement();
                    String name = keys.nextElement().toString();
                    if (value == type) continue;
                    this.writeVarBegin(name);
                    this.writeObject(value);
                    this.writeVarEnd();
                }
                catch (NoSuchElementException e) {
                    throw new IOException("Mismatched enumerations");
                }
            }
            this.writeStructEnd();
        } else {
            this.writeNull();
        }
    }

    public void writeRecordSet(RecordSet rs) throws IOException {
        if (rs != null) {
            int rowCount = rs.getRowCount();
            int columnCount = rs.getColumnCount();
            String[] columnNames = rs.getColumnNames();
            String type = rs.getRecordsetType();
            try {
                this.writeRecordSetBegin(rowCount, columnNames, type);
                for (int column = 0; column < columnCount; ++column) {
                    this.writeFieldBegin(columnNames[column]);
                    for (int row = 0; row < rowCount; ++row) {
                        this.writeObject(rs.getField(row + 1, column + 1));
                    }
                    this.writeFieldEnd();
                }
                this.writeRecordSetEnd();
            }
            catch (RecordSetException e) {
                throw new IOException("Recordset exception");
            }
        } else {
            this.writeNull();
        }
    }

    public void writeObjectArray(Object[] values, int start, int length) throws IOException {
        this.writeArrayBegin(length);
        for (int i = start; i < start + length; ++i) {
            this.writeObject(values[i]);
        }
        this.writeArrayEnd();
    }

    public void writeObjectArray(Object[] values) throws IOException {
        this.writeObjectArray(values, 0, values.length);
    }

    public void writeVector(Vector v) throws IOException {
        if (v != null) {
            int size = v.size();
            this.writeArrayBegin(size);
            for (int i = 0; i < size; ++i) {
                this.writeObject(v.elementAt(i));
            }
            this.writeArrayEnd();
        } else {
            this.writeNull();
        }
    }

    public void writeDate(Date d) throws IOException {
        if (d != null) {
            this.writeUnformattedChars("<dateTime>");
            this.writeUnformattedChars(ISO8601.stringValueOf(d, this.usingTimezone));
            this.writeUnformattedChars("</dateTime>");
        } else {
            this.writeNull();
        }
    }

    public void writeNull() throws IOException {
        this.writeUnformattedChars("<null/>");
    }

    public void disableTimezoneInfo() {
        this.usingTimezone = false;
    }

    protected void writeChars(char[] data, SpecialCharInfo[] charTable) throws IOException {
        int beg = 0;
        int end = 0;
        while (data.length > 0 && end < data.length) {
            boolean isDone;
            char c = data[end];
            boolean bl = isDone = ++end == data.length;
            while (!isDone && c < '\u0100' && !charTable[c].isSpecialChar) {
                c = data[end];
                isDone = ++end >= data.length;
            }
            if (isDone && c < '\u0100' && !charTable[c].isSpecialChar) {
                this.m_out.write(data, beg, end - beg);
                break;
            }
            if (end > beg + 1) {
                this.m_out.write(data, beg, end - beg - 1);
            }
            if (c < '\u0100') {
                this.m_out.write(charTable[c].encoding);
            } else {
                this.m_out.write("&#x");
                this.m_out.write(Integer.toHexString(c));
                this.m_out.write(";");
            }
            beg = end;
        }
    }

    public void writeChars(char[] data) throws IOException {
        this.writeChars(data, this.m_UTF8CharTable);
    }

    void writeAttribChars(char[] data) throws IOException {
        this.writeChars(data, this.m_UTF8AttrCharTable);
    }

    public void writeStructBegin(String type, String sortType, String sortOrder, Boolean localeSensitive) throws IOException {
        this.writeUnformattedChars("<struct type='");
        this.writeUnformattedChars(type);
        this.writeUnformattedChars("' sorttype='");
        this.writeUnformattedChars(sortType);
        this.writeUnformattedChars("' sortorder='");
        this.writeUnformattedChars(sortOrder);
        this.writeUnformattedChars("' localesensitive='");
        this.writeUnformattedChars(localeSensitive.toString());
        this.writeUnformattedChars("' >");
    }

    public static class ObjectNotSupportedException
    extends ApplicationException {
        private static final long serialVersionUID = 1L;
        private String objType;

        public ObjectNotSupportedException(String objType) {
            this.objType = objType;
        }

        public String getObjType() {
            return this.objType;
        }
    }
}

