/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.wddx;

import coldfusion.wddx.WddxObjectSerializerFactory;
import coldfusion.wddx.WddxOutputStream;
import coldfusion.wddx.WddxWriter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;

public class WddxSerializer {
    private static WddxObjectSerializerFactory m_staticSerializerFactory = new WddxObjectSerializerFactory();
    protected String m_version;
    protected WddxObjectSerializerFactory m_serializerFactory;
    private boolean usingTimezone = true;
    private String encoding = "UTF-8";

    public WddxSerializer() throws IllegalArgumentException {
        this.init("1.0", m_staticSerializerFactory);
    }

    public WddxSerializer(String encoding) throws IllegalArgumentException {
        this.encoding = encoding;
        this.init("1.0", m_staticSerializerFactory);
    }

    public WddxSerializer(WddxObjectSerializerFactory serializerFactory) throws IllegalArgumentException {
        this.init("1.0", serializerFactory);
    }

    public WddxSerializer(WddxObjectSerializerFactory serializerFactory, String encoding) throws IllegalArgumentException {
        this.encoding = encoding;
        this.init("1.0", serializerFactory);
    }

    private void init(String version, WddxObjectSerializerFactory serializerFactory) throws IllegalArgumentException {
        if (version == null || version.compareTo("1.0") != 0) {
            throw new IllegalArgumentException("Invalid version number");
        }
        if (serializerFactory == null) {
            throw new IllegalArgumentException("Null serializer factory");
        }
        this.m_version = version;
        this.m_serializerFactory = serializerFactory;
    }

    public WddxObjectSerializerFactory getSerializerFactory() {
        return this.m_serializerFactory;
    }

    public static WddxObjectSerializerFactory getDefaultSerializerFactory() {
        return m_staticSerializerFactory;
    }

    public void serialize(Object obj, Writer out) throws NullPointerException, IOException {
        if (out == null) {
            throw new IllegalArgumentException("Null output writer");
        }
        PrintWriter pw = new PrintWriter(out);
        pw.print("<wddxPacket version='1.0'><header/><data>");
        WddxOutputStream os = new WddxOutputStream(this, pw);
        if (!this.usingTimezone) {
            os.disableTimezoneInfo();
        }
        os.writeObject(obj);
        pw.print("</data></wddxPacket>");
        pw.flush();
    }

    public void serialize(Object obj, OutputStream out) throws NullPointerException, IOException {
        if (out == null) {
            throw new IllegalArgumentException("Null output stream");
        }
        if ("UTF-8".equals(this.encoding)) {
            this.encoding = "UTF8";
        }
        PrintWriter pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter(out, this.encoding)));
        pw.print("<wddxPacket version='1.0'><header/><data>");
        WddxWriter os = new WddxWriter(this, pw);
        if (!this.usingTimezone) {
            os.disableTimezoneInfo();
        }
        os.writeObject(obj);
        pw.print("</data></wddxPacket>");
        pw.flush();
    }

    public void disableTimezoneInfo() {
        this.usingTimezone = false;
    }
}

