/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.wddx;

import coldfusion.wddx.SpecialCharInfo;
import coldfusion.wddx.WddxOutputStream;
import coldfusion.wddx.WddxSerializer;
import java.io.IOException;
import java.io.PrintWriter;

public class WddxWriter
extends WddxOutputStream {
    private static final SpecialCharInfo[] charInfo = new SpecialCharInfo[128];
    private static final SpecialCharInfo[] attrCharInfo = new SpecialCharInfo[128];

    public WddxWriter(WddxSerializer serializer, PrintWriter out) {
        super(serializer, out);
    }

    @Override
    protected void init() {
    }

    @Override
    protected void writeChars(char[] data, SpecialCharInfo[] charTable) throws IOException {
        int beg = 0;
        int end = 0;
        while (data.length > 0 && end < data.length) {
            boolean isDone;
            char c = data[end];
            boolean isSpecialChar = this.isSpecialChar(c, charTable);
            boolean bl = isDone = ++end == data.length;
            while (!isDone && !isSpecialChar) {
                c = data[end];
                isSpecialChar = this.isSpecialChar(c, charTable);
                isDone = ++end >= data.length;
            }
            if (isDone && !isSpecialChar) {
                this.m_out.write(data, beg, end - beg);
                break;
            }
            if (end > beg + 1) {
                this.m_out.write(data, beg, end - beg - 1);
            }
            this.m_out.write(charTable[c].encoding);
            beg = end;
        }
    }

    @Override
    public void writeChars(char[] data) throws IOException {
        this.writeChars(data, charInfo);
    }

    @Override
    void writeAttribChars(char[] data) throws IOException {
        this.writeChars(data, attrCharInfo);
    }

    private boolean isSpecialChar(char c, SpecialCharInfo[] charTable) {
        if (c < '\u0080') {
            return charTable[c] != null;
        }
        return false;
    }

    static {
        String charImage = new String("<char code='00'/>");
        for (int i = 0; i < 32; ++i) {
            SpecialCharInfo info = new SpecialCharInfo();
            info.isSpecialChar = true;
            info.encoding = charImage.toCharArray();
            info.encoding[12] = Character.forDigit(i / 16, 16);
            info.encoding[13] = Character.forDigit(i % 16, 16);
            WddxWriter.charInfo[i] = info;
            WddxWriter.attrCharInfo[i] = info;
        }
        SpecialCharInfo info = new SpecialCharInfo();
        info.isSpecialChar = true;
        info.encoding = new String("&lt;").toCharArray();
        WddxWriter.charInfo[60] = info;
        WddxWriter.attrCharInfo[60] = info;
        info = new SpecialCharInfo();
        info.isSpecialChar = true;
        info.encoding = new String("&gt;").toCharArray();
        WddxWriter.charInfo[62] = info;
        WddxWriter.attrCharInfo[62] = info;
        info = new SpecialCharInfo();
        info.isSpecialChar = true;
        info.encoding = new String("&amp;").toCharArray();
        WddxWriter.charInfo[38] = info;
        WddxWriter.attrCharInfo[38] = info;
        info = new SpecialCharInfo();
        info.isSpecialChar = true;
        info.encoding = new String("&apos;").toCharArray();
        WddxWriter.attrCharInfo[39] = info;
        info = new SpecialCharInfo();
        info.isSpecialChar = true;
        info.encoding = new String("&quot;").toCharArray();
        WddxWriter.attrCharInfo[34] = info;
    }
}

