/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.xml;

import coldfusion.runtime.Array;
import coldfusion.runtime.Cast;
import coldfusion.runtime.Scope;
import coldfusion.xml.XmlFunctions;
import coldfusion.xml.XmlNameMatcher;
import java.util.Iterator;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class XmlAttrMap
extends Scope {
    private NamedNodeMap attrMap;
    private Element elem;
    protected boolean isCaseSensitive = false;

    public XmlAttrMap(Element element, NamedNodeMap attributesMap, boolean caseSensitive) {
        this.attrMap = attributesMap;
        this.elem = element;
        this.isCaseSensitive = caseSensitive;
    }

    private Attr findAttribute(String name) {
        for (int i = 0; i < this.attrMap.getLength(); ++i) {
            Attr attr = (Attr)this.attrMap.item(i);
            if (!XmlNameMatcher.isMatch(name, attr.getName(), this.isCaseSensitive)) continue;
            return attr;
        }
        return null;
    }

    @Override
    protected void bindName_Final(String key, Object obj) {
        this.bindName(key, obj);
    }

    @Override
    protected void bindName(String key, Object obj) {
        Attr attr = this.findAttribute(key);
        String val = Cast._String(obj);
        if (attr == null) {
            this.elem.setAttribute(key, val);
        } else {
            attr.setNodeValue(val);
        }
    }

    @Override
    protected void unbindName(String name) {
        Attr attr = this.findAttribute(name);
        if (attr != null) {
            this.elem.removeAttributeNode(attr);
        }
    }

    @Override
    protected Object resolveName(String name) {
        Attr attr = this.findAttribute(name);
        if (attr != null) {
            return attr.getNodeValue();
        }
        return null;
    }

    @Override
    protected boolean containsName(String name) {
        Attr attr = this.findAttribute(name);
        return attr != null;
    }

    @Override
    protected Iterator getNames() {
        Array array = new Array();
        for (int i = 0; i < this.attrMap.getLength(); ++i) {
            Attr attr = (Attr)this.attrMap.item(i);
            array.addElement(attr.getName());
        }
        return array.iterator();
    }

    @Override
    public void clear() {
        XmlFunctions.removeAttributes(this.elem);
    }

    @Override
    public boolean isEmpty() {
        return this.attrMap.getLength() == 0;
    }

    @Override
    public int size() {
        return this.attrMap.getLength();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }
}

