/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.xml;

import coldfusion.runtime.Array;
import coldfusion.runtime.ArrayUtil;
import coldfusion.runtime.Cast;
import coldfusion.runtime.StructUtils;
import coldfusion.xml.XMLNamespaceException;
import coldfusion.xml.XmlConfigurationException;
import coldfusion.xml.XmlDomException;
import coldfusion.xml.XmlInvalidIdentifierException;
import coldfusion.xml.XmlInvalidNamespaceException;
import coldfusion.xml.XmlNameMatcher;
import coldfusion.xml.XmlNodeArray;
import coldfusion.xml.XmlNodeList;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XmlFunctions {
    private static final String NODE_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n";

    public static Document documentNew() {
        try {
            DocumentBuilderFactory f = DocumentBuilderFactory.newInstance();
            f.setNamespaceAware(true);
            DocumentBuilder b = f.newDocumentBuilder();
            return b.newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new XmlConfigurationException("Parser", e.getMessage());
        }
    }

    public static XmlNodeList XmlDocumentNew(boolean caseSensitive) {
        Document doc = XmlFunctions.documentNew();
        return new XmlNodeList(doc, caseSensitive);
    }

    public static XmlNodeList XmlElementNew(XmlNodeList docObj, String name) {
        if (docObj.getFirstNode() instanceof Document) {
            Document doc = (Document)docObj.getFirstNode();
            int index = name.indexOf(58);
            if (index > 0) {
                String prefix = name.substring(0, index);
                Element elem = doc.getDocumentElement();
                String uri = null;
                if (elem != null) {
                    elem.getAttributes();
                    NamedNodeMap NodeMap = elem.getAttributes();
                    Node node = NodeMap.getNamedItem("xmlns:" + prefix);
                    if (node != null) {
                        uri = node.getNodeValue();
                    }
                }
                if (uri != null) {
                    return XmlFunctions.XmlElementNew(docObj, uri, name);
                }
            }
            try {
                return new XmlNodeList(doc.createElement(name), false);
            }
            catch (DOMException domE) {
                throw new XmlInvalidIdentifierException(name);
            }
        }
        return null;
    }

    public static XmlNodeList XmlElementNew(XmlNodeList docObj, String namespaceURI, String qualifiedName) {
        if (docObj.getFirstNode() instanceof Document) {
            Document doc = (Document)docObj.getFirstNode();
            try {
                Element e1 = doc.createElementNS(namespaceURI, qualifiedName);
                XmlFunctions.setNamespaceURI(e1, namespaceURI, qualifiedName);
                return new XmlNodeList(e1, false);
            }
            catch (DOMException domE) {
                switch (domE.code) {
                    case 5: {
                        throw new XmlInvalidIdentifierException(qualifiedName);
                    }
                    case 14: {
                        throw new XmlInvalidNamespaceException(qualifiedName, namespaceURI);
                    }
                }
                throw new XmlDomException(domE.getMessage());
            }
        }
        return null;
    }

    public static void removeNodes(Node node, int nodeType1, int nodeType2) {
        Node child = node.getFirstChild();
        while (child != null) {
            Node sibling = child.getNextSibling();
            if (child.getNodeType() == nodeType1 || child.getNodeType() == nodeType2) {
                node.removeChild(child);
            }
            child = sibling;
        }
    }

    private static String getConcatString(Node node, int type1, int type2) {
        StringBuffer text = new StringBuffer();
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node child = list.item(i);
            short childType = child.getNodeType();
            if (childType != type1 && childType != type2) continue;
            text.append(child.getNodeValue());
        }
        return new String(text);
    }

    public static String getType(Node node) {
        return XmlFunctions.nodeTypeToStr(node.getNodeType());
    }

    public static String getName(Node node) {
        return XmlFunctions.nullToStr(node.getNodeName());
    }

    public static String getValue(Node node) {
        return XmlFunctions.nullToStr(node.getNodeValue());
    }

    private static String nodeTypeToStr(short type) {
        switch (type) {
            case 1: {
                return "ELEMENT";
            }
            case 2: {
                return "ATTRIBUTE";
            }
            case 3: {
                return "TEXT";
            }
            case 4: {
                return "CDATA";
            }
            case 5: {
                return "ENTITYREF";
            }
            case 6: {
                return "ENTITY";
            }
            case 7: {
                return "PI";
            }
            case 8: {
                return "COMMENT";
            }
            case 9: {
                return "DOCUMENT";
            }
            case 10: {
                return "DOCTYPE";
            }
            case 11: {
                return "FRAGMENT";
            }
            case 12: {
                return "NOTATION";
            }
        }
        return "";
    }

    public static void setComment(Document node, String text) {
        XmlFunctions.removeNodes(node, 8, 8);
        Comment comment = node.createComment(text);
        node.appendChild(comment);
    }

    public static void setAttributes(Element elem, Object attrObj) {
        Map attributes = Cast._Map(attrObj);
        Array attrKeyArray = StructUtils.StructKeyArray(attributes);
        for (int i = 0; i < ArrayUtil.ArrayLen(attrKeyArray); ++i) {
            Object obj = attrKeyArray.get(i);
            String key = Cast._String(obj);
            obj = attributes.get(key);
            String val = Cast._String(obj);
            elem.setAttribute(key, val);
        }
    }

    private static String nullToStr(String str) {
        return str == null ? "" : str;
    }

    public static void removeAttributes(Node node) {
        NamedNodeMap attrMap = node.getAttributes();
        if (attrMap != null) {
            for (int i = attrMap.getLength() - 1; i >= 0; --i) {
                Attr attr = (Attr)attrMap.item(i);
                attrMap.removeNamedItem(attr.getName());
            }
        }
    }

    public static String getText(Element elem) {
        return XmlFunctions.getConcatString(elem, 3, 4);
    }

    public static void setText(Element elem, String text) {
        XmlFunctions.removeNodes(elem, 3, 4);
        Text node = elem.getOwnerDocument().createTextNode(text);
        elem.appendChild(node);
    }

    public static void setCData(Element elem, String text) {
        XmlFunctions.removeNodes(elem, 3, 4);
        CDATASection node = elem.getOwnerDocument().createCDATASection(text);
        elem.appendChild(node);
    }

    public static String getComment(Node node) {
        return XmlFunctions.getConcatString(node, 8, 8);
    }

    public static void setComment(Element node, String text) {
        XmlFunctions.removeNodes(node, 8, 8);
        Document doc = node.getOwnerDocument();
        Comment comment = doc.createComment(text);
        node.appendChild(comment);
    }

    public static String getNamespaceURI(Node elem, String nameSpace) {
        NamedNodeMap map = elem.getAttributes();
        if (map == null) {
            return "";
        }
        for (int i = 0; i < map.getLength(); ++i) {
            Attr att = (Attr)map.item(i);
            String AttName = att.getName();
            if (!AttName.equalsIgnoreCase(nameSpace)) continue;
            return att.getValue();
        }
        Node parent = elem.getParentNode();
        if (parent != null) {
            return XmlFunctions.getNamespaceURI(parent, nameSpace);
        }
        return "";
    }

    public static String getNamespaceURI(Node elem) {
        String elemName = elem.getNodeName();
        Object nameSpace = "xmlns";
        if (XmlNameMatcher.isQualifiedName(elemName)) {
            String elemPrefix = XmlNameMatcher.getPrefix(elemName);
            nameSpace = (String)nameSpace + ":" + elemPrefix;
        }
        return XmlFunctions.getNamespaceURI(elem, (String)nameSpace);
    }

    public static void setNamespaceURI(Element elm, String namespaceURI, String qualifiedName) throws DOMException {
        if (elm == null || qualifiedName == null) {
            return;
        }
        if (namespaceURI == null) {
            namespaceURI = "";
        }
        String prefix = null;
        int index = qualifiedName.indexOf(58);
        if (index != -1) {
            prefix = qualifiedName.substring(0, index);
        }
        Object nameSpace = prefix == null ? "xmlns" : "xmlns:" + prefix;
        elm.setAttribute((String)nameSpace, namespaceURI);
    }

    public static void setNamespaceURI(Element elem, String uri) {
        if (elem == null || uri == null) {
            return;
        }
        String prefix = elem.getPrefix();
        if (prefix != null) {
            elem.setAttribute("xmlns:" + prefix, uri);
            return;
        }
        elem.setAttribute("xmlns", uri);
    }

    public static String getNamespacePrefix(Element elem) {
        String elemName = elem.getNodeName();
        if (XmlNameMatcher.isQualifiedName(elemName)) {
            return XmlNameMatcher.getPrefix(elemName);
        }
        return "";
    }

    public static void setNamespacePrefix(Element elem, String prefix) {
        if (elem == null || prefix == null) {
            return;
        }
        try {
            elem.setPrefix(prefix);
        }
        catch (DOMException e) {
            throw new XMLNamespaceException(e);
        }
    }

    public static void setParent(Element elem, Element parent) {
        Element oldParent = (Element)elem.getParentNode();
        oldParent.removeChild(elem);
        parent.appendChild(elem);
    }

    public static XmlNodeArray getChildren(Element elem) {
        return new XmlNodeArray(elem, true);
    }

    public static int getNthChildIndex(XmlNodeList elem, String name, int N) {
        NodeList list = elem.getFirstNode().getChildNodes();
        int arrayIdx = 0;
        int childCount = 0;
        for (int i = 0; i < list.getLength(); ++i) {
            Node child = list.item(i);
            if (child.getNodeType() != 1) continue;
            ++arrayIdx;
            if (!XmlNameMatcher.isMatch(name, child.getNodeName(), elem.isCaseSensitive) || ++childCount != N) continue;
            return arrayIdx;
        }
        return -1;
    }

    public static void removeChildren(Element elem) {
        XmlFunctions.removeNodes(elem, 1, 1);
    }

    public static XmlNodeArray getNodes(Node node) {
        return new XmlNodeArray(node, false);
    }

    public static String serializeToString(Element node) throws IOException {
        OutputFormat format = new OutputFormat();
        StringWriter writer = new StringWriter();
        XMLSerializer serializer = new XMLSerializer((Writer)writer, format);
        serializer.serialize(node);
        String retval = writer.toString();
        if (node instanceof Document) {
            return retval;
        }
        Document doc = node.getOwnerDocument();
        if (doc != null && node == doc.getDocumentElement()) {
            return retval;
        }
        return retval.substring(NODE_HEADER.length());
    }
}

