/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.xml;

import coldfusion.monitor.memory.MemoryTrackerProxy;
import coldfusion.xml.XmlFunctions;
import coldfusion.xml.XmlNodeList;
import java.io.IOException;
import java.util.AbstractList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlNodeArray
extends AbstractList {
    private Node node;
    protected boolean isCaseSensitive = false;
    private boolean childrenOnly = true;
    private MemoryTrackerProxy mtp;

    public XmlNodeArray(Node node, boolean childrenOnly) {
        this.node = node;
        this.childrenOnly = childrenOnly;
    }

    public void setCase(boolean caseSensitive) {
        this.isCaseSensitive = caseSensitive;
    }

    @Override
    public int size() {
        int size = 0;
        NodeList list = this.node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            if (this.childrenOnly) {
                if (list.item(i).getNodeType() != 1) continue;
                ++size;
                continue;
            }
            ++size;
        }
        return size;
    }

    private Node getChildrenNode(int idx) {
        int size = 0;
        NodeList list = this.node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            if (list.item(i).getNodeType() != 1) continue;
            if (size == idx) {
                return list.item(i);
            }
            ++size;
        }
        throw new IndexOutOfBoundsException();
    }

    private Node getNode(int idx) {
        if (this.childrenOnly) {
            return this.getChildrenNode(idx);
        }
        NodeList list = this.node.getChildNodes();
        if (idx >= 0 && idx < list.getLength()) {
            return list.item(idx);
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public Object get(int idx) {
        XmlNodeList xmlNodeList = new XmlNodeList(this.getNode(idx), this.isCaseSensitive);
        if (this.mtp != null) {
            xmlNodeList.setMemoryTrackerProxy(this.mtp);
        }
        return xmlNodeList;
    }

    @Override
    public Object set(int i, Object obj) {
        if (!(obj instanceof XmlNodeList)) {
            throw new ClassCastException();
        }
        Node newNode = ((XmlNodeList)obj).getFirstNode();
        newNode = newNode.cloneNode(true);
        if (i < this.size()) {
            Node oldNode = this.getNode(i);
            this.removeFromMemoryTracker(oldNode);
            this.node.replaceChild(newNode, oldNode);
            this.addToMemoryTracker(newNode);
            return oldNode;
        }
        this.node.appendChild(newNode);
        this.addToMemoryTracker(newNode);
        return newNode;
    }

    @Override
    public void add(int i, Object obj) {
        if (!(obj instanceof XmlNodeList)) {
            throw new ClassCastException();
        }
        Node newNode = ((XmlNodeList)obj).getFirstNode();
        newNode = newNode.cloneNode(true);
        if (i < this.size()) {
            Node oldNode = this.getNode(i);
            this.node.insertBefore(newNode, oldNode);
        } else {
            this.node.appendChild(newNode);
        }
        this.addToMemoryTracker(newNode);
    }

    @Override
    public Object remove(int i) {
        Node oldNode = this.getNode(i);
        this.removeFromMemoryTracker(oldNode);
        this.node.removeChild(oldNode);
        return oldNode;
    }

    public void setMemoryTrackerProxy(MemoryTrackerProxy mtp) {
        this.mtp = mtp;
    }

    private void addToMemoryTracker(Object obj) {
        if (this.mtp != null) {
            if (obj instanceof Document) {
                obj = ((Document)obj).getDocumentElement();
            }
            if (obj instanceof Element) {
                try {
                    this.mtp.onAddObject(XmlFunctions.serializeToString((Element)obj));
                }
                catch (IOException iOException) {}
            } else {
                this.mtp.onAddObject(obj);
            }
        }
    }

    private void removeFromMemoryTracker(Object obj) {
        if (this.mtp != null) {
            if (obj instanceof Document) {
                obj = ((Document)obj).getDocumentElement();
            }
            if (obj instanceof Element) {
                try {
                    this.mtp.onRemoveObject(XmlFunctions.serializeToString((Element)obj));
                }
                catch (IOException iOException) {}
            } else {
                this.mtp.onRemoveObject(obj);
            }
        }
    }
}

