/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.xml;

import coldfusion.util.BOMReader;
import coldfusion.xml.XmlPathUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;

public class XmlTransformResolver
implements URIResolver {
    private String basePath = null;
    private boolean fileBase = false;
    private boolean urlBase = false;

    public XmlTransformResolver() {
    }

    public XmlTransformResolver(Reader reader, String xsl) {
        if (reader instanceof FileReader || reader instanceof BOMReader) {
            File f = new File(xsl);
            this.basePath = f.getParent();
            this.fileBase = true;
        } else if (reader instanceof InputStreamReader) {
            int len = xsl.lastIndexOf("/");
            this.basePath = xsl.substring(0, len + 1);
            this.urlBase = true;
        }
    }

    public XmlTransformResolver(InputStream stream, String xsl) {
        if (stream instanceof FileInputStream) {
            File f = new File(xsl);
            this.basePath = f.getParent();
            this.fileBase = true;
        } else if (stream instanceof InputStream) {
            int len = xsl.lastIndexOf("/");
            this.basePath = xsl.substring(0, len + 1);
            this.urlBase = true;
        }
    }

    @Override
    public Source resolve(String href, String base) {
        StreamSource retval;
        block18: {
            retval = null;
            InputStream ins = null;
            try {
                ins = new FileInputStream(href);
                retval = new StreamSource(ins);
            }
            catch (FileNotFoundException fe) {
                if (this.basePath != null) {
                    if (this.urlBase) {
                        URL url;
                        if (href.toLowerCase().startsWith("http")) {
                            try {
                                url = new URL(href);
                            }
                            catch (MalformedURLException e) {
                                return null;
                            }
                        }
                        try {
                            url = new URL(this.basePath + href);
                        }
                        catch (MalformedURLException ex) {
                            return null;
                        }
                        try {
                            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                            ins = conn.getInputStream();
                            retval = new StreamSource(ins);
                        }
                        catch (IOException e) {
                            return null;
                        }
                    }
                    if (this.fileBase) {
                        if (!this.basePath.endsWith(File.separator) && !href.startsWith(File.separator)) {
                            this.basePath = this.basePath + File.separator;
                        }
                        String file = this.basePath + href;
                        try {
                            ins = new FileInputStream(file);
                            retval = new StreamSource(ins);
                        }
                        catch (FileNotFoundException e) {
                            return null;
                        }
                    }
                    return null;
                }
                Object dir = XmlPathUtil.getTemplatePathBaseDir();
                if (dir == null) break block18;
                if (!((String)dir).endsWith(File.separator) && !href.startsWith(File.separator)) {
                    dir = (String)dir + File.separator;
                }
                String file = (String)dir + href;
                try {
                    ins = new FileInputStream(file);
                    retval = new StreamSource(ins);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
        }
        return retval;
    }
}

