/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.xml.rpc;

import coldfusion.filter.FusionContext;
import coldfusion.runtime.AttributeCollection;
import coldfusion.runtime.Cast;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class AnnotationClassAdapter
extends ClassVisitor {
    private static final String REST = "REST";
    private static final String REST_PATH = "RESTPATH";
    private static final String CONSUMES = "CONSUMES";
    private static final String PRODUCES = "PRODUCES";
    private static final String HTTPMETHOD = "HTTPMETHOD";
    private static final String ENCODED = "ENCODED";
    private static final String FILEPATH = "FILEPATH";
    private static final String DEFAULT = "DEFAULT";
    private static final String ARGSOURCE = "RESTARGSOURCE";
    private static final String ARGNAME = "RESTARGNAME";
    private static final String GET = "GET";
    private static final String PUT = "PUT";
    private static final String POST = "POST";
    private static final String DELETE = "DELETE";
    private static final String HEAD = "HEAD";
    private static final String OPTIONS = "OPTIONS";
    private static final String PATCH = "PATCH";
    private static final String FORMSCOPE = "FORM";
    private static final String QUERYSCOPE = "QUERY";
    private static final String PATHSCOPE = "PATH";
    private static final String COOKIESCOPE = "COOKIE";
    private static final String HEADERSCOPE = "HEADER";
    private static final String MATRIXSCOPE = "MATRIX";
    private final AttributeCollection descriptor;
    private static final Map<String, String> annotClassMap;
    private static final Map<String, String> annotMethodMap;
    private static final Map<String, String> annotScopeMap;
    private static final Type objType;
    private static final Type strType;

    public AnnotationClassAdapter(ClassVisitor cv, AttributeCollection descriptor) {
        super(327680, cv);
        this.descriptor = descriptor;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.cv.visit(50, access, name, signature, superName, interfaces);
        this.addClassAnnotation();
    }

    private void addClassAnnotation() {
        String restEnabled = (String)this.descriptor.get(REST);
        String value = (String)this.descriptor.get(REST_PATH);
        String filePath = (String)this.descriptor.get("path");
        if (restEnabled != null && value == null) {
            value = (String)FusionContext.getCurrent().pageContext.getAttribute("_restpath_");
        }
        this.addSimpleValueAnnot(REST_PATH, value, this.cv);
        this.addSimpleValueAnnot(FILEPATH, filePath, this.cv);
        this.addArrayAnnot(PRODUCES, (String)this.descriptor.get(PRODUCES), this.cv);
        this.addArrayAnnot(CONSUMES, (String)this.descriptor.get(CONSUMES), this.cv);
        String argEncode = (String)this.descriptor.get(ENCODED);
        if (argEncode != null && Cast._boolean(argEncode)) {
            AnnotationVisitor av0 = this.cv.visitAnnotation(annotClassMap.get(ENCODED), true);
            av0.visitEnd();
        }
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv;
        String newDesc = desc;
        if (!"<init>".equalsIgnoreCase(name) && !"<clinit>".equalsIgnoreCase(name)) {
            Map funcMetadata = this.getMethodMetadata(name);
            Object[] paramMetaArray = null;
            if (funcMetadata != null) {
                boolean change = false;
                paramMetaArray = (Object[])funcMetadata.get("Parameters");
                if (paramMetaArray != null) {
                    Type[] argTypes = Type.getArgumentTypes((String)desc);
                    for (int i = 0; i < argTypes.length; ++i) {
                        Map paramMeta = (Map)paramMetaArray[i];
                        if (argTypes[i].equals((Object)objType) && paramMeta.get(ARGSOURCE) != null) {
                            argTypes[i] = strType;
                            change = true;
                        }
                        if (!change) continue;
                        newDesc = Type.getMethodDescriptor((Type)Type.getReturnType((String)desc), (Type[])argTypes);
                    }
                }
            }
            mv = this.cv.visitMethod(access, name, newDesc, signature, exceptions);
            if (funcMetadata != null) {
                String httpMethod = this.getMetadataVal(HTTPMETHOD, funcMetadata, true);
                if (null == httpMethod) {
                    if (GET.equalsIgnoreCase(name)) {
                        httpMethod = GET;
                    } else if (POST.equalsIgnoreCase(name)) {
                        httpMethod = POST;
                    } else if (PUT.equalsIgnoreCase(name)) {
                        httpMethod = PUT;
                    } else if (DELETE.equalsIgnoreCase(name)) {
                        httpMethod = DELETE;
                    } else if (HEAD.equalsIgnoreCase(name)) {
                        httpMethod = HEAD;
                    } else if (OPTIONS.equalsIgnoreCase(name)) {
                        httpMethod = OPTIONS;
                    } else if (PATCH.equalsIgnoreCase(name)) {
                        httpMethod = PATCH;
                    }
                }
                this.addSimpleAnnot(HTTPMETHOD, httpMethod, mv);
                if (HTTPMETHOD.equalsIgnoreCase(GET)) {
                    this.addSimpleAnnot(HTTPMETHOD, httpMethod, mv);
                }
                this.addSimpleValueAnnot(REST_PATH, this.getMetadataVal(REST_PATH, funcMetadata, false), mv);
                this.addArrayAnnot(PRODUCES, this.getMetadataVal(PRODUCES, funcMetadata, false), mv);
                this.addArrayAnnot(CONSUMES, this.getMetadataVal(CONSUMES, funcMetadata, false), mv);
                String argEncode = this.getMetadataVal(ENCODED, funcMetadata, false);
                if (argEncode != null && Cast._boolean(argEncode)) {
                    AnnotationVisitor av0 = mv.visitAnnotation(annotClassMap.get(ENCODED), true);
                    av0.visitEnd();
                }
                if (paramMetaArray != null) {
                    this.setParameterAnnot(mv, paramMetaArray);
                }
            }
        } else {
            mv = this.cv.visitMethod(access, name, desc, signature, exceptions);
        }
        return mv;
    }

    private void addSimpleAnnot(String strAnnot, String annotVal, MethodVisitor mv) {
        if (annotVal != null) {
            if (annotMethodMap.get(annotVal = annotVal.trim().toUpperCase()) == null) {
                throw new RuntimeException("Incorrect method: \"" + annotVal + "\" . Possible values are: POST, GET, PUT, DELETE, HEAD, PATCH, OPTIONS");
            }
            AnnotationVisitor av0 = mv.visitAnnotation(annotMethodMap.get(annotVal), true);
            av0.visitEnd();
        }
    }

    private String getMetadataVal(String strAnnot, Map funcMetadata, boolean fallBack) {
        String annotVal;
        String string = annotVal = funcMetadata == null ? null : (String)funcMetadata.get(strAnnot);
        if (fallBack && annotVal == null) {
            annotVal = (String)this.descriptor.get(strAnnot);
        }
        return annotVal;
    }

    private Map getMethodMetadata(String name) {
        Object[] functionArray = (Object[])this.descriptor.get("Functions");
        if (functionArray != null) {
            for (int index = 0; index < functionArray.length; ++index) {
                Map funcMetadata = (Map)functionArray[index];
                if (!name.equalsIgnoreCase((String)funcMetadata.get("name"))) continue;
                return funcMetadata;
            }
        }
        return null;
    }

    private void addArrayAnnot(String strAnnot, String annotVal, Object cv) {
        if (annotVal != null && annotVal.trim().length() > 0) {
            StringTokenizer t = new StringTokenizer(annotVal, ",");
            AnnotationVisitor av0 = cv instanceof MethodVisitor ? ((MethodVisitor)cv).visitAnnotation(annotClassMap.get(strAnnot), true) : ((ClassVisitor)cv).visitAnnotation(annotClassMap.get(strAnnot), true);
            AnnotationVisitor av1 = av0.visitArray("value");
            while (t.hasMoreTokens()) {
                av1.visit(null, (Object)this.sanitizeString(t.nextToken()));
            }
            av1.visitEnd();
            av0.visitEnd();
        }
    }

    private String sanitizeString(String token) {
        token = token.trim();
        while (token.startsWith("{") || token.startsWith("\"") || token.startsWith("'")) {
            token = token.substring(1);
            token.trim();
        }
        while (token.endsWith("}") || token.endsWith("\"") || token.endsWith("'")) {
            token = token.substring(0, token.length() - 1);
            token.trim();
        }
        return token;
    }

    private void addSimpleValueAnnot(String strAnnot, String value, Object cv) {
        if (value != null) {
            AnnotationVisitor av0 = cv instanceof MethodVisitor ? ((MethodVisitor)cv).visitAnnotation(annotClassMap.get(strAnnot), true) : ((ClassVisitor)cv).visitAnnotation(annotClassMap.get(strAnnot), true);
            av0.visit("value", (Object)value);
            av0.visitEnd();
        }
    }

    private void setParameterAnnot(MethodVisitor mv, Object[] paramMetaArray) {
        for (int index = 0; index < paramMetaArray.length; ++index) {
            String argEncode;
            String argDef;
            AnnotationVisitor av0 = null;
            Map paramMetadata = (Map)paramMetaArray[index];
            String argScope = (String)paramMetadata.get(ARGSOURCE);
            if (argScope != null && !(argScope = argScope.trim().toUpperCase()).equals("BODY")) {
                if (annotScopeMap.get(argScope) == null) {
                    throw new RuntimeException("incorrect argument source " + argScope);
                }
                av0 = mv.visitParameterAnnotation(index, annotScopeMap.get(argScope), true);
                String argName = (String)paramMetadata.get(ARGNAME);
                if (argName != null) {
                    av0.visit("value", (Object)argName);
                } else {
                    av0.visit("value", (Object)((String)paramMetadata.get("NAME")));
                }
                av0.visitEnd();
            }
            if ((argDef = (String)paramMetadata.get(DEFAULT)) != null) {
                av0 = mv.visitParameterAnnotation(index, annotClassMap.get(DEFAULT), true);
                av0.visit("value", (Object)argDef);
                av0.visitEnd();
            }
            if ((argEncode = (String)paramMetadata.get(ENCODED)) == null || !Cast._boolean(argEncode)) continue;
            av0 = mv.visitParameterAnnotation(index, annotClassMap.get(ENCODED), true);
            av0.visitEnd();
        }
    }

    static {
        objType = Type.getType(Object.class);
        strType = Type.getType(String.class);
        annotClassMap = new HashMap<String, String>();
        annotClassMap.put(REST_PATH, "Ljakarta/ws/rs/Path;");
        annotClassMap.put(PRODUCES, "Ljakarta/ws/rs/Produces;");
        annotClassMap.put(CONSUMES, "Ljakarta/ws/rs/Consumes;");
        annotClassMap.put(DEFAULT, "Ljakarta/ws/rs/DefaultValue;");
        annotClassMap.put(ENCODED, "Ljakarta/ws/rs/Encoded;");
        annotClassMap.put(FILEPATH, "Lcoldfusion/xml/rpc/FilePath;");
        annotMethodMap = new HashMap<String, String>();
        annotMethodMap.put(POST, "Ljakarta/ws/rs/POST;");
        annotMethodMap.put(GET, "Ljakarta/ws/rs/GET;");
        annotMethodMap.put(PUT, "Ljakarta/ws/rs/PUT;");
        annotMethodMap.put(DELETE, "Ljakarta/ws/rs/DELETE;");
        annotMethodMap.put(HEAD, "Ljakarta/ws/rs/HEAD;");
        annotMethodMap.put(OPTIONS, "Ljakarta/ws/rs/OPTIONS;");
        annotMethodMap.put(PATCH, "Ljakarta/ws/rs/PATCH;");
        annotScopeMap = new HashMap<String, String>();
        annotScopeMap.put(PATHSCOPE, "Ljakarta/ws/rs/PathParam;");
        annotScopeMap.put(QUERYSCOPE, "Ljakarta/ws/rs/QueryParam;");
        annotScopeMap.put(FORMSCOPE, "Ljakarta/ws/rs/FormParam;");
        annotScopeMap.put(COOKIESCOPE, "Ljakarta/ws/rs/CookieParam;");
        annotScopeMap.put(HEADERSCOPE, "Ljakarta/ws/rs/HeaderParam;");
        annotScopeMap.put(MATRIXSCOPE, "Ljakarta/ws/rs/MatrixParam;");
    }
}

