/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.xml.rpc;

import coldfusion.filter.FusionContext;
import coldfusion.runtime.AttributeCollection;
import coldfusion.runtime.CfJspPage;
import coldfusion.runtime.NeoPageContext;
import coldfusion.runtime.TemplateClassLoader;
import coldfusion.runtime.TemplateProxy;
import coldfusion.runtime.TemplateProxyFactory;
import coldfusion.util.FastHashtable;
import coldfusion.util.IOUtils;
import coldfusion.util.Key;
import coldfusion.xml.rpc.AnnotationClassAdapter;
import coldfusion.xml.rpc.SkeletonAssembler;
import coldfusion.xml.rpc.SkeletonClassLoader;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.HashSet;
import java.util.Set;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class BaseSkeletonClassLoader
extends ClassLoader {
    private static final String WS_SKELETON = "skeleton";
    private static final String RS_SKELETON = "restskeleton";
    private static final FastHashtable axis_byte_cache = new FastHashtable();
    private static final FastHashtable rest_byte_cache = new FastHashtable();
    protected String outputdir;
    private boolean restCall = false;
    private String metaKey = "skeleton";
    private static final FastHashtable loadedClasses = new FastHashtable();
    private final Set<String> newClasses = new HashSet<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addClass(String appName, String className) {
        FastHashtable fastHashtable = loadedClasses;
        synchronized (fastHashtable) {
            FastHashtable appClasses = (FastHashtable)loadedClasses.get(Key.getInstance(appName));
            if (appClasses == null) {
                appClasses = new FastHashtable();
                loadedClasses.put(Key.getInstance(appName), (Object)appClasses);
            }
            appClasses.put(Key.getInstance(className), (Object)"");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isClassPresent(String appName, String className) {
        FastHashtable fastHashtable = loadedClasses;
        synchronized (fastHashtable) {
            FastHashtable appClasses = (FastHashtable)loadedClasses.get(Key.getInstance(appName));
            if (appClasses == null) {
                return false;
            }
            return appClasses.get(Key.getInstance(className)) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetLoadedClasses(String appName) {
        FastHashtable fastHashtable = loadedClasses;
        synchronized (fastHashtable) {
            loadedClasses.put(Key.getInstance(appName), (Object)null);
        }
    }

    public BaseSkeletonClassLoader(String outputdir, NeoPageContext pageContext) {
        super(BaseSkeletonClassLoader.class.getClassLoader());
        this.outputdir = outputdir;
    }

    public BaseSkeletonClassLoader(String outputdir, NeoPageContext pageContext, boolean restCall) {
        super(BaseSkeletonClassLoader.class.getClassLoader());
        this.outputdir = outputdir;
        this.restCall = restCall;
        if (restCall) {
            this.metaKey = RS_SKELETON;
        }
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        name = name.substring(0, name.length() - 6).replace('/', '.');
        return new BufferedInputStream(new ByteArrayInputStream((byte[])this.getBytesMap().get(name)));
    }

    public FastHashtable getBytesMap() {
        if (this.restCall) {
            return rest_byte_cache;
        }
        return axis_byte_cache;
    }

    protected Class findClass(String className) throws ClassNotFoundException {
        TemplateProxy proxy = null;
        String javaName = SkeletonClassLoader.getSafeJavaName(className);
        try {
            if (className.endsWith("BeanInfo")) {
                byte[] bytes = (byte[])this.getBytesMap().get(javaName);
                if (bytes == null) {
                    throw new ClassNotFoundException(javaName);
                }
                Class<?> clazz = this.defineClass(javaName, bytes, 0, bytes.length);
                return clazz;
            }
            FusionContext fusionContextCurrent = FusionContext.getCurrent();
            if (fusionContextCurrent == null) {
                Class clazz = null;
                return clazz;
            }
            NeoPageContext pageContext = FusionContext.getCurrent().pageContext;
            try {
                proxy = this.resolveProxy(className, pageContext);
            }
            catch (CfJspPage.NoSuchTemplateException nte) {
                if (className.equalsIgnoreCase("WEBINF.cftags.component")) {
                    proxy = TemplateProxyFactory.resolveName("WEB-INF.cftags.component", pageContext);
                }
                throw nte;
            }
            AttributeCollection metadata = (AttributeCollection)proxy.getMetadata();
            if (null == metadata) {
                metadata = (AttributeCollection)proxy.getMetadata();
            }
            Class<?> clazz = null;
            boolean toRefresh = false;
            String appName = FusionContext.getCurrent().getRestRefreshApplication();
            if (appName != null) {
                toRefresh = true;
                if (BaseSkeletonClassLoader.isClassPresent(appName, javaName)) {
                    toRefresh = false;
                }
            }
            if (metadata != null && !toRefresh) {
                clazz = this.getSkeletonMetadata(metadata);
            }
            if (clazz == null) {
                this.newClasses.add(className);
                byte[] bytes = this.getSkeletonBytes(proxy);
                if (TemplateClassLoader.getSaveClasses()) {
                    File out = new File(this.outputdir + File.separator + javaName + ".class");
                    IOUtils.saveFile(out, new ByteArrayInputStream(bytes));
                }
                this.getBytesMap().put(javaName, (Object)bytes);
                String packageName = "";
                int indexOfDot = javaName.lastIndexOf(".");
                if (-1 != indexOfDot) {
                    packageName = javaName.substring(0, indexOfDot);
                }
                if (packageName.length() > 0) {
                    try {
                        this.definePackage(packageName, null, null, null, null, null, null, null);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                clazz = this.defineClass(javaName, bytes, 0, bytes.length);
                this.updateSkeletonMetadata(metadata, clazz);
                if (appName != null) {
                    BaseSkeletonClassLoader.addClass(appName, javaName);
                }
                final String beanName = javaName + "BeanInfo";
                final byte[] beanBytes = this.getSkeletonBeanInfoBytes(proxy);
                if (TemplateClassLoader.getSaveClasses()) {
                    if (System.getSecurityManager() == null) {
                        File out = new File(this.outputdir + File.separator + beanName + ".class");
                        IOUtils.saveFile(out, new ByteArrayInputStream(beanBytes));
                    } else {
                        AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws IOException {
                                File out = new File(BaseSkeletonClassLoader.this.outputdir + File.separator + beanName + ".class");
                                IOUtils.saveFile(out, new ByteArrayInputStream(beanBytes));
                                return null;
                            }
                        });
                    }
                }
                this.getBytesMap().put(beanName, (Object)beanBytes);
            }
            Class<?> clazz2 = clazz;
            return clazz2;
        }
        catch (ClassNotFoundException ex) {
            throw ex;
        }
        catch (Throwable t) {
            throw new ClassNotFoundException(javaName, t);
        }
        finally {
            if (proxy != null) {
                proxy.release();
            }
        }
    }

    protected TemplateProxy resolveProxy(String className, NeoPageContext pageContext) throws Throwable {
        TemplateProxy proxy = TemplateProxyFactory.resolveName(className, pageContext);
        return proxy;
    }

    protected void updateSkeletonMetadata(AttributeCollection metadata, Class clazz) {
        metadata.put(this.metaKey, (Object)clazz);
    }

    protected Class getSkeletonMetadata(AttributeCollection metadata) {
        return (Class)metadata.get(this.metaKey);
    }

    protected byte[] getSkeletonBeanInfoBytes(TemplateProxy proxy) throws Throwable {
        byte[] beanBytes = new SkeletonAssembler().assembleBeanInfo(proxy, FusionContext.getCurrent().pageContext);
        return beanBytes;
    }

    protected byte[] getSkeletonBytes(TemplateProxy proxy) throws Throwable {
        byte[] bytes = new SkeletonAssembler().assemble(proxy, FusionContext.getCurrent().pageContext);
        if (this.restCall) {
            bytes = this.annotateClass(bytes, proxy);
        }
        return bytes;
    }

    public boolean isClassNotFound(String className) {
        return this.newClasses.remove(className);
    }

    private byte[] annotateClass(byte[] classBytes, TemplateProxy proxy) {
        AttributeCollection descriptor = (AttributeCollection)proxy.getMetadata();
        ClassReader cr = new ClassReader(classBytes);
        ClassWriter cw = new ClassWriter(0);
        AnnotationClassAdapter cv = new AnnotationClassAdapter((ClassVisitor)cw, descriptor);
        cr.accept((ClassVisitor)cv, 2);
        return cw.toByteArray();
    }

    static {
        boolean bl = BaseSkeletonClassLoader.registerAsParallelCapable();
    }
}

