/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.xml.rpc;

import coldfusion.runtime.ApplicationException;
import coldfusion.server.ServiceRuntimeException;
import coldfusion.util.SoftPool;
import coldfusion.xml.rpc.CFUserCredential;
import coldfusion.xml.rpc.MethodParam;
import coldfusion.xml.rpc.ServiceProxy;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class ServiceInfo {
    protected String name;
    protected Map portMap;
    protected HashMap stubs = new HashMap();
    protected HashMap params = new HashMap();
    protected String default_port;
    protected String authtype = null;

    public String getAuthtype() {
        return this.authtype;
    }

    public void setAuthtype(String authtype) {
        this.authtype = authtype;
    }

    public ServiceInfo(String name, Map ports) {
        this.name = name;
        this.portMap = ports;
        this.default_port = (String)this.portMap.keySet().iterator().next();
    }

    public Object getStub() {
        return this.getStub(this.default_port);
    }

    public abstract Object getStub(String var1);

    public void releaseStub(String port, Object stub) {
        SoftPool pool = (SoftPool)this.stubs.get(port);
        if (pool == null) {
            pool = new SoftPool();
            this.stubs.put(port, pool);
        }
        pool.checkIn(stub);
    }

    public SoftPool getPool(String port) {
        SoftPool pool;
        if (port == null) {
            port = this.default_port;
        }
        if ((pool = (SoftPool)this.stubs.get(port)) == null) {
            pool = new SoftPool();
            this.stubs.put(port, pool);
        }
        return pool;
    }

    public MethodParam getParamInfo(String port, final Object stub) {
        MethodParam mp;
        if (port == null) {
            port = this.default_port;
        }
        if ((mp = (MethodParam)this.params.get(port)) == null) {
            try {
                mp = (MethodParam)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        return new MethodParam(stub.getClass());
                    }
                });
            }
            catch (PrivilegedActionException pex) {
                throw new ServiceRuntimeException(pex.getException());
            }
            catch (Exception ex) {
                throw new ServiceRuntimeException(ex);
            }
            this.params.put(port, mp);
        }
        return mp;
    }

    public String getName() {
        return this.name;
    }

    public Map getPortMap() {
        return this.portMap;
    }

    public abstract ServiceProxy getServiceProxy(String var1, CFUserCredential var2);

    public boolean isNTLMAuth() {
        return this.authtype != null && this.authtype.equalsIgnoreCase("NTLM");
    }

    public class BadPortException
    extends ApplicationException {
        public String portName;
        public String portList = "";

        public BadPortException(String port) {
            this.portName = port;
            Iterator it = ServiceInfo.this.portMap.keySet().iterator();
            boolean first = true;
            while (it.hasNext()) {
                String p = (String)it.next();
                if (!first) {
                    this.portList = this.portList + ",";
                }
                this.portList = this.portList + p;
                first = false;
            }
        }
    }

    public static class ServiceStubInstantiationException
    extends ApplicationException {
        public ServiceStubInstantiationException(Throwable ex) {
            super(ex);
        }
    }
}

