/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.xml.rpc;

import coldfusion.filter.FusionContext;
import coldfusion.log.CFLogs;
import coldfusion.runtime.ApplicationException;
import coldfusion.runtime.ArgumentCollection;
import coldfusion.runtime.CFBoolean;
import coldfusion.runtime.CFNumber;
import coldfusion.runtime.CFPage;
import coldfusion.runtime.Cast;
import coldfusion.runtime.ExpressionException;
import coldfusion.runtime.Invokable;
import coldfusion.runtime.NamedInvokable;
import coldfusion.runtime.ObjectDuplicator;
import coldfusion.runtime.OleDateTime;
import coldfusion.runtime.ProtectedScope;
import coldfusion.runtime.Struct;
import coldfusion.runtime.UDFMethod;
import coldfusion.runtime.java.JavaProxy;
import coldfusion.sql.QueryTable;
import coldfusion.util.CaseInsensitiveMap;
import coldfusion.util.FastHashtable;
import coldfusion.util.Key;
import coldfusion.util.RB;
import coldfusion.util.SoftPool;
import coldfusion.xml.XmlNodeList;
import coldfusion.xml.rpc.Axis1ServiceProxy;
import coldfusion.xml.rpc.Axis2ServiceProxy;
import coldfusion.xml.rpc.DocumentQueryBean;
import coldfusion.xml.rpc.MethodParam;
import coldfusion.xml.rpc.QueryBean;
import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.mail.util.ByteArrayDataSource;
import jakarta.servlet.jsp.PageContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.rpc.holders.Holder;
import org.w3c.dom.Document;

public abstract class ServiceProxy
implements Invokable,
NamedInvokable {
    public static final boolean CF_WS_PRESERVE_DATA_TYPE = Boolean.getBoolean("coldfusion.ws.literal.preservetype");
    private SoftPool pool;
    private String username;
    private String password;
    private String proxyServer;
    private String proxyPort;
    private String proxyUser;
    private String proxyPassword;
    private int timeout = 0;
    private Object service;
    private Class clazz;
    private Method[] methods;
    private MethodParam method_param;
    private String authType;

    protected ServiceProxy(Object obj, MethodParam mp, SoftPool p) {
        this.service = obj;
        this.clazz = obj.getClass();
        this.method_param = mp;
        this.pool = p;
    }

    public void close() {
        Object temp = this.service;
        this.service = null;
        this.pool.checkIn(temp);
    }

    public void setUsername(String u) {
        this.username = u;
    }

    public void setPassword(String p) {
        this.password = p;
    }

    public void setProxyServer(String s) {
        this.proxyServer = s;
    }

    public void setProxyPort(String p) {
        this.proxyPort = p;
    }

    public void setProxyUser(String u) {
        this.proxyUser = u;
    }

    public void setProxyPassword(String p) {
        this.proxyPassword = p;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setAuthype(String authType) {
        this.authType = authType;
    }

    public Object getService() {
        return this.service;
    }

    @Override
    public Object invoke(String method, Map attributes, PageContext pc) {
        if (attributes.size() == 1 && attributes.containsKey("argumentCollection")) {
            attributes = (Map)attributes.get("argumentCollection");
        }
        this.logInfoMessage();
        String[] names = this.getOperationParamNames(method, attributes.size());
        Class[] classes = this.getOperationParamClasses(method, attributes.size());
        if (this.isUnwrappingReqd(attributes.values().toArray(), names, classes)) {
            Object value;
            block20: {
                Collection values = attributes.values();
                value = values.iterator().next();
                if (value instanceof ProtectedScope) {
                    try {
                        value = ObjectDuplicator.duplicate(value);
                    }
                    catch (Exception e) {
                        if (!CFLogs.WEBSERVICE_LOG.isLoggingEnabled()) break block20;
                        CFLogs.WEBSERVICE_LOG.error(RB.getString(this, "ServiceProxy.DuplicationFailed"), e);
                    }
                }
            }
            if (value instanceof Map) {
                if (null != names && "entry".equals(names[0]) && "org.apache.ws.namespaces.axis2.map".equals(classes[0].getComponentType().getPackage() != null ? classes[0].getComponentType().getPackage().getName() : "")) {
                    Struct structAttributes = new Struct();
                    coldfusion.runtime.Array entryArray = new coldfusion.runtime.Array();
                    Map structMap = (Map)value;
                    Set entrySet = structMap.entrySet();
                    Iterator iterator = entrySet.iterator();
                    while (iterator.hasNext()) {
                        Map.Entry object;
                        Map.Entry entry = object = iterator.next();
                        Struct struct = new Struct();
                        struct.put("key", entry.getKey());
                        struct.put("value", this.convertCFPrimitives(entry.getValue()));
                        entryArray.add(struct);
                    }
                    structAttributes.put("entry", (Object)entryArray);
                    attributes = structAttributes;
                    names = this.getOperationParamNames(method, attributes.size());
                    classes = this.getOperationParamClasses(method, attributes.size());
                } else {
                    attributes = (Map)value;
                    names = this.getOperationParamNames(method, -1);
                    if (names != null) {
                        for (String name : names) {
                            if (name == null || attributes.containsKey(name)) continue;
                            attributes.put(name, null);
                        }
                    }
                    classes = this.getOperationParamClasses(method, -1);
                }
            }
            if (value instanceof QueryTable) {
                Struct queryStruct = new Struct();
                String[] columnList = ((QueryTable)value).getColumnList();
                queryStruct.put(Key.getInstance("columnList"), (Object)columnList);
                try {
                    Class<?> arrayOfObjectClazz = this.clazz.getClassLoader().loadClass("coldfusion.xml.rpc.xsd.ArrayOfObject");
                    Method setArrayMethod = arrayOfObjectClazz.getMethod("setArray", Object[].class);
                    int count = ((QueryTable)value).getRecordCount();
                    Object data = Array.newInstance(arrayOfObjectClazz, count);
                    for (int i = 0; i < count; ++i) {
                        Object row = arrayOfObjectClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        Object[] rowData = new Object[columnList.length];
                        for (int j = 0; j < columnList.length; ++j) {
                            rowData[j] = this.convertCFPrimitives(((QueryTable)value).getField(i + 1, j + 1));
                        }
                        setArrayMethod.invoke(row, new Object[]{rowData});
                        Array.set(data, i, row);
                    }
                    queryStruct.put(Key.getInstance("data"), data);
                }
                catch (Exception arrayOfObjectClazz) {
                    // empty catch block
                }
                attributes = queryStruct;
                names = this.getOperationParamNames(method, attributes.size());
                classes = this.getOperationParamClasses(method, attributes.size());
            }
            if (value instanceof XmlNodeList) {
                Struct xmlStruct = new Struct();
                xmlStruct.put(Key.getInstance("extraElement"), value);
                attributes = xmlStruct;
            }
        }
        ArrayList<String> pnames = new ArrayList<String>();
        ArrayList pvalues = new ArrayList();
        for (String n : attributes.keySet()) {
            Object val = attributes.get(n);
            pnames.add(n);
            pvalues.add(val);
        }
        Object[] values = this.rearrangeParams(names, classes, pnames, pvalues);
        try {
            return this.invokeImpl(method, values, pc);
        }
        catch (ServiceMethodNotFoundException ex) {
            throw new ServiceMethodNotFoundException(method, (Map)attributes);
        }
    }

    private boolean isUnwrappingReqd(Object[] attributes, String[] names, Class[] classes) {
        boolean isSingleAttribute;
        boolean bl = isSingleAttribute = attributes.length == 1;
        if (isSingleAttribute) {
            if (names == null) {
                return true;
            }
            if (names.length == 1) {
                if ("entry".equalsIgnoreCase(names[0]) && classes[0].isArray() && "org.apache.ws.namespaces.axis2.map".equalsIgnoreCase(classes[0].getComponentType().getPackage() != null ? classes[0].getComponentType().getPackage().getName() : "")) {
                    return true;
                }
                if ("extraElement".equalsIgnoreCase(names[0]) && "org.apache.axiom.om.OMElement".equals(classes[0].getName()) && attributes[0] instanceof XmlNodeList) {
                    return true;
                }
                if (attributes[0] instanceof Map) {
                    Map cfcMap = (Map)attributes[0];
                    return cfcMap.containsKey(names[0]);
                }
            }
        }
        return false;
    }

    protected abstract void logInfoMessage();

    @Override
    public Object invoke(String method, Object[] args, PageContext pageContext) {
        this.logInfoMessage();
        String[] names = this.getOperationParamNames(method, args.length);
        Class[] classes = this.getOperationParamClasses(method, args.length);
        if (this.isUnwrappingReqd(args, names, classes)) {
            Object value = args[0];
            if (value instanceof Map) {
                if (null != names && "entry".equals(names[0]) && "org.apache.ws.namespaces.axis2.map".equals(classes[0].getComponentType().getPackage() != null ? classes[0].getComponentType().getPackage().getName() : "")) {
                    coldfusion.runtime.Array entryArray = new coldfusion.runtime.Array();
                    Map structMap = (Map)value;
                    Set entrySet = structMap.entrySet();
                    Iterator iterator = entrySet.iterator();
                    while (iterator.hasNext()) {
                        Map.Entry object;
                        Map.Entry entry = object = iterator.next();
                        Struct struct = new Struct();
                        struct.put("key", entry.getKey());
                        struct.put("value", this.convertCFPrimitives(entry.getValue()));
                        entryArray.add(struct);
                    }
                    args[0] = entryArray;
                } else {
                    Map cfcMap = (Map)value;
                    names = this.getOperationParamNames(method, -1);
                    args = new Object[names.length];
                    for (int i = 0; i < names.length; ++i) {
                        args[i] = cfcMap.get(names[i]);
                    }
                }
            }
            if (value instanceof XmlNodeList) {
                args = new Object[]{value};
            }
            if (value instanceof QueryTable) {
                String[] columnList = ((QueryTable)value).getColumnList();
                try {
                    Class<?> arrayOfObjectClazz = this.clazz.getClassLoader().loadClass("coldfusion.xml.rpc.xsd.ArrayOfObject");
                    Method setArrayMethod = arrayOfObjectClazz.getMethod("setArray", Object[].class);
                    int count = ((QueryTable)value).getRecordCount();
                    Object data = Array.newInstance(arrayOfObjectClazz, count);
                    for (int i = 0; i < count; ++i) {
                        Object row = arrayOfObjectClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        Object[] rowData = new Object[columnList.length];
                        for (int j = 0; j < columnList.length; ++j) {
                            rowData[j] = this.convertCFPrimitives(((QueryTable)value).getField(i + 1, j + 1));
                        }
                        setArrayMethod.invoke(row, new Object[]{rowData});
                        Array.set(data, i, row);
                    }
                    args = new Object[]{columnList, data};
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return this.invokeImpl(method, args, pageContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object invokeImpl(String name, Object[] args, PageContext pageContext) {
        Object[] cast_args = new Object[args.length];
        System.arraycopy(args, 0, cast_args, 0, args.length);
        Method method = this.findMethod(name, cast_args, pageContext);
        if (method != null) {
            Object[] newargs = new Object[args.length];
            Class<?>[] classes = method.getParameterTypes();
            for (int i = 0; i < newargs.length; ++i) {
                newargs[i] = this.preProcessParam(cast_args[i], classes[i]);
            }
            Object retval = null;
            if (!(this.username == null || this.username.length() <= 0 || this.authType != null && this.authType.equalsIgnoreCase("NTLM"))) {
                this.setUserNameAndPassword(this.service, this.username, this.password);
            }
            Thread th = Thread.currentThread();
            ClassLoader old = th.getContextClassLoader();
            th.setContextClassLoader(this.service.getClass().getClassLoader());
            if (this.proxyServer != null && this.proxyServer.length() > 0) {
                this.setProxyAuthentication(this.service, this.proxyServer, this.proxyPort, this.proxyUser, this.proxyPassword);
            } else {
                this.clearProxyAuthentication(this.service);
            }
            this.setTimeOut(this.service, this.timeout * 1000);
            try {
                retval = this.convertResult(this.getResult(name, this.service, method, newargs), method.getReturnType());
            }
            finally {
                th.setContextClassLoader(old);
            }
            for (int i = 0; i < newargs.length; ++i) {
                this.postProcessParam(args[i], classes[i], newargs[i], pageContext);
            }
            return retval;
        }
        throw new ServiceMethodNotFoundException(name, args);
    }

    public abstract Object getResult(String var1, Object var2, Method var3, Object[] var4) throws ServiceInvocationException;

    public abstract void setTimeOut(Object var1, long var2);

    public abstract void clearProxyAuthentication(Object var1);

    public abstract void setProxyAuthentication(Object var1, String var2, String var3, String var4, String var5);

    public abstract void setUserNameAndPassword(Object var1, String var2, String var3);

    public abstract boolean isAssignableBinaryDataType(Object var1, Class var2);

    public abstract void addSOAPRequestHeader(String var1, String var2, Object var3, boolean var4) throws Exception;

    public abstract XmlNodeList _getSOAPRequestUsingProxy();

    public abstract XmlNodeList _getSOAPResponse() throws ExpressionException;

    public abstract Object getSOAPResponseHeader(String var1, String var2, boolean var3);

    private boolean isOutParam(Class wstype) {
        return Holder.class.isAssignableFrom(wstype);
    }

    private Object preProcessParam(Object obj, Class wstype) {
        if (this.isOutParam(wstype)) {
            Object holder = null;
            try {
                holder = wstype.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (obj != null) {
                    Field field = wstype.getField("value");
                    field.set(holder, obj);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return holder;
        }
        if (obj instanceof JavaProxy) {
            JavaProxy jp = (JavaProxy)obj;
            return jp.getObject();
        }
        return obj;
    }

    protected Object convertResult(Object retval, Class rettype) {
        if (rettype == null) {
            return "";
        }
        if (retval == null) {
            return retval;
        }
        if (retval instanceof QueryBean || retval instanceof DocumentQueryBean || "QueryBean".equals(retval.getClass().getSimpleName()) && "coldfusion.xml.rpc.xsd".equals(retval.getClass().getPackage().getName()) || "DocumentQueryBean".equals(retval.getClass().getSimpleName()) && "coldfusion.xml.rpc.xsd".equals(retval.getClass().getPackage().getName())) {
            return this.createQuery(retval);
        }
        if (retval instanceof DataHandler) {
            DataHandler handler = (DataHandler)retval;
            InputStream stream = null;
            try {
                stream = (InputStream)handler.getContent();
                int available = stream.available();
                byte[] result = new byte[available];
                stream.read(result, 0, available);
                return result;
            }
            catch (IOException e) {
                return handler;
            }
        }
        if (retval instanceof Calendar) {
            return new OleDateTime(((Calendar)retval).getTime());
        }
        if (retval instanceof Date) {
            return new OleDateTime((Date)retval);
        }
        if (retval instanceof Map || "org.apache.ws.namespaces.axis2.map".equals(rettype.getPackage() != null ? rettype.getPackage().getName() : "") || rettype.isArray() && "org.apache.ws.namespaces.axis2.map".equals(rettype.getComponentType().getPackage() != null ? rettype.getComponentType().getPackage().getName() : "") && rettype.getSimpleName().startsWith("Entry")) {
            return this.createStruct(retval);
        }
        if (rettype.isArray() || retval.getClass().isArray()) {
            if (retval.getClass().isArray() && Byte.class.getName().equals(retval.getClass().getComponentType().getName())) {
                Byte[] orig = (Byte[])retval;
                byte[] copy = new byte[orig.length];
                for (int i = 0; i < orig.length; ++i) {
                    if (orig[i] == null) continue;
                    copy[i] = orig[i];
                }
                return copy;
            }
            int length = Array.getLength(retval);
            Class<?> type = rettype.getComponentType();
            for (int i = 0; i < length; ++i) {
                Object newval;
                Object val = Array.get(retval, i);
                if (val == null || (newval = this.convertResult(val, type)) == null) continue;
                if (type.isAssignableFrom(newval.getClass())) {
                    Array.set(retval, i, newval);
                    continue;
                }
                Object cast = this.convertParam(newval, type);
                Array.set(retval, i, cast);
            }
            return retval;
        }
        if ("coldfusion.xml.rpc.xsd.StructDelegate".equals(retval.getClass().getName())) {
            return this.handleStruct(retval, rettype);
        }
        if (retval instanceof Document || "Document".equals(retval.getClass().getSimpleName()) || "coldfusion.xml.rpc.xsd.DocumentDelegate".equals(retval.getClass().getName())) {
            return this.createXmlNodeList(retval);
        }
        if ("coldfusion.xml.rpc.xsd.ArrayDelegate".equals(retval.getClass().getName())) {
            return this.handleArray(retval, rettype);
        }
        return retval;
    }

    protected abstract Object handleArray(Object var1, Class var2);

    public abstract Object handleStruct(Object var1, Class var2);

    protected abstract Object createQuery(Object var1);

    protected abstract Object createXmlNodeList(Object var1);

    protected abstract Object createStruct(Object var1);

    protected Object convertParam(Object obj, Class target_type) {
        if (obj instanceof JavaProxy) {
            obj = ((JavaProxy)obj).getObject();
        }
        if (this.isCFComponent(obj, target_type)) {
            try {
                Object target = target_type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Map map = (Map)obj;
                for (Object key : map.keySet()) {
                    Object val = map.get(key);
                    Object[] values = new Object[]{val};
                    if (values[0] instanceof UDFMethod) continue;
                    Method m = this.findSetMethod(target_type, "set" + key, values);
                    if (m != null) {
                        Class<?>[] parameterTypes = m.getParameterTypes();
                        Object newval = this.convertParam(val, parameterTypes[0]);
                        if (null != newval) {
                            values = new Object[]{newval};
                        }
                        m.invoke(target, values);
                        continue;
                    }
                    return null;
                }
                return target;
            }
            catch (InstantiationException instex) {
                throw new AbstractTypeException(target_type.getName(), instex);
            }
            catch (ApplicationException appex) {
                throw appex;
            }
            catch (Exception ex) {
                return null;
            }
        }
        if (DataHandler.class.isAssignableFrom(target_type) && obj.getClass().isArray() && obj.getClass().getComponentType().equals(Byte.TYPE)) {
            ByteArrayDataSource ds = new ByteArrayDataSource((byte[])obj, null);
            return new DataHandler((DataSource)ds);
        }
        if (this.isArray(obj, target_type)) {
            try {
                coldfusion.runtime.Array array = (coldfusion.runtime.Array)obj;
                return this.convertArray(target_type, array, this.clazz);
            }
            catch (ApplicationException appex) {
                throw appex;
            }
            catch (Exception ex) {
                return null;
            }
        }
        if (obj instanceof CFBoolean) {
            if (CF_WS_PRESERVE_DATA_TYPE) {
                Object object = obj = ((CFBoolean)obj).value ? Boolean.TRUE : Boolean.FALSE;
            }
            if (target_type == Object.class || target_type == CFBoolean.class) {
                if (CF_WS_PRESERVE_DATA_TYPE) {
                    return obj;
                }
                return obj.toString();
            }
            try {
                return Cast._cast(obj, target_type);
            }
            catch (Exception e) {
                return obj.toString();
            }
        }
        if (obj instanceof CFNumber) {
            if (CF_WS_PRESERVE_DATA_TYPE) {
                obj = ((CFNumber)obj).unwrap();
            }
            if (target_type == Object.class || CFNumber.class.isAssignableFrom(target_type)) {
                if (CF_WS_PRESERVE_DATA_TYPE) {
                    return obj;
                }
                return obj.toString();
            }
            try {
                return Cast._cast(obj, target_type);
            }
            catch (Exception e) {
                return obj.toString();
            }
        }
        if (obj instanceof QueryTable) {
            QueryTable query = (QueryTable)obj;
            return this.convertQuery(target_type, query, this.clazz);
        }
        if (this.isMapType(obj, target_type)) {
            return this.convertMap(obj, target_type, this.clazz);
        }
        if (this.isDate(obj, target_type)) {
            OleDateTime odt = (OleDateTime)obj;
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date(odt.getTime()));
            return cal;
        }
        if (obj instanceof String) {
            try {
                Object[] args = new Object[]{obj};
                Object enumValue = null;
                Method m = this.findSetMethod(target_type, "fromString", args);
                if (m != null) {
                    enumValue = m.invoke(null, args);
                }
                return enumValue;
            }
            catch (ApplicationException appex) {
                throw appex;
            }
            catch (Exception ex) {
                return null;
            }
        }
        if (obj instanceof XmlNodeList) {
            return this.convertXml(obj, target_type, this.clazz);
        }
        try {
            return Cast._cast(obj, target_type);
        }
        catch (Exception e) {
            return obj;
        }
    }

    protected abstract boolean isDate(Object var1, Class var2);

    protected abstract boolean isArray(Object var1, Class var2);

    protected abstract Object convertArray(Class var1, coldfusion.runtime.Array var2, Class var3) throws Exception;

    protected abstract boolean isCFComponent(Object var1, Class var2);

    protected abstract boolean isMapType(Object var1, Class var2);

    protected abstract Object convertQuery(Class var1, QueryTable var2, Class var3);

    protected abstract Object convertXml(Object var1, Class var2, Class var3);

    protected abstract Object convertMap(Object var1, Class var2, Class var3);

    private void postProcessParam(Object obj, Class wstype, Object retval, PageContext pageContext) {
        if (this.isOutParam(wstype)) {
            try {
                Field field = retval.getClass().getField("value");
                Object original = pageContext.findAttribute(obj.toString());
                if (original != null && original instanceof JavaProxy) {
                    pageContext.setAttribute(obj.toString(), (Object)new JavaProxy(field.get(retval)));
                } else {
                    pageContext.setAttribute(obj.toString(), field.get(retval));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private Method findSetMethod(Class c, String name, Object[] args) {
        Method[] methods = c.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Class<?>[] classes;
            Method method = methods[i];
            String m_name = method.getName();
            if (!m_name.equalsIgnoreCase(name) || (classes = method.getParameterTypes()).length != 1) continue;
            Class<?> cls = classes[0];
            Object arg = args[0];
            if (arg == null) {
                return method;
            }
            if ((arg instanceof FastHashtable || arg instanceof CaseInsensitiveMap) && Map.class.isAssignableFrom(cls)) {
                args[0] = this.convertParam(arg, cls);
                return method;
            }
            if (cls.isAssignableFrom(arg.getClass())) {
                return method;
            }
            try {
                args[0] = Cast._cast(arg, cls);
                return method;
            }
            catch (Exception ex) {
                Object cast = this.convertParam(arg, cls);
                if (cast == null) continue;
                args[0] = cast;
                return method;
            }
        }
        return null;
    }

    private Method findMethod(String name, Object[] args, PageContext pageContext) {
        if (this.methods == null) {
            this.methods = this.clazz.getMethods();
        }
        block8: for (int i = 0; i < this.methods.length; ++i) {
            Method method = this.methods[i];
            String m_name = method.getName();
            if (!m_name.equalsIgnoreCase(name)) continue;
            Class<?>[] classes = method.getParameterTypes();
            if (args.length == 0 && classes.length == 0) {
                return method;
            }
            if (args.length != classes.length) continue;
            for (int j = 0; j < classes.length; ++j) {
                if (this.isOutParam(classes[j]) && args[j].getClass() == String.class) {
                    args[j] = pageContext.findAttribute(args[j].toString());
                    if (args[j] instanceof JavaProxy) {
                        JavaProxy proxy = (JavaProxy)args[j];
                        args[j] = proxy.getObject();
                    }
                    try {
                        Field field = classes[j].getField("value");
                        classes[j] = field.getType();
                    }
                    catch (NoSuchFieldException ex) {
                        return null;
                    }
                }
                if (args[j] != null) {
                    if (args[j] instanceof FastHashtable || args[j] instanceof CaseInsensitiveMap || args[j] instanceof ArgumentCollection && Map.class.isAssignableFrom(classes[j])) {
                        args[j] = this.convertParam(args[j], classes[j]);
                    } else if (args[j] instanceof QueryTable) {
                        args[j] = this.convertParam(args[j], classes[j]);
                    } else if (args[j] instanceof XmlNodeList) {
                        args[j] = this.convertParam(args[j], classes[j]);
                    } else if (args[j] instanceof coldfusion.runtime.Array) {
                        args[j] = this.convertParam(args[j], classes[j]);
                    } else if (args[j] instanceof CFBoolean) {
                        args[j] = this.convertParam(args[j], classes[j]);
                    } else if (args[j] instanceof Date && Calendar.class.isAssignableFrom(classes[j])) {
                        try {
                            Calendar cal = Calendar.getInstance();
                            cal.setTime((Date)args[j]);
                            args[j] = cal;
                        }
                        catch (Throwable cal) {}
                    } else if (this.checkArrayComponentType(args[j], Byte.TYPE)) {
                        args[j] = this.convertParam(args[j], classes[j]);
                    } else if (!classes[j].isAssignableFrom(args[j].getClass())) {
                        if (this.isAssignableBinaryDataType(args[j], classes[j])) {
                            try {
                                byte[] bytes = ((String)args[j]).getBytes("UTF-8");
                                args[j] = this.convertParam(bytes, classes[j]);
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException) {}
                        } else {
                            try {
                                args[j] = Cast._cast(args[j], classes[j]);
                            }
                            catch (Exception ex) {
                                Object cast = this.convertParam(args[j], classes[j]);
                                if (cast == null) continue block8;
                                args[j] = cast;
                            }
                        }
                    }
                }
                if (j != classes.length - 1) continue;
                return method;
            }
        }
        return null;
    }

    public String[] getOperationParamNames(String method, int size) {
        if (this.method_param != null) {
            return this.method_param.getParamNames(method, size);
        }
        return null;
    }

    public Class[] getOperationParamClasses(String method, int size) {
        if (this.method_param != null) {
            return this.method_param.getParamTypes(method, size);
        }
        return null;
    }

    protected boolean checkArrayComponentType(Object obj, Class clazz) {
        return obj.getClass().isArray() && obj.getClass().getComponentType().equals(clazz);
    }

    private Object[] rearrangeParams(String[] names, Class[] classes, ArrayList pnames, ArrayList pvalues) {
        if (names == null || classes == null) {
            return pvalues.toArray();
        }
        Object[] values = new Object[names.length];
        for (int i = 0; i < names.length; ++i) {
            int index = this.indexOf(pnames, names[i]);
            if (index == -1) {
                throw new ParameterNameNotFoundException(names[i], pnames);
            }
            values[i] = pvalues.get(index);
        }
        return values;
    }

    private int indexOf(ArrayList pnames, String name) {
        for (int i = 0; name != null && pnames != null && i < pnames.size(); ++i) {
            if (!name.equalsIgnoreCase((String)pnames.get(i))) continue;
            return i;
        }
        return -1;
    }

    public static Object getSOAPRequestHeader(String headerNamespace, String headerName, boolean asXML) {
        if (ServiceProxy.isAxis2Engine()) {
            return Axis2ServiceProxy.getSOAPRequestHeader(headerNamespace, headerName, asXML);
        }
        return Axis1ServiceProxy.getSOAPRequestHeader(headerNamespace, headerName, asXML);
    }

    public static boolean addSOAPResponseHeader(String headerNamespace, String headerName, Object headerValue, boolean mustUnderstand) {
        if (ServiceProxy.isAxis2Engine()) {
            return Axis2ServiceProxy.addSOAPResponseHeader(headerNamespace, headerName, headerValue, mustUnderstand);
        }
        return Axis1ServiceProxy.addSOAPResponseHeader(headerNamespace, headerName, headerValue, mustUnderstand);
    }

    public static boolean _isSOAPRequest() {
        if (ServiceProxy.isAxis2Engine()) {
            return Axis2ServiceProxy._isSOAPRequest();
        }
        return Axis1ServiceProxy._isSOAPRequest();
    }

    public static XmlNodeList _getSOAPRequest() {
        if (ServiceProxy.isAxis2Engine()) {
            return Axis2ServiceProxy._getSOAPRequest();
        }
        return Axis1ServiceProxy._getSOAPRequest();
    }

    private static boolean isAxis2Engine() {
        FusionContext context = FusionContext.getCurrent();
        if (null != context) {
            return context.isAxis2Call();
        }
        return false;
    }

    protected Object convertCFPrimitives(Object value) {
        if (value instanceof CFBoolean) {
            if (CF_WS_PRESERVE_DATA_TYPE) {
                return ((CFBoolean)value).value ? Boolean.TRUE : Boolean.FALSE;
            }
            return Cast._String((CFBoolean)value);
        }
        if (value instanceof CFNumber) {
            if (CF_WS_PRESERVE_DATA_TYPE) {
                return ((CFNumber)value).unwrap();
            }
            return value.toString();
        }
        return value;
    }

    public class ServiceMethodNotFoundException
    extends ApplicationException {
        public String name;
        public String args;

        ServiceMethodNotFoundException(String name, Object[] args) {
            this.name = name;
            StringBuffer b = new StringBuffer();
            b.append('{');
            for (int i = 0; i < args.length; ++i) {
                b.append(args[i]);
                if (i >= args.length - 1) continue;
                b.append(',');
            }
            b.append('}');
            this.args = b.toString();
        }

        ServiceMethodNotFoundException(String name, Map args) {
            this.name = name;
            this.args = args.toString();
        }
    }

    public class AbstractTypeException
    extends ApplicationException {
        public String name;
        public String ex;

        public AbstractTypeException(String className, Throwable e) {
            this.ex = e.toString();
            this.name = className;
        }
    }

    public class ParameterNameNotFoundException
    extends ApplicationException {
        public String name;
        public String args;

        ParameterNameNotFoundException(String name, ArrayList args) {
            this.name = name;
            StringBuffer b = new StringBuffer();
            b.append('{');
            for (int i = 0; i < args.size(); ++i) {
                b.append(args.get(i));
                if (i >= args.size() - 1) continue;
                b.append(',');
            }
            b.append('}');
            this.args = b.toString();
        }
    }

    public class ServiceInvocationException
    extends ApplicationException {
        public String faultString;
        public String name;

        ServiceInvocationException(String name, Throwable ex) {
            super(ex);
            this.faultString = "";
            this.name = name;
        }

        ServiceInvocationException(String name, String fs) {
            this.faultString = "";
            this.faultString = CFPage.Replace(fs, "[", "\n\t[");
            this.name = name;
        }
    }
}

