/*
 * Decompiled with CFR 0.152.
 */
package com.oreilly.servlet.multipart;

import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletInputStream;
import java.io.IOException;

public class LimitedServletInputStream
extends ServletInputStream {
    private ServletInputStream in;
    private long totalExpected;
    private long totalRead = 0L;

    public LimitedServletInputStream(ServletInputStream in, long totalExpected) {
        this.in = in;
        this.totalExpected = totalExpected;
    }

    public int readLine(byte[] b, int off, int len) throws IOException {
        Long left = this.totalExpected - this.totalRead;
        if (left > Integer.MAX_VALUE) {
            left = Integer.MAX_VALUE;
        }
        if (left <= 0L) {
            return -1;
        }
        int result = this.in.readLine(b, off, Math.min(left.intValue(), len));
        if (result > 0) {
            this.totalRead += (long)result;
        }
        return result;
    }

    public int read() throws IOException {
        if (this.totalRead >= this.totalExpected) {
            return -1;
        }
        int result = this.in.read();
        if (result != -1) {
            ++this.totalRead;
        }
        return result;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        Long left = this.totalExpected - this.totalRead;
        if (left > Integer.MAX_VALUE) {
            left = Integer.MAX_VALUE;
        }
        if (left <= 0L) {
            return -1;
        }
        int result = this.in.read(b, off, Math.min(left.intValue(), len));
        if (result > 0) {
            this.totalRead += (long)result;
        }
        return result;
    }

    public boolean isFinished() {
        return false;
    }

    public boolean isReady() {
        return false;
    }

    public void setReadListener(ReadListener arg0) {
    }
}

