/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.credentialstorage.implementation.macosx;

import com.microsoft.credentialstorage.SecretStore;
import com.microsoft.credentialstorage.implementation.macosx.KeychainSecurityCliStore;
import com.microsoft.credentialstorage.model.StoredTokenPair;
import java.util.Map;

public final class KeychainSecurityBackedTokenPairStore
extends KeychainSecurityCliStore
implements SecretStore<StoredTokenPair> {
    @Override
    public StoredTokenPair get(String key) {
        Map<String, Object> accessTokenMetaData = KeychainSecurityBackedTokenPairStore.read(KeychainSecurityCliStore.SecretKind.TokenPair_Access_Token, key);
        char[] accessToken = accessTokenMetaData.size() > 0 ? ((String)accessTokenMetaData.get("password")).toCharArray() : null;
        Map<String, Object> refreshTokenMetaData = KeychainSecurityBackedTokenPairStore.read(KeychainSecurityCliStore.SecretKind.TokenPair_Refresh_Token, key);
        char[] refreshToken = refreshTokenMetaData.size() > 0 ? ((String)refreshTokenMetaData.get("password")).toCharArray() : null;
        if (accessToken != null && refreshToken != null) {
            return new StoredTokenPair(accessToken, refreshToken);
        }
        return null;
    }

    @Override
    public boolean add(String key, StoredTokenPair tokenPair) {
        if (tokenPair.getAccessToken().getValue() != null) {
            this.writeTokenKind(key, KeychainSecurityCliStore.SecretKind.TokenPair_Access_Token, tokenPair.getAccessToken());
        }
        if (tokenPair.getRefreshToken().getValue() != null) {
            this.writeTokenKind(key, KeychainSecurityCliStore.SecretKind.TokenPair_Refresh_Token, tokenPair.getRefreshToken());
        }
        return true;
    }

    @Override
    public boolean delete(String targetName) {
        return this.deleteByKind(targetName, KeychainSecurityCliStore.SecretKind.TokenPair_Access_Token) && this.deleteByKind(targetName, KeychainSecurityCliStore.SecretKind.TokenPair_Refresh_Token);
    }

    @Override
    public boolean isSecure() {
        return true;
    }
}

