/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.credentialstorage.implementation.macosx;

import com.microsoft.credentialstorage.model.StoredToken;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class KeychainSecurityCliStore {
    private static final String SECURITY = "/usr/bin/security";
    private static final String DELETE_GENERIC_PASSWORD = "delete-generic-password";
    private static final String FIND_GENERIC_PASSWORD = "find-generic-password";
    private static final String ADD_GENERIC_PASSWORD = "add-generic-password";
    private static final String ACCOUNT_PARAMETER = "-a";
    private static final String SERVICE_PARAMETER = "-s";
    private static final String KIND_PARAMETER = "-D";
    private static final String PASSWORD_PARAMETER = "-w";
    private static final String UPDATE_IF_ALREADY_EXISTS = "-U";
    private static final int ITEM_NOT_FOUND_EXIT_CODE = 44;
    private static final int USER_INTERACTION_NOT_ALLOWED_EXIT_CODE = 36;
    private static final String INTERACTIVE_MODE = "-i";
    protected static final String ACCOUNT_METADATA = "acct";
    protected static final String PASSWORD = "password";
    private static final Pattern MetadataLinePattern = Pattern.compile("^(\\w+):\\s\"(.+)\"");

    public static boolean isSupported() {
        return System.getProperty("os.name").equals("Mac OS X");
    }

    protected boolean deleteByKind(String targetName, SecretKind kind) {
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(SECURITY, DELETE_GENERIC_PASSWORD, SERVICE_PARAMETER, targetName, KIND_PARAMETER, kind.name());
            Process process = processBuilder.start();
            int result = process.waitFor();
            return result == 0;
        }
        catch (IOException | InterruptedException e) {
            throw new Error(e);
        }
    }

    private static Map<String, Object> parseKeychainMetaData(String metadata) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        KeychainSecurityCliStore.parseKeychainMetaData(metadata, result);
        return result;
    }

    private static void parseKeychainMetaData(String metadata, Map<String, Object> result) {
        StringReader sr = new StringReader(metadata);
        try (BufferedReader br = new BufferedReader(sr);){
            String line;
            boolean parsingAttributes = false;
            while ((line = br.readLine()) != null) {
                if (parsingAttributes) {
                    KeychainSecurityCliStore.parseAttributeLine(line, result);
                    continue;
                }
                if ("attributes:".equals(line)) {
                    parsingAttributes = true;
                    continue;
                }
                KeychainSecurityCliStore.parseMetadataLine(line, result);
            }
        }
        catch (IOException e) {
            throw new Error(e);
        }
    }

    private static void parseMetadataLine(String line, Map<String, Object> destination) {
        Matcher matcher = MetadataLinePattern.matcher(line);
        if (matcher.matches()) {
            String key = matcher.group(1);
            String value = matcher.group(2);
            destination.put(key, value);
        }
    }

    private static void parseAttributeLine(String line, Map<String, Object> destination) {
        String template = "Undefined transition '%1$s' from %2$s.";
        StringBuilder key = new StringBuilder();
        StringBuilder type = new StringBuilder();
        StringBuilder value = new StringBuilder();
        boolean isNullValue = false;
        AttributeParsingState state = AttributeParsingState.Spaces;
        block31: for (char c : line.toCharArray()) {
            switch (state) {
                case Spaces: {
                    switch (c) {
                        case ' ': {
                            continue block31;
                        }
                        case '0': {
                            state = AttributeParsingState.HexKey;
                            key.append(c);
                            continue block31;
                        }
                        case '\"': {
                            state = AttributeParsingState.StringKey;
                            continue block31;
                        }
                    }
                    throw new Error(String.format("Undefined transition '%1$s' from %2$s.", new Object[]{Character.valueOf(c), state}));
                }
                case HexKey: {
                    switch (c) {
                        case ' ': {
                            state = AttributeParsingState.BeforeType;
                            continue block31;
                        }
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': 
                        case 'A': 
                        case 'B': 
                        case 'C': 
                        case 'D': 
                        case 'E': 
                        case 'F': 
                        case 'x': {
                            key.append(c);
                            continue block31;
                        }
                    }
                    throw new Error(String.format("Undefined transition '%1$s' from %2$s.", new Object[]{Character.valueOf(c), state}));
                }
                case StringKey: {
                    if (c == '\"') {
                        state = AttributeParsingState.BeforeType;
                        continue block31;
                    }
                    key.append(c);
                    continue block31;
                }
                case BeforeType: {
                    if (c == '<') {
                        state = AttributeParsingState.Type;
                        continue block31;
                    }
                    throw new Error(String.format("Undefined transition '%1$s' from %2$s.", new Object[]{Character.valueOf(c), state}));
                }
                case Type: {
                    if (c == '>') {
                        state = AttributeParsingState.AfterType;
                        continue block31;
                    }
                    type.append(c);
                    continue block31;
                }
                case AfterType: {
                    if (c == '=') {
                        state = AttributeParsingState.BeforeValue;
                        continue block31;
                    }
                    throw new Error(String.format("Undefined transition '%1$s' from %2$s.", new Object[]{Character.valueOf(c), state}));
                }
                case BeforeValue: {
                    switch (c) {
                        case '<': {
                            state = AttributeParsingState.NullValue;
                            isNullValue = true;
                            value.append(c);
                            continue block31;
                        }
                        case '0': {
                            state = AttributeParsingState.TimeDateValue;
                            value.append(c);
                            continue block31;
                        }
                        case '\"': {
                            state = AttributeParsingState.StringValue;
                            continue block31;
                        }
                    }
                    throw new Error(String.format("Undefined transition '%1$s' from %2$s.", new Object[]{Character.valueOf(c), state}));
                }
                case NullValue: {
                    switch (c) {
                        case '>': {
                            state = AttributeParsingState.ValueFinished;
                            value.append(c);
                            continue block31;
                        }
                        case 'L': 
                        case 'N': 
                        case 'U': {
                            value.append(c);
                            continue block31;
                        }
                    }
                    throw new Error(String.format("Undefined transition '%1$s' from %2$s.", new Object[]{Character.valueOf(c), state}));
                }
                case StringValue: {
                    value.append(c);
                    continue block31;
                }
                case TimeDateValue: {
                    value.append(c);
                    continue block31;
                }
                case ValueFinished: {
                    throw new Error(String.format("Undefined transition '%1$s' from %2$s.", new Object[]{Character.valueOf(c), state}));
                }
            }
        }
        if (isNullValue) {
            destination.put(key.toString(), null);
        } else if ("blob".equals(type.toString())) {
            int lastCharIndex = value.length() - 1;
            value.deleteCharAt(lastCharIndex);
            destination.put(key.toString(), value.toString());
        }
    }

    private static void checkResult(int result, String stdOut, String stdErr) {
        if (result != 0) {
            if (result == 36) {
                throw new SecurityException("User interaction is not allowed.");
            }
            String template = "%1$s exited with result %2$d.\nstdOut: %3$s\nstdErr: %4$s\n";
            String message = String.format("%1$s exited with result %2$d.\nstdOut: %3$s\nstdErr: %4$s\n", SECURITY, result, stdOut, stdErr);
            throw new Error(message);
        }
    }

    protected static Map<String, Object> read(SecretKind secretKind, String serviceName) {
        String stdErr;
        String stdOut;
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(SECURITY, FIND_GENERIC_PASSWORD, SERVICE_PARAMETER, serviceName, KIND_PARAMETER, secretKind.name(), "-g");
            Process process = processBuilder.start();
            int result = process.waitFor();
            stdOut = KeychainSecurityCliStore.readToString(process.getInputStream());
            stdErr = KeychainSecurityCliStore.readToString(process.getErrorStream());
            if (result != 0 && result != 44) {
                KeychainSecurityCliStore.checkResult(result, stdOut, stdErr);
            }
        }
        catch (IOException | InterruptedException e) {
            throw new Error(e);
        }
        Map<String, Object> metaData = KeychainSecurityCliStore.parseKeychainMetaData(stdOut);
        KeychainSecurityCliStore.parseKeychainMetaData(stdErr, metaData);
        return metaData;
    }

    protected static void write(SecretKind secretKind, String serviceName, String accountName, char[] password) {
        try {
            ProcessBuilder addProcessBuilder = new ProcessBuilder(SECURITY, INTERACTIVE_MODE);
            Object[] commandParts = new Object[]{ADD_GENERIC_PASSWORD, UPDATE_IF_ALREADY_EXISTS, ACCOUNT_PARAMETER, accountName, SERVICE_PARAMETER, serviceName, PASSWORD_PARAMETER, password, KIND_PARAMETER, secretKind.name()};
            Process process = addProcessBuilder.start();
            try (PrintWriter writer = new PrintWriter(process.getOutputStream());){
                KeychainSecurityCliStore.printQuotedObjects(writer, commandParts);
                writer.println();
            }
            int result = process.waitFor();
            String stdOut = KeychainSecurityCliStore.readToString(process.getInputStream());
            String stdErr = KeychainSecurityCliStore.readToString(process.getErrorStream());
            KeychainSecurityCliStore.checkResult(result, stdOut, stdErr);
        }
        catch (IOException | InterruptedException e) {
            throw new Error(e);
        }
    }

    protected void writeTokenKind(String key, SecretKind secretKind, StoredToken token) {
        String accountName = token.getType().getDescription();
        Map<String, Object> metaData = KeychainSecurityCliStore.read(secretKind, key);
        if (!metaData.isEmpty() && !accountName.equals(metaData.get(ACCOUNT_METADATA))) {
            this.deleteByKind(key, secretKind);
        }
        KeychainSecurityCliStore.write(secretKind, key, accountName, token.getValue());
    }

    private static String readToString(InputStream stream) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
            String line;
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                sb.append(line);
                sb.append(System.getProperty("line.separator"));
            }
            String string = sb.toString();
            return string;
        }
    }

    private static void printQuotedObjects(PrintWriter writer, Object[] value) {
        for (int i = 0; i < value.length; ++i) {
            if (i > 0) {
                writer.print(' ');
            }
            writer.print('\"');
            if (value[i] instanceof char[]) {
                writer.print((char[])value[i]);
            } else {
                writer.print(value[i]);
            }
            writer.print('\"');
        }
    }

    static enum AttributeParsingState {
        Spaces,
        StringKey,
        HexKey,
        BeforeType,
        Type,
        AfterType,
        BeforeValue,
        NullValue,
        StringValue,
        TimeDateValue,
        ValueFinished;

    }

    static enum SecretKind {
        Credential,
        Token,
        TokenPair_Access_Token,
        TokenPair_Refresh_Token;

    }
}

