/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.credentialstorage.implementation.posix.keyring;

import com.microsoft.credentialstorage.implementation.posix.keyring.GnomeKeyringBackedSecureStore;
import com.microsoft.credentialstorage.model.StoredCredential;
import java.util.Objects;

public final class GnomeKeyringBackedCredentialStore
extends GnomeKeyringBackedSecureStore<StoredCredential> {
    @Override
    public boolean add(String key, StoredCredential secret) {
        Objects.requireNonNull(key, "key cannot be null");
        Objects.requireNonNull(secret, "secret cannot be null");
        if (INSTANCE != null && SCHEMA != null) {
            logger.info("Adding a {} for {}", (Object)this.getType(), (Object)key);
            int result = this.writeSecret(key, secret.getUsername(), secret.getPassword());
            return GnomeKeyringBackedCredentialStore.checkResult(result, "Could not save secret to the storage.");
        }
        logger.warn("Gnome Keyring is not available.");
        return false;
    }

    @Override
    protected StoredCredential create(String username, char[] secret) {
        return new StoredCredential(username, secret);
    }

    @Override
    protected String getType() {
        return "Credential";
    }
}

