/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.credentialstorage.implementation.posix.keyring;

import com.microsoft.credentialstorage.implementation.posix.keyring.GnomeKeyringBackedSecureStore;
import com.microsoft.credentialstorage.model.StoredToken;
import com.microsoft.credentialstorage.model.StoredTokenPair;
import com.microsoft.credentialstorage.model.StoredTokenType;
import java.util.Objects;

public final class GnomeKeyringBackedTokenPairStore
extends GnomeKeyringBackedSecureStore<StoredTokenPair> {
    private static final String ACCESS_TOKEN = "/accessToken";
    private static final String REFRESH_TOKEN = "/refreshToken";

    @Override
    public StoredTokenPair get(String key) {
        Objects.requireNonNull(key, "key cannot be null");
        logger.info("Getting {} for {}", (Object)this.getType(), (Object)key);
        StoredToken accessToken = this.readSecret(key + ACCESS_TOKEN, (userName, password) -> new StoredToken((char[])password, StoredTokenType.ACCESS));
        StoredToken refreshToken = this.readSecret(key + REFRESH_TOKEN, (userName, password) -> new StoredToken((char[])password, StoredTokenType.REFRESH));
        if (accessToken == null && refreshToken == null) {
            return null;
        }
        return new StoredTokenPair(accessToken, refreshToken);
    }

    @Override
    public boolean add(String key, StoredTokenPair secret) {
        Objects.requireNonNull(key, "key cannot be null");
        Objects.requireNonNull(secret, "secret cannot be null");
        logger.info("Adding a {} for {}", (Object)this.getType(), (Object)key);
        int result = this.writeSecret(key + ACCESS_TOKEN, secret.getAccessToken().getType().getDescription(), secret.getAccessToken().getValue());
        GnomeKeyringBackedTokenPairStore.checkResult(result, "Could not save access token to the storage.");
        result = this.writeSecret(key + REFRESH_TOKEN, secret.getRefreshToken().getType().getDescription(), secret.getRefreshToken().getValue());
        return GnomeKeyringBackedTokenPairStore.checkResult(result, "Could not save refresh token to the storage.");
    }

    @Override
    public boolean delete(String key) {
        Objects.requireNonNull(key, "key cannot be null");
        logger.info("Deleting {} for {}", (Object)this.getType(), (Object)key);
        int result = this.deleteSecret(key + ACCESS_TOKEN);
        GnomeKeyringBackedTokenPairStore.checkResult(result, "Could not delete access token from storage");
        result = this.deleteSecret(key + REFRESH_TOKEN);
        return GnomeKeyringBackedTokenPairStore.checkResult(result, "Could not delete refresh token from storage");
    }

    @Override
    protected StoredTokenPair create(String username, char[] secret) {
        return null;
    }

    @Override
    protected String getType() {
        return "OAuth2Token";
    }
}

