/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.credentialstorage.implementation.posix.keyring;

import com.microsoft.credentialstorage.implementation.posix.keyring.GnomeKeyringBackedSecureStore;
import com.microsoft.credentialstorage.model.StoredToken;
import com.microsoft.credentialstorage.model.StoredTokenType;
import java.util.Objects;

public final class GnomeKeyringBackedTokenStore
extends GnomeKeyringBackedSecureStore<StoredToken> {
    @Override
    protected StoredToken create(String username, char[] secret) {
        return new StoredToken(secret, StoredTokenType.fromDescription(username));
    }

    @Override
    public boolean add(String key, StoredToken token) {
        Objects.requireNonNull(key, "key cannot be null");
        Objects.requireNonNull(token, "secret cannot be null");
        logger.info("Adding a {} for {}", (Object)this.getType(), (Object)key);
        int result = this.writeSecret(key, token.getType().getDescription(), token.getValue());
        return GnomeKeyringBackedTokenStore.checkResult(result, "Could not save secret to the storage.");
    }

    @Override
    protected String getType() {
        return "Token";
    }
}

