/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.credentialstorage.implementation.posix.libsecret;

import com.microsoft.credentialstorage.implementation.posix.internal.GLibLibrary;
import com.microsoft.credentialstorage.implementation.posix.libsecret.LibSecretBackedSecureStore;
import com.microsoft.credentialstorage.model.StoredToken;
import com.microsoft.credentialstorage.model.StoredTokenType;
import com.sun.jna.ptr.PointerByReference;
import java.util.Objects;

public final class LibSecretBackedTokenStore
extends LibSecretBackedSecureStore<StoredToken> {
    @Override
    protected StoredToken create(String username, char[] secret) {
        return new StoredToken(secret, StoredTokenType.fromDescription(username));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(String key, StoredToken token) {
        Objects.requireNonNull(key, "key cannot be null");
        Objects.requireNonNull(token, "secret cannot be null");
        logger.info("Adding a {} for {}", (Object)this.getType(), (Object)key);
        PointerByReference error = new PointerByReference();
        try {
            boolean bl = this.writeSecret(key, token.getType().getDescription(), token.getValue(), error);
            return bl;
        }
        finally {
            if (error.getValue() != null) {
                GLibLibrary.INSTANCE.g_error_free(error.getValue());
            }
        }
    }

    @Override
    protected String getType() {
        return "Token";
    }
}

