/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.credentialstorage.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public enum StoredTokenType {
    UNKNOWN("Unknown"),
    ACCESS("Access Token"),
    REFRESH("Refresh Token"),
    PERSONAL("Personal Access Token"),
    FEDERATED("Federated Authentication Token"),
    TEST("Test-only Token");

    private static final Map<String, StoredTokenType> VALUE_MAP;
    private final String description;

    private StoredTokenType(String description) {
        this.description = description;
    }

    public static StoredTokenType fromDescription(String description) {
        return VALUE_MAP.getOrDefault(description, PERSONAL);
    }

    public String getDescription() {
        return this.description;
    }

    static {
        HashMap<String, StoredTokenType> valueMap = new HashMap<String, StoredTokenType>();
        for (StoredTokenType storedTokenType : StoredTokenType.values()) {
            valueMap.put(storedTokenType.getDescription(), storedTokenType);
        }
        VALUE_MAP = Collections.unmodifiableMap(valueMap);
    }
}

