/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.constructs.web;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.http.Cookie;
import net.sf.ehcache.constructs.web.AlreadyGzippedException;
import net.sf.ehcache.constructs.web.Header;
import net.sf.ehcache.constructs.web.HttpDateFormatter;
import net.sf.ehcache.constructs.web.SerializableCookie;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(PageInfo.class);
    private static final int FOUR_KB = 4196;
    private static final int GZIP_MAGIC_NUMBER_BYTE_1 = 31;
    private static final int GZIP_MAGIC_NUMBER_BYTE_2 = -117;
    private static final long ONE_YEAR_IN_SECONDS = 31536000L;
    private final ArrayList<Header<? extends Serializable>> responseHeaders = new ArrayList();
    private final ArrayList serializableCookies = new ArrayList();
    private String contentType;
    private byte[] gzippedBody;
    private byte[] ungzippedBody;
    private int statusCode;
    private boolean storeGzipped;
    private Date created;
    private long timeToLiveSeconds;
    private transient HttpDateFormatter httpDateFormatter;

    @Deprecated
    public PageInfo(int statusCode, String contentType, Collection headers, Collection cookies, byte[] body, boolean storeGzipped, long timeToLiveSeconds) throws AlreadyGzippedException {
        ArrayList<Header<? extends Serializable>> stringHeadersBuilder;
        if (headers == null) {
            stringHeadersBuilder = null;
        } else {
            stringHeadersBuilder = new ArrayList<Header<? extends Serializable>>(headers.size());
            for (String[] header : headers) {
                stringHeadersBuilder.add(new Header<String>(header[0], header[1]));
            }
        }
        this.init(statusCode, contentType, stringHeadersBuilder, cookies, body, storeGzipped, timeToLiveSeconds);
    }

    public PageInfo(int statusCode, String contentType, Collection cookies, byte[] body, boolean storeGzipped, long timeToLiveSeconds, Collection<Header<? extends Serializable>> headers) throws AlreadyGzippedException {
        this.init(statusCode, contentType, headers, cookies, body, storeGzipped, timeToLiveSeconds);
    }

    private void init(int statusCode, String contentType, Collection<Header<? extends Serializable>> headers, Collection cookies, byte[] body, boolean storeGzipped, long timeToLiveSeconds) throws AlreadyGzippedException {
        if (headers != null) {
            this.responseHeaders.addAll(headers);
        }
        this.setTimeToLiveWithCheckForNeverExpires(timeToLiveSeconds);
        this.created = new Date();
        this.contentType = contentType;
        this.storeGzipped = storeGzipped;
        this.statusCode = statusCode;
        this.timeToLiveSeconds = timeToLiveSeconds;
        try {
            if (storeGzipped) {
                this.ungzippedBody = null;
                this.gzippedBody = this.isBodyParameterGzipped() ? body : this.gzip(body);
            } else {
                if (this.isBodyParameterGzipped()) {
                    throw new IllegalArgumentException("Non gzip content has been gzipped.");
                }
                this.ungzippedBody = body;
            }
        }
        catch (IOException e) {
            LOG.error("Error ungzipping gzipped body", (Throwable)e);
        }
    }

    protected void setTimeToLiveWithCheckForNeverExpires(long timeToLiveSeconds) {
        this.timeToLiveSeconds = timeToLiveSeconds == 0L || timeToLiveSeconds > 31536000L ? 31536000L : timeToLiveSeconds;
    }

    private void extractCookies(Collection cookies) {
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                this.serializableCookies.add(new SerializableCookie(cookie));
            }
        }
    }

    private byte[] gzip(byte[] ungzipped) throws IOException, AlreadyGzippedException {
        if (PageInfo.isGzipped(ungzipped)) {
            throw new AlreadyGzippedException("The byte[] is already gzipped. It should not be gzipped again.");
        }
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        GZIPOutputStream gzipOutputStream = new GZIPOutputStream(bytes);
        gzipOutputStream.write(ungzipped);
        gzipOutputStream.close();
        return bytes.toByteArray();
    }

    private boolean isBodyParameterGzipped() {
        for (Header<? extends Serializable> header : this.responseHeaders) {
            if (!"gzip".equals(header.getValue())) continue;
            return true;
        }
        return false;
    }

    public static boolean isGzipped(byte[] candidate) {
        if (candidate == null || candidate.length < 2) {
            return false;
        }
        return candidate[0] == 31 && candidate[1] == -117;
    }

    public String getContentType() {
        return this.contentType;
    }

    public byte[] getGzippedBody() {
        if (this.storeGzipped) {
            return this.gzippedBody;
        }
        return null;
    }

    private HttpDateFormatter getHttpDateFormatter() {
        if (this.httpDateFormatter == null) {
            this.httpDateFormatter = new HttpDateFormatter();
        }
        return this.httpDateFormatter;
    }

    @Deprecated
    public List getResponseHeaders() {
        ArrayList<String[]> headers = new ArrayList<String[]>(this.responseHeaders.size());
        block5: for (Header<? extends Serializable> header : this.responseHeaders) {
            switch (header.getType()) {
                case STRING: {
                    headers.add(new String[]{header.getName(), (String)((Object)header.getValue())});
                    continue block5;
                }
                case DATE: {
                    HttpDateFormatter localHttpDateFormatter = this.getHttpDateFormatter();
                    String formattedValue = localHttpDateFormatter.formatHttpDate(new Date((Long)header.getValue()));
                    headers.add(new String[]{header.getName(), formattedValue});
                    continue block5;
                }
                case INT: {
                    headers.add(new String[]{header.getName(), ((Integer)header.getValue()).toString()});
                    continue block5;
                }
            }
            throw new IllegalArgumentException("No mapping for Header: " + header);
        }
        return Collections.unmodifiableList(headers);
    }

    public List<Header<? extends Serializable>> getHeaders() {
        return this.responseHeaders;
    }

    public List getSerializableCookies() {
        return this.serializableCookies;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public byte[] getUngzippedBody() throws IOException {
        if (this.storeGzipped) {
            return this.ungzip(this.gzippedBody);
        }
        return this.ungzippedBody;
    }

    private byte[] ungzip(byte[] gzipped) throws IOException {
        GZIPInputStream inputStream = new GZIPInputStream(new ByteArrayInputStream(gzipped));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(gzipped.length);
        byte[] buffer = new byte[4196];
        int bytesRead = 0;
        while (bytesRead != -1) {
            bytesRead = inputStream.read(buffer, 0, 4196);
            if (bytesRead == -1) continue;
            byteArrayOutputStream.write(buffer, 0, bytesRead);
        }
        byte[] ungzipped = byteArrayOutputStream.toByteArray();
        inputStream.close();
        byteArrayOutputStream.close();
        return ungzipped;
    }

    public boolean hasGzippedBody() {
        return this.gzippedBody != null;
    }

    public boolean hasUngzippedBody() {
        return this.ungzippedBody != null;
    }

    public boolean isOk() {
        return this.statusCode == 200;
    }

    public Date getCreated() {
        return this.created;
    }

    public long getTimeToLiveSeconds() {
        return this.timeToLiveSeconds;
    }
}

